% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_val.R
\name{crossval}
\alias{crossval}
\title{Cross-Validation of BB Learning}
\usage{
crossval(object, lambda = 0.1, lambdah = 0, eps = 0.9, nfold = 5,
  method = "pseudo", naive = FALSE, use.auc = TRUE, verbose = 1,
  useC = TRUE, prior.count = TRUE, progress.bar = FALSE,
  fixL = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{bbl} containing data.}

\item{lambda}{Vector of L2 penalizer values for \code{method = 'pseudo'}. Inferences
will be repeated for each value. Restricited to non-negative values.}

\item{lambdah}{L2 penalizer in \code{method = 'pseudo'} applied to
parameter \code{h}. In contrast to \code{lambda},
only a single value is allowed.}

\item{eps}{Vector of regularization parameters, \eqn{\epsilon\in[0,1]},
for \code{method = 'mf'}. Inference will be repeeated
for each value.}

\item{nfold}{Number of folds for training/validation split.}

\item{method}{\code{c('pseudo','mf')} for pseudo-likelihood maximization or
mean field.}

\item{naive}{Naive Bayes (no interactions). Equivalent to \code{method = 'mf'}
together with \code{eps = 0}.}

\item{use.auc}{Use AUC as the measure of prediction accuracy. Only works
if response groups are binary. If \code{FALSE}, mean prediction group
accuracy will be used as score.}

\item{verbose}{Verbosity level. Downgraded when relayed into \code{\link{train}}.}

\item{useC}{Use \code{C++} version in \code{\link{predict}} method of \code{bbl}.}

\item{prior.count}{Use prior count in \code{method = 'mf'}.}

\item{progress.bar}{Display progress bar in \code{\link{predict}}.}

\item{fixL}{Do not alter the levels of predictors in training step.}

\item{...}{Other parameters to \code{\link{mlestimate}}.}
}
\value{
Data frame of regularization parameter values and validation scores.
}
\description{
Run multiple fittings of \code{bbl} model with training/validation
division of data
}
\details{
The \code{data} slot of \code{object} is split into training and validation
subsets of (\code{nfold}-1):1 ratio. The model is trained with the
former and validated on the latter. Individual division/fold results are
combined into validation result for all instances in the data set and
prediction score is evaluated using the known response group
identity.
}
\examples{
set.seed(513)
m <- 5
n <- 100
predictors <- list()
for(i in 1:m) predictors[[i]] <- c('a','c','g','t')

par0 <- randompar(predictors)
xi0 <- sample_xi(nsample=n, predictors=predictors, h=par0$h, J=par0$J)
par1 <- randompar(predictors, h0=0.1, J0=0.1)
xi1 <- sample_xi(nsample=n, predictors=predictors, h=par1$h, J=par1$J)
xi <- rbind(xi0, xi1)
dat <- cbind(xi, data.frame(y=c(rep('control',n),rep('case',n))))
model <- bbl(data=dat, groups=c('control','case'))

cv <- crossval(object=model, method='mf', eps=seq(0.1,0.9,0.1))
plot(cv, type='b')
}
