% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_residuals.censReg.R
\name{residuals.censReg}
\alias{residuals.censReg}
\title{Extract Model Residuals}
\usage{
\method{residuals}{censReg}(object, type = "working", suppress.na.action = FALSE, ...)
}
\arguments{
\item{object}{an object of class "censReg"---output from \code{censReg}}

\item{type}{The type of residuals, see \bold{Details}.}

\item{suppress.na.action}{logical, suppress the effects of the
\code{na.action} in the call to \code{censReg} and return only the fitted
values corresponding to the fitted data.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
The residuals from the regression as specified by \code{type}.
}
\description{
Extracts the residuals from a censored regression object: method 
for "censReg" object.
}
\details{
The value for \code{type} can be any one of the following:
\tabular{ll}{ Value \tab Description\cr
"working" \tab Residuals with censored residuals replaced by their expected
values\cr
"response" \tab Residuals from the linear predictor\cr
"influence" \tab An estimate of Cook's D values based on "working"
residuals\cr
"leverage" \tab The hat diagonals\cr
"S-L" \tab The square-root of the absolute value of the residuals with
censored residuals replaced by their expected value\cr }
Also, any other value of \code{type} for \code{\link{residuals.survreg}}
can be used to obtain those residuals. Note that "working" and "response"
are defined in the table above, in keeping with older versions of
\code{censReg}.
}
\keyword{internal}
\keyword{regression}
