% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_eff.R
\name{ge_eff}
\alias{ge_eff}
\alias{ge_eff.default}
\title{Genotype by Environment Interaction Effects}
\usage{
\method{ge_eff}{default}(.data, .y, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Genotype by Environment Interaction Effects
}
\description{
Calcuates Genotype by Environment Interaction Effects
}
\examples{

data(cultivo2008)
ge_eff(
    .data  = cultivo2008
   , .y    = y
   , .gen  = entry
   , .env  = site
   )


}
\references{
Perez-Elizalde, S., Jarquin, D., and Crossa, J. (2011)
 A General Bayesian Estimation Method of Linear–Bilinear Models
 Applied to Plant Breeding Trials With Genotype × Environment Interaction.
 \emph{Journal of Agricultural, Biological, and Environmental Statistics},
  17, 15–37.  (\href{https://link.springer.com/article/10.1007/s13253-011-0063-9}{doi:10.1007/s13253-011-0063-9})
}
\author{
\enumerate{
    \item Muhammad Yaseen (\email{myaseen208@gmail.com})
   }
}
