% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_classification_summary_cv.R
\name{naive_classification_summary_cv}
\alias{naive_classification_summary_cv}
\title{Cross-Validated Posterior Classification Summaries for a Naive Bayes model}
\usage{
naive_classification_summary_cv(model, data, y, k = 10)
}
\arguments{
\item{model}{a naiveBayes model object with categorical y}

\item{data}{data frame including the variables in the model}

\item{y}{a character string indicating the y variable in data}

\item{k}{the number of folds to use for cross validation}
}
\value{
a list
}
\description{
Given a set of observed data including a categorical response variable y 
and a naiveBayes model of y, 
this function returns a cross validated confusion matrix by which to assess 
the model's posterior classification quality.
}
\examples{
data(penguins_bayes, package = "bayesrules")
example_model <- e1071::naiveBayes(species ~ bill_length_mm, data = penguins_bayes)
naive_classification_summary_cv(model = example_model, data = penguins_bayes, y = "species", k = 2)
}
