% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.bayeslincom}
\alias{plot.bayeslincom}
\title{Plot a linear combination of posterior samples}
\usage{
\method{plot}{bayeslincom}(
  x,
  point_col = "black",
  hist_col = "black",
  hist_fill = "gray",
  bar_col = "steelblue",
  bins = 30,
  display_comb_strings = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{bayeslincom}}

\item{point_col}{Color for point indicating mean of posterior}

\item{hist_col}{Color for histogram edges}

\item{hist_fill}{Color for histogram bars}

\item{bar_col}{Color of bar for credible interval}

\item{bins}{Number of bins}

\item{display_comb_strings}{If \code{TRUE}, displays full strings for
combinations in \code{ggplot} facets  when there
is more than one combination in \code{x}}

\item{...}{Currently ignored}
}
\value{
An object of class \code{ggplot}
}
\description{
Plot a linear combination of posterior samples
}
\examples{
Y <- BGGM::ptsd
colnames(Y) <- letters[1:20]
est <- BGGM::estimate(Y)
bggm_comb <- lin_comb("a--c + a--d > b--c + b--d",
                      obj = est,
                      ci = 0.90,
                      rope = c(-0.1, 0.1))
plot(bggm_comb)
}
