% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_test_b.R
\name{sign_test_b}
\alias{sign_test_b}
\title{Paired sign test}
\usage{
sign_test_b(
  x,
  y,
  p0 = 0.5,
  prior = "jeffreys",
  prior_shapes,
  ROPE,
  CI_level = 0.95,
  plot = TRUE
)
}
\arguments{
\item{x}{Either numeric vector or binary vector.  If the former,
\eqn{z_i = 1_{[x_i > y_i]}} if \code{y} is supplied, else
\eqn{z_i = 1_{[x_i > 0]}}.  If the latter, then \eqn{z_i = x_i}.}

\item{y}{Optional numeric vector to pair with \code{x}.}

\item{p0}{\code{sign_test_b} will return the posterior probability that
\eqn{p < p0}.  Defaults to 0.5, as is most typical in the sign test.}

\item{prior}{Either "jeffreys" (Beta(1/2,1/2)) or "uniform" (Beta(1,1)).
This is ignored if prior_shapes is provided.}

\item{prior_shapes}{Vector of length two, giving the shape parameters
for the beta distribution that will act as the prior on the probability
that \eqn{z_i = 1}.}

\item{ROPE}{positive numeric of length 1 or 2.  If of length 1, then ROPE
is taken to be \eqn{p0\pm }ROPE. Defaults to \eqn{\pm 0.05}.}

\item{CI_level}{The posterior probability to be contained in the
credible interval for \eqn{p}.}

\item{plot}{logical.  Should a plot be shown?}
}
\value{
(returned invisible) A list with the following:
\itemize{
\item \code{posterior_mean}: Posterior mean of the median difference
\item \code{CI}: Credible interval for the median difference
\item \code{Pr_less_than_p}: Posterior probability that the proportion of
differences that are positive is less than the argument \code{p0}.
\item \code{ROPE_bounds}: ROPE bounds for the proportion of differences
that are positive
\item \code{ROPE}: Posterior probability that the proportion of differences
which are positive falls in the ROPE
\item \code{prop_plot}: Prior and posterior plot
\item \code{posterior_parameters}: Posterior beta shape parameters for the
proportion of differences which are positive
}
}
\description{
Sign test for paired data.
}
\details{
The sign test looks at \eqn{z_i:= 1_{[x_i > y_i]}} rather than trying to model the
distribution of \eqn{(x_i,y_i)}.  \code{sign_test_b} then uses the fact that
\deqn{
 z_i \overset{iid}{\sim} Bernoulli(p)
}
and then makes inference on \eqn{p}.  The prior on \eqn{p} is
\deqn{
 p \sim Beta(a,b),
}
where \eqn{a} and \eqn{b} are given by the argument \code{prior_shapes}.  If
\code{prior_shapes} is missing and \code{prior = "jeffreys"}, then a
Jeffreys prior will be used (\eqn{Beta(1/2,1/2)}), and if
\code{prior = "uniform"}, then a uniform prior will be used (\eqn{Beta(1,1)}).
}
\examples{
\donttest{
# Single population
sign_test_b(x = rnorm(50))

## Change ROPE
sign_test_b(x = rnorm(50),
            ROPE = 0.1)

## Change the prior
sign_test_b(x = rnorm(50),
            prior = "uniform")
sign_test_b(x = rnorm(50),
            prior_shapes = c(2,2))

## Two populations
sign_test_b(x = rnorm(50,1),
            y = rnorm(50,0))

## Change reference probability
sign_test_b(x = rnorm(50,1),
            y = rnorm(50,0),
            p0 = 0.7)
}

}
