% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_trends.R
\name{rotate_trends}
\alias{rotate_trends}
\title{Rotate the trends from a DFA}
\usage{
rotate_trends(fitted_model, conf_level = 0.95, invert = FALSE)
}
\arguments{
\item{fitted_model}{Output from \code{\link[=fit_dfa]{fit_dfa()}}.}

\item{conf_level}{Probability level for CI.}

\item{invert}{Whether to invert the trends and loadings for plotting purposes}
}
\description{
Rotate the trends from a DFA
}
\examples{
set.seed(42)
s <- sim_dfa(num_trends = 1, num_years = 20, num_ts = 3)
# only 1 chain and 800 iterations used so example runs quickly:
m <- fit_dfa(y = s$y_sim, iter = 50, chains = 1)
r <- rotate_trends(m)
plot_trends(r)
}
