// Generated by rstantools.  Do not edit by hand.

/*
    path is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    path is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with path.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_dfa_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_dfa");
    reader.add_event(661, 659, "end", "model_dfa");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
subset(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& x,
           const int& drop,
           const int& P, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 9;
        validate_non_negative_index("result", "(P - 1)", (P - 1));
        validate_non_negative_index("result", "(P - 1)", (P - 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> result((P - 1), (P - 1));
        stan::math::initialize(result, DUMMY_VAR__);
        stan::math::fill(result, DUMMY_VAR__);
        current_statement_begin__ = 11;
        int rowindx(0);
        (void) rowindx;  // dummy to suppress unused var warning
        stan::math::fill(rowindx, std::numeric_limits<int>::min());
        current_statement_begin__ = 12;
        int colindx(0);
        (void) colindx;  // dummy to suppress unused var warning
        stan::math::fill(colindx, std::numeric_limits<int>::min());
        current_statement_begin__ = 13;
        stan::math::assign(rowindx, 0);
        current_statement_begin__ = 14;
        for (int i = 1; i <= P; ++i) {
            current_statement_begin__ = 15;
            if (as_bool(logical_neq(i, drop))) {
                current_statement_begin__ = 16;
                stan::math::assign(rowindx, (rowindx + 1));
                current_statement_begin__ = 17;
                stan::math::assign(colindx, 0);
                current_statement_begin__ = 18;
                for (int j = 1; j <= P; ++j) {
                    current_statement_begin__ = 19;
                    if (as_bool(logical_neq(j, drop))) {
                        current_statement_begin__ = 20;
                        stan::math::assign(colindx, (colindx + 1));
                        current_statement_begin__ = 21;
                        stan::model::assign(result, 
                                    stan::model::cons_list(stan::model::index_uni(rowindx), stan::model::cons_list(stan::model::index_uni(colindx), stan::model::nil_index_list())), 
                                    get_base1(x, i, j, "x", 1), 
                                    "assigning variable result");
                    }
                }
            }
        }
        current_statement_begin__ = 27;
        return stan::math::promote_scalar<fun_return_scalar_t__>(result);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct subset_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& x,
           const int& drop,
           const int& P, std::ostream* pstream__) const {
        return subset(x, drop, P, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
subsetvec(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& x,
              const int& drop,
              const int& P, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 34;
        validate_non_negative_index("result", "(P - 1)", (P - 1));
        validate_non_negative_index("result", "1", 1);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> result((P - 1), 1);
        stan::math::initialize(result, DUMMY_VAR__);
        stan::math::fill(result, DUMMY_VAR__);
        current_statement_begin__ = 36;
        int rowindx(0);
        (void) rowindx;  // dummy to suppress unused var warning
        stan::math::fill(rowindx, std::numeric_limits<int>::min());
        current_statement_begin__ = 37;
        stan::math::assign(rowindx, 0);
        current_statement_begin__ = 38;
        for (int i = 1; i <= P; ++i) {
            current_statement_begin__ = 39;
            if (as_bool(logical_neq(i, drop))) {
                current_statement_begin__ = 40;
                stan::math::assign(rowindx, (rowindx + 1));
                current_statement_begin__ = 41;
                stan::model::assign(result, 
                            stan::model::cons_list(stan::model::index_uni(rowindx), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            get_base1(x, i, drop, "x", 1), 
                            "assigning variable result");
            }
        }
        current_statement_begin__ = 45;
        return stan::math::promote_scalar<fun_return_scalar_t__>(result);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct subsetvec_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& x,
              const int& drop,
              const int& P, std::ostream* pstream__) const {
        return subsetvec(x, drop, P, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
subsetvec2(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
               const int& drop,
               const int& P, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 52;
        validate_non_negative_index("result", "(P - 1)", (P - 1));
        validate_non_negative_index("result", "1", 1);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> result((P - 1), 1);
        stan::math::initialize(result, DUMMY_VAR__);
        stan::math::fill(result, DUMMY_VAR__);
        current_statement_begin__ = 54;
        int rowindx(0);
        (void) rowindx;  // dummy to suppress unused var warning
        stan::math::fill(rowindx, std::numeric_limits<int>::min());
        current_statement_begin__ = 55;
        stan::math::assign(rowindx, 0);
        current_statement_begin__ = 56;
        for (int i = 1; i <= P; ++i) {
            current_statement_begin__ = 57;
            if (as_bool(logical_neq(i, drop))) {
                current_statement_begin__ = 58;
                stan::math::assign(rowindx, (rowindx + 1));
                current_statement_begin__ = 59;
                stan::model::assign(result, 
                            stan::model::cons_list(stan::model::index_uni(rowindx), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            get_base1(x, i, "x", 1), 
                            "assigning variable result");
            }
        }
        current_statement_begin__ = 63;
        return stan::math::promote_scalar<fun_return_scalar_t__>(result);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct subsetvec2_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
               const int& drop,
               const int& P, std::ostream* pstream__) const {
        return subsetvec2(x, drop, P, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_dfa
  : public stan::model::model_base_crtp<model_dfa> {
private:
        int N;
        int P;
        int K;
        int nZ;
        std::vector<int> row_indx;
        std::vector<int> col_indx;
        int nVariances;
        std::vector<int> varIndx;
        int nZero;
        std::vector<int> row_indx_z;
        std::vector<int> col_indx_z;
        int n_pos;
        std::vector<int> row_indx_pos;
        std::vector<int> col_indx_pos;
        std::vector<double> y;
        std::vector<int> y_int;
        int n_na;
        std::vector<int> row_indx_na;
        std::vector<int> col_indx_na;
        double nu_fixed;
        int estimate_nu;
        int use_normal;
        int est_cor;
        int est_phi;
        int est_theta;
        int num_obs_covar;
        int n_obs_covar;
        std::vector<std::vector<int> > obs_covar_index;
        std::vector<double> obs_covar_value;
        std::vector<int> match_obs_covar;
        int num_pro_covar;
        int n_pro_covar;
        std::vector<std::vector<int> > pro_covar_index;
        std::vector<double> pro_covar_value;
        std::vector<double> z_bound;
        int long_format;
        int proportional_model;
        int est_sigma_process;
        int n_sigma_process;
        int est_rw;
        int est_spline;
        int est_gp;
        int n_knots;
        matrix_d B_spline;
        std::vector<double> knot_locs;
        matrix_d distKnots21_pred;
        int obs_model;
        int est_sigma_params;
        int est_gamma_params;
        int est_nb2_params;
        std::vector<double> gp_theta_prior;
        int n_pcor;
        int n_loglik;
        vector_d zeros;
        std::vector<double> data_locs;
        vector_d alpha_vec;
        vector_d muZeros;
        double gp_delta;
public:
    model_dfa(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_dfa(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_dfa_namespace::model_dfa";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 69;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 0);
            current_statement_begin__ = 70;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 0);
            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "nZ", "int", context__.to_vec());
            nZ = int(0);
            vals_i__ = context__.vals_i("nZ");
            pos__ = 0;
            nZ = vals_i__[pos__++];
            check_greater_or_equal(function__, "nZ", nZ, 0);
            current_statement_begin__ = 72;
            validate_non_negative_index("row_indx", "nZ", nZ);
            context__.validate_dims("data initialization", "row_indx", "int", context__.to_vec(nZ));
            row_indx = std::vector<int>(nZ, int(0));
            vals_i__ = context__.vals_i("row_indx");
            pos__ = 0;
            size_t row_indx_k_0_max__ = nZ;
            for (size_t k_0__ = 0; k_0__ < row_indx_k_0_max__; ++k_0__) {
                row_indx[k_0__] = vals_i__[pos__++];
            }
            size_t row_indx_i_0_max__ = nZ;
            for (size_t i_0__ = 0; i_0__ < row_indx_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "row_indx[i_0__]", row_indx[i_0__], 0);
            }
            current_statement_begin__ = 73;
            validate_non_negative_index("col_indx", "nZ", nZ);
            context__.validate_dims("data initialization", "col_indx", "int", context__.to_vec(nZ));
            col_indx = std::vector<int>(nZ, int(0));
            vals_i__ = context__.vals_i("col_indx");
            pos__ = 0;
            size_t col_indx_k_0_max__ = nZ;
            for (size_t k_0__ = 0; k_0__ < col_indx_k_0_max__; ++k_0__) {
                col_indx[k_0__] = vals_i__[pos__++];
            }
            size_t col_indx_i_0_max__ = nZ;
            for (size_t i_0__ = 0; i_0__ < col_indx_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "col_indx[i_0__]", col_indx[i_0__], 0);
            }
            current_statement_begin__ = 74;
            context__.validate_dims("data initialization", "nVariances", "int", context__.to_vec());
            nVariances = int(0);
            vals_i__ = context__.vals_i("nVariances");
            pos__ = 0;
            nVariances = vals_i__[pos__++];
            check_greater_or_equal(function__, "nVariances", nVariances, 0);
            current_statement_begin__ = 75;
            validate_non_negative_index("varIndx", "P", P);
            context__.validate_dims("data initialization", "varIndx", "int", context__.to_vec(P));
            varIndx = std::vector<int>(P, int(0));
            vals_i__ = context__.vals_i("varIndx");
            pos__ = 0;
            size_t varIndx_k_0_max__ = P;
            for (size_t k_0__ = 0; k_0__ < varIndx_k_0_max__; ++k_0__) {
                varIndx[k_0__] = vals_i__[pos__++];
            }
            size_t varIndx_i_0_max__ = P;
            for (size_t i_0__ = 0; i_0__ < varIndx_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "varIndx[i_0__]", varIndx[i_0__], 0);
            }
            current_statement_begin__ = 76;
            context__.validate_dims("data initialization", "nZero", "int", context__.to_vec());
            nZero = int(0);
            vals_i__ = context__.vals_i("nZero");
            pos__ = 0;
            nZero = vals_i__[pos__++];
            check_greater_or_equal(function__, "nZero", nZero, 0);
            current_statement_begin__ = 77;
            validate_non_negative_index("row_indx_z", "nZero", nZero);
            context__.validate_dims("data initialization", "row_indx_z", "int", context__.to_vec(nZero));
            row_indx_z = std::vector<int>(nZero, int(0));
            vals_i__ = context__.vals_i("row_indx_z");
            pos__ = 0;
            size_t row_indx_z_k_0_max__ = nZero;
            for (size_t k_0__ = 0; k_0__ < row_indx_z_k_0_max__; ++k_0__) {
                row_indx_z[k_0__] = vals_i__[pos__++];
            }
            size_t row_indx_z_i_0_max__ = nZero;
            for (size_t i_0__ = 0; i_0__ < row_indx_z_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "row_indx_z[i_0__]", row_indx_z[i_0__], 0);
            }
            current_statement_begin__ = 78;
            validate_non_negative_index("col_indx_z", "nZero", nZero);
            context__.validate_dims("data initialization", "col_indx_z", "int", context__.to_vec(nZero));
            col_indx_z = std::vector<int>(nZero, int(0));
            vals_i__ = context__.vals_i("col_indx_z");
            pos__ = 0;
            size_t col_indx_z_k_0_max__ = nZero;
            for (size_t k_0__ = 0; k_0__ < col_indx_z_k_0_max__; ++k_0__) {
                col_indx_z[k_0__] = vals_i__[pos__++];
            }
            size_t col_indx_z_i_0_max__ = nZero;
            for (size_t i_0__ = 0; i_0__ < col_indx_z_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "col_indx_z[i_0__]", col_indx_z[i_0__], 0);
            }
            current_statement_begin__ = 79;
            context__.validate_dims("data initialization", "n_pos", "int", context__.to_vec());
            n_pos = int(0);
            vals_i__ = context__.vals_i("n_pos");
            pos__ = 0;
            n_pos = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_pos", n_pos, 0);
            current_statement_begin__ = 80;
            validate_non_negative_index("row_indx_pos", "n_pos", n_pos);
            context__.validate_dims("data initialization", "row_indx_pos", "int", context__.to_vec(n_pos));
            row_indx_pos = std::vector<int>(n_pos, int(0));
            vals_i__ = context__.vals_i("row_indx_pos");
            pos__ = 0;
            size_t row_indx_pos_k_0_max__ = n_pos;
            for (size_t k_0__ = 0; k_0__ < row_indx_pos_k_0_max__; ++k_0__) {
                row_indx_pos[k_0__] = vals_i__[pos__++];
            }
            size_t row_indx_pos_i_0_max__ = n_pos;
            for (size_t i_0__ = 0; i_0__ < row_indx_pos_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "row_indx_pos[i_0__]", row_indx_pos[i_0__], 0);
            }
            current_statement_begin__ = 81;
            validate_non_negative_index("col_indx_pos", "n_pos", n_pos);
            context__.validate_dims("data initialization", "col_indx_pos", "int", context__.to_vec(n_pos));
            col_indx_pos = std::vector<int>(n_pos, int(0));
            vals_i__ = context__.vals_i("col_indx_pos");
            pos__ = 0;
            size_t col_indx_pos_k_0_max__ = n_pos;
            for (size_t k_0__ = 0; k_0__ < col_indx_pos_k_0_max__; ++k_0__) {
                col_indx_pos[k_0__] = vals_i__[pos__++];
            }
            size_t col_indx_pos_i_0_max__ = n_pos;
            for (size_t i_0__ = 0; i_0__ < col_indx_pos_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "col_indx_pos[i_0__]", col_indx_pos[i_0__], 0);
            }
            current_statement_begin__ = 82;
            validate_non_negative_index("y", "n_pos", n_pos);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(n_pos));
            y = std::vector<double>(n_pos, double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_k_0_max__ = n_pos;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 83;
            validate_non_negative_index("y_int", "n_pos", n_pos);
            context__.validate_dims("data initialization", "y_int", "int", context__.to_vec(n_pos));
            y_int = std::vector<int>(n_pos, int(0));
            vals_i__ = context__.vals_i("y_int");
            pos__ = 0;
            size_t y_int_k_0_max__ = n_pos;
            for (size_t k_0__ = 0; k_0__ < y_int_k_0_max__; ++k_0__) {
                y_int[k_0__] = vals_i__[pos__++];
            }
            size_t y_int_i_0_max__ = n_pos;
            for (size_t i_0__ = 0; i_0__ < y_int_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y_int[i_0__]", y_int[i_0__], 0);
            }
            current_statement_begin__ = 84;
            context__.validate_dims("data initialization", "n_na", "int", context__.to_vec());
            n_na = int(0);
            vals_i__ = context__.vals_i("n_na");
            pos__ = 0;
            n_na = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_na", n_na, 0);
            current_statement_begin__ = 85;
            validate_non_negative_index("row_indx_na", "n_na", n_na);
            context__.validate_dims("data initialization", "row_indx_na", "int", context__.to_vec(n_na));
            row_indx_na = std::vector<int>(n_na, int(0));
            vals_i__ = context__.vals_i("row_indx_na");
            pos__ = 0;
            size_t row_indx_na_k_0_max__ = n_na;
            for (size_t k_0__ = 0; k_0__ < row_indx_na_k_0_max__; ++k_0__) {
                row_indx_na[k_0__] = vals_i__[pos__++];
            }
            size_t row_indx_na_i_0_max__ = n_na;
            for (size_t i_0__ = 0; i_0__ < row_indx_na_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "row_indx_na[i_0__]", row_indx_na[i_0__], 0);
            }
            current_statement_begin__ = 86;
            validate_non_negative_index("col_indx_na", "n_na", n_na);
            context__.validate_dims("data initialization", "col_indx_na", "int", context__.to_vec(n_na));
            col_indx_na = std::vector<int>(n_na, int(0));
            vals_i__ = context__.vals_i("col_indx_na");
            pos__ = 0;
            size_t col_indx_na_k_0_max__ = n_na;
            for (size_t k_0__ = 0; k_0__ < col_indx_na_k_0_max__; ++k_0__) {
                col_indx_na[k_0__] = vals_i__[pos__++];
            }
            size_t col_indx_na_i_0_max__ = n_na;
            for (size_t i_0__ = 0; i_0__ < col_indx_na_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "col_indx_na[i_0__]", col_indx_na[i_0__], 0);
            }
            current_statement_begin__ = 87;
            context__.validate_dims("data initialization", "nu_fixed", "double", context__.to_vec());
            nu_fixed = double(0);
            vals_r__ = context__.vals_r("nu_fixed");
            pos__ = 0;
            nu_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "nu_fixed", nu_fixed, 1);
            current_statement_begin__ = 88;
            context__.validate_dims("data initialization", "estimate_nu", "int", context__.to_vec());
            estimate_nu = int(0);
            vals_i__ = context__.vals_i("estimate_nu");
            pos__ = 0;
            estimate_nu = vals_i__[pos__++];
            current_statement_begin__ = 89;
            context__.validate_dims("data initialization", "use_normal", "int", context__.to_vec());
            use_normal = int(0);
            vals_i__ = context__.vals_i("use_normal");
            pos__ = 0;
            use_normal = vals_i__[pos__++];
            current_statement_begin__ = 90;
            context__.validate_dims("data initialization", "est_cor", "int", context__.to_vec());
            est_cor = int(0);
            vals_i__ = context__.vals_i("est_cor");
            pos__ = 0;
            est_cor = vals_i__[pos__++];
            current_statement_begin__ = 91;
            context__.validate_dims("data initialization", "est_phi", "int", context__.to_vec());
            est_phi = int(0);
            vals_i__ = context__.vals_i("est_phi");
            pos__ = 0;
            est_phi = vals_i__[pos__++];
            current_statement_begin__ = 92;
            context__.validate_dims("data initialization", "est_theta", "int", context__.to_vec());
            est_theta = int(0);
            vals_i__ = context__.vals_i("est_theta");
            pos__ = 0;
            est_theta = vals_i__[pos__++];
            current_statement_begin__ = 93;
            context__.validate_dims("data initialization", "num_obs_covar", "int", context__.to_vec());
            num_obs_covar = int(0);
            vals_i__ = context__.vals_i("num_obs_covar");
            pos__ = 0;
            num_obs_covar = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_obs_covar", num_obs_covar, 0);
            current_statement_begin__ = 94;
            context__.validate_dims("data initialization", "n_obs_covar", "int", context__.to_vec());
            n_obs_covar = int(0);
            vals_i__ = context__.vals_i("n_obs_covar");
            pos__ = 0;
            n_obs_covar = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_obs_covar", n_obs_covar, 0);
            current_statement_begin__ = 95;
            validate_non_negative_index("obs_covar_index", "num_obs_covar", num_obs_covar);
            validate_non_negative_index("obs_covar_index", "3", 3);
            context__.validate_dims("data initialization", "obs_covar_index", "int", context__.to_vec(num_obs_covar,3));
            obs_covar_index = std::vector<std::vector<int> >(num_obs_covar, std::vector<int>(3, int(0)));
            vals_i__ = context__.vals_i("obs_covar_index");
            pos__ = 0;
            size_t obs_covar_index_k_0_max__ = num_obs_covar;
            size_t obs_covar_index_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < obs_covar_index_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < obs_covar_index_k_0_max__; ++k_0__) {
                    obs_covar_index[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 96;
            validate_non_negative_index("obs_covar_value", "num_obs_covar", num_obs_covar);
            context__.validate_dims("data initialization", "obs_covar_value", "double", context__.to_vec(num_obs_covar));
            obs_covar_value = std::vector<double>(num_obs_covar, double(0));
            vals_r__ = context__.vals_r("obs_covar_value");
            pos__ = 0;
            size_t obs_covar_value_k_0_max__ = num_obs_covar;
            for (size_t k_0__ = 0; k_0__ < obs_covar_value_k_0_max__; ++k_0__) {
                obs_covar_value[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 97;
            validate_non_negative_index("match_obs_covar", "num_obs_covar", num_obs_covar);
            context__.validate_dims("data initialization", "match_obs_covar", "int", context__.to_vec(num_obs_covar));
            match_obs_covar = std::vector<int>(num_obs_covar, int(0));
            vals_i__ = context__.vals_i("match_obs_covar");
            pos__ = 0;
            size_t match_obs_covar_k_0_max__ = num_obs_covar;
            for (size_t k_0__ = 0; k_0__ < match_obs_covar_k_0_max__; ++k_0__) {
                match_obs_covar[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 98;
            context__.validate_dims("data initialization", "num_pro_covar", "int", context__.to_vec());
            num_pro_covar = int(0);
            vals_i__ = context__.vals_i("num_pro_covar");
            pos__ = 0;
            num_pro_covar = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_pro_covar", num_pro_covar, 0);
            current_statement_begin__ = 99;
            context__.validate_dims("data initialization", "n_pro_covar", "int", context__.to_vec());
            n_pro_covar = int(0);
            vals_i__ = context__.vals_i("n_pro_covar");
            pos__ = 0;
            n_pro_covar = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_pro_covar", n_pro_covar, 0);
            current_statement_begin__ = 100;
            validate_non_negative_index("pro_covar_index", "num_pro_covar", num_pro_covar);
            validate_non_negative_index("pro_covar_index", "3", 3);
            context__.validate_dims("data initialization", "pro_covar_index", "int", context__.to_vec(num_pro_covar,3));
            pro_covar_index = std::vector<std::vector<int> >(num_pro_covar, std::vector<int>(3, int(0)));
            vals_i__ = context__.vals_i("pro_covar_index");
            pos__ = 0;
            size_t pro_covar_index_k_0_max__ = num_pro_covar;
            size_t pro_covar_index_k_1_max__ = 3;
            for (size_t k_1__ = 0; k_1__ < pro_covar_index_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < pro_covar_index_k_0_max__; ++k_0__) {
                    pro_covar_index[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 101;
            validate_non_negative_index("pro_covar_value", "num_pro_covar", num_pro_covar);
            context__.validate_dims("data initialization", "pro_covar_value", "double", context__.to_vec(num_pro_covar));
            pro_covar_value = std::vector<double>(num_pro_covar, double(0));
            vals_r__ = context__.vals_r("pro_covar_value");
            pos__ = 0;
            size_t pro_covar_value_k_0_max__ = num_pro_covar;
            for (size_t k_0__ = 0; k_0__ < pro_covar_value_k_0_max__; ++k_0__) {
                pro_covar_value[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 102;
            validate_non_negative_index("z_bound", "2", 2);
            context__.validate_dims("data initialization", "z_bound", "double", context__.to_vec(2));
            z_bound = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("z_bound");
            pos__ = 0;
            size_t z_bound_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < z_bound_k_0_max__; ++k_0__) {
                z_bound[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "long_format", "int", context__.to_vec());
            long_format = int(0);
            vals_i__ = context__.vals_i("long_format");
            pos__ = 0;
            long_format = vals_i__[pos__++];
            check_greater_or_equal(function__, "long_format", long_format, 0);
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "proportional_model", "int", context__.to_vec());
            proportional_model = int(0);
            vals_i__ = context__.vals_i("proportional_model");
            pos__ = 0;
            proportional_model = vals_i__[pos__++];
            check_greater_or_equal(function__, "proportional_model", proportional_model, 0);
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "est_sigma_process", "int", context__.to_vec());
            est_sigma_process = int(0);
            vals_i__ = context__.vals_i("est_sigma_process");
            pos__ = 0;
            est_sigma_process = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_sigma_process", est_sigma_process, 0);
            current_statement_begin__ = 106;
            context__.validate_dims("data initialization", "n_sigma_process", "int", context__.to_vec());
            n_sigma_process = int(0);
            vals_i__ = context__.vals_i("n_sigma_process");
            pos__ = 0;
            n_sigma_process = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_sigma_process", n_sigma_process, 0);
            current_statement_begin__ = 107;
            context__.validate_dims("data initialization", "est_rw", "int", context__.to_vec());
            est_rw = int(0);
            vals_i__ = context__.vals_i("est_rw");
            pos__ = 0;
            est_rw = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_rw", est_rw, 0);
            current_statement_begin__ = 108;
            context__.validate_dims("data initialization", "est_spline", "int", context__.to_vec());
            est_spline = int(0);
            vals_i__ = context__.vals_i("est_spline");
            pos__ = 0;
            est_spline = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_spline", est_spline, 0);
            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "est_gp", "int", context__.to_vec());
            est_gp = int(0);
            vals_i__ = context__.vals_i("est_gp");
            pos__ = 0;
            est_gp = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_gp", est_gp, 0);
            current_statement_begin__ = 110;
            context__.validate_dims("data initialization", "n_knots", "int", context__.to_vec());
            n_knots = int(0);
            vals_i__ = context__.vals_i("n_knots");
            pos__ = 0;
            n_knots = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_knots", n_knots, 0);
            current_statement_begin__ = 111;
            validate_non_negative_index("B_spline", "n_knots", n_knots);
            validate_non_negative_index("B_spline", "N", N);
            context__.validate_dims("data initialization", "B_spline", "matrix_d", context__.to_vec(n_knots,N));
            B_spline = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_knots, N);
            vals_r__ = context__.vals_r("B_spline");
            pos__ = 0;
            size_t B_spline_j_2_max__ = N;
            size_t B_spline_j_1_max__ = n_knots;
            for (size_t j_2__ = 0; j_2__ < B_spline_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_spline_j_1_max__; ++j_1__) {
                    B_spline(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 112;
            validate_non_negative_index("knot_locs", "n_knots", n_knots);
            context__.validate_dims("data initialization", "knot_locs", "double", context__.to_vec(n_knots));
            knot_locs = std::vector<double>(n_knots, double(0));
            vals_r__ = context__.vals_r("knot_locs");
            pos__ = 0;
            size_t knot_locs_k_0_max__ = n_knots;
            for (size_t k_0__ = 0; k_0__ < knot_locs_k_0_max__; ++k_0__) {
                knot_locs[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 116;
            validate_non_negative_index("distKnots21_pred", "1", 1);
            validate_non_negative_index("distKnots21_pred", "n_knots", n_knots);
            context__.validate_dims("data initialization", "distKnots21_pred", "matrix_d", context__.to_vec(1,n_knots));
            distKnots21_pred = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(1, n_knots);
            vals_r__ = context__.vals_r("distKnots21_pred");
            pos__ = 0;
            size_t distKnots21_pred_j_2_max__ = n_knots;
            size_t distKnots21_pred_j_1_max__ = 1;
            for (size_t j_2__ = 0; j_2__ < distKnots21_pred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < distKnots21_pred_j_1_max__; ++j_1__) {
                    distKnots21_pred(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 117;
            context__.validate_dims("data initialization", "obs_model", "int", context__.to_vec());
            obs_model = int(0);
            vals_i__ = context__.vals_i("obs_model");
            pos__ = 0;
            obs_model = vals_i__[pos__++];
            current_statement_begin__ = 118;
            context__.validate_dims("data initialization", "est_sigma_params", "int", context__.to_vec());
            est_sigma_params = int(0);
            vals_i__ = context__.vals_i("est_sigma_params");
            pos__ = 0;
            est_sigma_params = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_sigma_params", est_sigma_params, 0);
            check_less_or_equal(function__, "est_sigma_params", est_sigma_params, 1);
            current_statement_begin__ = 119;
            context__.validate_dims("data initialization", "est_gamma_params", "int", context__.to_vec());
            est_gamma_params = int(0);
            vals_i__ = context__.vals_i("est_gamma_params");
            pos__ = 0;
            est_gamma_params = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_gamma_params", est_gamma_params, 0);
            check_less_or_equal(function__, "est_gamma_params", est_gamma_params, 1);
            current_statement_begin__ = 120;
            context__.validate_dims("data initialization", "est_nb2_params", "int", context__.to_vec());
            est_nb2_params = int(0);
            vals_i__ = context__.vals_i("est_nb2_params");
            pos__ = 0;
            est_nb2_params = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_nb2_params", est_nb2_params, 0);
            check_less_or_equal(function__, "est_nb2_params", est_nb2_params, 1);
            current_statement_begin__ = 121;
            validate_non_negative_index("gp_theta_prior", "2", 2);
            context__.validate_dims("data initialization", "gp_theta_prior", "double", context__.to_vec(2));
            gp_theta_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("gp_theta_prior");
            pos__ = 0;
            size_t gp_theta_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < gp_theta_prior_k_0_max__; ++k_0__) {
                gp_theta_prior[k_0__] = vals_r__[pos__++];
            }
            // initialize transformed data variables
            current_statement_begin__ = 124;
            n_pcor = int(0);
            stan::math::fill(n_pcor, std::numeric_limits<int>::min());
            current_statement_begin__ = 125;
            n_loglik = int(0);
            stan::math::fill(n_loglik, std::numeric_limits<int>::min());
            current_statement_begin__ = 126;
            validate_non_negative_index("zeros", "K", K);
            zeros = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            stan::math::fill(zeros, DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("data_locs", "N", N);
            data_locs = std::vector<double>(N, double(0));
            stan::math::fill(data_locs, DUMMY_VAR__);
            current_statement_begin__ = 128;
            validate_non_negative_index("alpha_vec", "(K * proportional_model)", (K * proportional_model));
            alpha_vec = Eigen::Matrix<double, Eigen::Dynamic, 1>((K * proportional_model));
            stan::math::fill(alpha_vec, DUMMY_VAR__);
            current_statement_begin__ = 129;
            validate_non_negative_index("muZeros", "n_knots", n_knots);
            muZeros = Eigen::Matrix<double, Eigen::Dynamic, 1>(n_knots);
            stan::math::fill(muZeros, DUMMY_VAR__);
            current_statement_begin__ = 130;
            gp_delta = double(0);
            stan::math::fill(gp_delta, DUMMY_VAR__);
            stan::math::assign(gp_delta,1e-9);
            // execute transformed data statements
            current_statement_begin__ = 132;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 133;
                stan::model::assign(data_locs, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            i, 
                            "assigning variable data_locs");
            }
            current_statement_begin__ = 135;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 136;
                stan::model::assign(zeros, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable zeros");
            }
            current_statement_begin__ = 138;
            for (int k = 1; k <= n_knots; ++k) {
                current_statement_begin__ = 139;
                stan::model::assign(muZeros, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable muZeros");
            }
            current_statement_begin__ = 143;
            stan::math::assign(n_loglik, n_pos);
            current_statement_begin__ = 144;
            if (as_bool(logical_eq(long_format, 0))) {
                current_statement_begin__ = 145;
                if (as_bool(logical_eq(est_cor, 0))) {
                    current_statement_begin__ = 146;
                    stan::math::assign(n_loglik, (P * N));
                } else {
                    current_statement_begin__ = 148;
                    stan::math::assign(n_loglik, N);
                }
            }
            current_statement_begin__ = 152;
            if (as_bool(logical_eq(est_cor, 0))) {
                current_statement_begin__ = 154;
                stan::math::assign(n_pcor, P);
                current_statement_begin__ = 155;
                if (as_bool(logical_lt(nVariances, 2))) {
                    current_statement_begin__ = 157;
                    stan::math::assign(n_pcor, 2);
                }
            } else {
                current_statement_begin__ = 161;
                stan::math::assign(n_pcor, P);
            }
            current_statement_begin__ = 165;
            if (as_bool(logical_eq(proportional_model, 1))) {
                current_statement_begin__ = 166;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 166;
                    stan::model::assign(alpha_vec, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable alpha_vec");
                }
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 170;
            validate_non_negative_index("devs", "(K * est_rw)", (K * est_rw));
            validate_non_negative_index("devs", "((N - 1) * est_rw)", ((N - 1) * est_rw));
            num_params_r__ += ((K * est_rw) * ((N - 1) * est_rw));
            current_statement_begin__ = 171;
            validate_non_negative_index("x0", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 172;
            validate_non_negative_index("psi", "(K * (1 - proportional_model))", (K * (1 - proportional_model)));
            num_params_r__ += (K * (1 - proportional_model));
            current_statement_begin__ = 173;
            validate_non_negative_index("z", "(nZ * (1 - proportional_model))", (nZ * (1 - proportional_model)));
            num_params_r__ += (nZ * (1 - proportional_model));
            current_statement_begin__ = 174;
            validate_non_negative_index("zpos", "(K * (1 - proportional_model))", (K * (1 - proportional_model)));
            num_params_r__ += (K * (1 - proportional_model));
            current_statement_begin__ = 175;
            validate_non_negative_index("p_z", "K", K);
            validate_non_negative_index("p_z", "(P * proportional_model)", (P * proportional_model));
            num_params_r__ += ((K - 1) * (P * proportional_model));
            current_statement_begin__ = 176;
            validate_non_negative_index("spline_a", "(K * est_spline)", (K * est_spline));
            validate_non_negative_index("spline_a", "(n_knots * est_spline)", (n_knots * est_spline));
            num_params_r__ += ((K * est_spline) * (n_knots * est_spline));
            current_statement_begin__ = 177;
            validate_non_negative_index("b_obs", "n_obs_covar", n_obs_covar);
            validate_non_negative_index("b_obs", "P", P);
            num_params_r__ += (n_obs_covar * P);
            current_statement_begin__ = 178;
            validate_non_negative_index("b_pro", "n_pro_covar", n_pro_covar);
            validate_non_negative_index("b_pro", "K", K);
            num_params_r__ += (n_pro_covar * K);
            current_statement_begin__ = 179;
            validate_non_negative_index("sigma", "(nVariances * est_sigma_params)", (nVariances * est_sigma_params));
            num_params_r__ += (1 * (nVariances * est_sigma_params));
            current_statement_begin__ = 180;
            validate_non_negative_index("gamma_a", "(nVariances * est_gamma_params)", (nVariances * est_gamma_params));
            num_params_r__ += (1 * (nVariances * est_gamma_params));
            current_statement_begin__ = 181;
            validate_non_negative_index("nb2_phi", "(nVariances * est_nb2_params)", (nVariances * est_nb2_params));
            num_params_r__ += (1 * (nVariances * est_nb2_params));
            current_statement_begin__ = 182;
            validate_non_negative_index("nu", "estimate_nu", estimate_nu);
            num_params_r__ += (1 * estimate_nu);
            current_statement_begin__ = 183;
            validate_non_negative_index("ymiss", "n_na", n_na);
            num_params_r__ += (1 * n_na);
            current_statement_begin__ = 184;
            validate_non_negative_index("phi", "(est_phi * K)", (est_phi * K));
            num_params_r__ += (1 * (est_phi * K));
            current_statement_begin__ = 185;
            validate_non_negative_index("theta", "(est_theta * K)", (est_theta * K));
            num_params_r__ += (1 * (est_theta * K));
            current_statement_begin__ = 186;
            validate_non_negative_index("gp_theta", "(est_gp * K)", (est_gp * K));
            num_params_r__ += (1 * (est_gp * K));
            current_statement_begin__ = 187;
            validate_non_negative_index("Lcorr", "n_pcor", n_pcor);
            validate_non_negative_index("Lcorr", "n_pcor", n_pcor);
            num_params_r__ += ((n_pcor * (n_pcor - 1)) / 2);
            current_statement_begin__ = 188;
            validate_non_negative_index("sigma_process", "(est_sigma_process * n_sigma_process)", (est_sigma_process * n_sigma_process));
            num_params_r__ += (1 * (est_sigma_process * n_sigma_process));
            current_statement_begin__ = 189;
            validate_non_negative_index("effectsKnots", "(n_knots * est_gp)", (n_knots * est_gp));
            validate_non_negative_index("effectsKnots", "(K * est_gp)", (K * est_gp));
            num_params_r__ += ((n_knots * est_gp) * (K * est_gp));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_dfa() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 170;
        if (!(context__.contains_r("devs")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable devs missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("devs");
        pos__ = 0U;
        validate_non_negative_index("devs", "(K * est_rw)", (K * est_rw));
        validate_non_negative_index("devs", "((N - 1) * est_rw)", ((N - 1) * est_rw));
        context__.validate_dims("parameter initialization", "devs", "matrix_d", context__.to_vec((K * est_rw),((N - 1) * est_rw)));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> devs((K * est_rw), ((N - 1) * est_rw));
        size_t devs_j_2_max__ = ((N - 1) * est_rw);
        size_t devs_j_1_max__ = (K * est_rw);
        for (size_t j_2__ = 0; j_2__ < devs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < devs_j_1_max__; ++j_1__) {
                devs(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(devs);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable devs: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 171;
        if (!(context__.contains_r("x0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable x0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("x0");
        pos__ = 0U;
        validate_non_negative_index("x0", "K", K);
        context__.validate_dims("parameter initialization", "x0", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> x0(K);
        size_t x0_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < x0_j_1_max__; ++j_1__) {
            x0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(x0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable x0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 172;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        validate_non_negative_index("psi", "(K * (1 - proportional_model))", (K * (1 - proportional_model)));
        context__.validate_dims("parameter initialization", "psi", "vector_d", context__.to_vec((K * (1 - proportional_model))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi((K * (1 - proportional_model)));
        size_t psi_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            psi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 173;
        if (!(context__.contains_r("z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "(nZ * (1 - proportional_model))", (nZ * (1 - proportional_model)));
        context__.validate_dims("parameter initialization", "z", "vector_d", context__.to_vec((nZ * (1 - proportional_model))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z((nZ * (1 - proportional_model)));
        size_t z_j_1_max__ = (nZ * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            z(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(get_base1(z_bound, 1, "z_bound", 1), get_base1(z_bound, 2, "z_bound", 1), z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 174;
        if (!(context__.contains_r("zpos")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zpos missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zpos");
        pos__ = 0U;
        validate_non_negative_index("zpos", "(K * (1 - proportional_model))", (K * (1 - proportional_model)));
        context__.validate_dims("parameter initialization", "zpos", "vector_d", context__.to_vec((K * (1 - proportional_model))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> zpos((K * (1 - proportional_model)));
        size_t zpos_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < zpos_j_1_max__; ++j_1__) {
            zpos(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(zpos);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zpos: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 175;
        if (!(context__.contains_r("p_z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p_z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p_z");
        pos__ = 0U;
        validate_non_negative_index("p_z", "K", K);
        validate_non_negative_index("p_z", "(P * proportional_model)", (P * proportional_model));
        context__.validate_dims("parameter initialization", "p_z", "vector_d", context__.to_vec((P * proportional_model),K));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > p_z((P * proportional_model), Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
        size_t p_z_j_1_max__ = K;
        size_t p_z_k_0_max__ = (P * proportional_model);
        for (size_t j_1__ = 0; j_1__ < p_z_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_z_k_0_max__; ++k_0__) {
                p_z[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t p_z_i_0_max__ = (P * proportional_model);
        for (size_t i_0__ = 0; i_0__ < p_z_i_0_max__; ++i_0__) {
            try {
                writer__.simplex_unconstrain(p_z[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p_z: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 176;
        if (!(context__.contains_r("spline_a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable spline_a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("spline_a");
        pos__ = 0U;
        validate_non_negative_index("spline_a", "(K * est_spline)", (K * est_spline));
        validate_non_negative_index("spline_a", "(n_knots * est_spline)", (n_knots * est_spline));
        context__.validate_dims("parameter initialization", "spline_a", "matrix_d", context__.to_vec((K * est_spline),(n_knots * est_spline)));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> spline_a((K * est_spline), (n_knots * est_spline));
        size_t spline_a_j_2_max__ = (n_knots * est_spline);
        size_t spline_a_j_1_max__ = (K * est_spline);
        for (size_t j_2__ = 0; j_2__ < spline_a_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < spline_a_j_1_max__; ++j_1__) {
                spline_a(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(spline_a);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable spline_a: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 177;
        if (!(context__.contains_r("b_obs")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b_obs missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b_obs");
        pos__ = 0U;
        validate_non_negative_index("b_obs", "n_obs_covar", n_obs_covar);
        validate_non_negative_index("b_obs", "P", P);
        context__.validate_dims("parameter initialization", "b_obs", "matrix_d", context__.to_vec(n_obs_covar,P));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> b_obs(n_obs_covar, P);
        size_t b_obs_j_2_max__ = P;
        size_t b_obs_j_1_max__ = n_obs_covar;
        for (size_t j_2__ = 0; j_2__ < b_obs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_obs_j_1_max__; ++j_1__) {
                b_obs(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(b_obs);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b_obs: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 178;
        if (!(context__.contains_r("b_pro")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b_pro missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b_pro");
        pos__ = 0U;
        validate_non_negative_index("b_pro", "n_pro_covar", n_pro_covar);
        validate_non_negative_index("b_pro", "K", K);
        context__.validate_dims("parameter initialization", "b_pro", "matrix_d", context__.to_vec(n_pro_covar,K));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> b_pro(n_pro_covar, K);
        size_t b_pro_j_2_max__ = K;
        size_t b_pro_j_1_max__ = n_pro_covar;
        for (size_t j_2__ = 0; j_2__ < b_pro_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_pro_j_1_max__; ++j_1__) {
                b_pro(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(b_pro);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b_pro: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 179;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "(nVariances * est_sigma_params)", (nVariances * est_sigma_params));
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec((nVariances * est_sigma_params)));
        std::vector<double> sigma((nVariances * est_sigma_params), double(0));
        size_t sigma_k_0_max__ = (nVariances * est_sigma_params);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            sigma[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_i_0_max__ = (nVariances * est_sigma_params);
        for (size_t i_0__ = 0; i_0__ < sigma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 180;
        if (!(context__.contains_r("gamma_a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma_a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma_a");
        pos__ = 0U;
        validate_non_negative_index("gamma_a", "(nVariances * est_gamma_params)", (nVariances * est_gamma_params));
        context__.validate_dims("parameter initialization", "gamma_a", "double", context__.to_vec((nVariances * est_gamma_params)));
        std::vector<double> gamma_a((nVariances * est_gamma_params), double(0));
        size_t gamma_a_k_0_max__ = (nVariances * est_gamma_params);
        for (size_t k_0__ = 0; k_0__ < gamma_a_k_0_max__; ++k_0__) {
            gamma_a[k_0__] = vals_r__[pos__++];
        }
        size_t gamma_a_i_0_max__ = (nVariances * est_gamma_params);
        for (size_t i_0__ = 0; i_0__ < gamma_a_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, gamma_a[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma_a: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 181;
        if (!(context__.contains_r("nb2_phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nb2_phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nb2_phi");
        pos__ = 0U;
        validate_non_negative_index("nb2_phi", "(nVariances * est_nb2_params)", (nVariances * est_nb2_params));
        context__.validate_dims("parameter initialization", "nb2_phi", "double", context__.to_vec((nVariances * est_nb2_params)));
        std::vector<double> nb2_phi((nVariances * est_nb2_params), double(0));
        size_t nb2_phi_k_0_max__ = (nVariances * est_nb2_params);
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            nb2_phi[k_0__] = vals_r__[pos__++];
        }
        size_t nb2_phi_i_0_max__ = (nVariances * est_nb2_params);
        for (size_t i_0__ = 0; i_0__ < nb2_phi_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, nb2_phi[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nb2_phi: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 182;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        validate_non_negative_index("nu", "estimate_nu", estimate_nu);
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec(estimate_nu));
        std::vector<double> nu(estimate_nu, double(0));
        size_t nu_k_0_max__ = estimate_nu;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            nu[k_0__] = vals_r__[pos__++];
        }
        size_t nu_i_0_max__ = estimate_nu;
        for (size_t i_0__ = 0; i_0__ < nu_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(2, nu[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 183;
        if (!(context__.contains_r("ymiss")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ymiss missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ymiss");
        pos__ = 0U;
        validate_non_negative_index("ymiss", "n_na", n_na);
        context__.validate_dims("parameter initialization", "ymiss", "double", context__.to_vec(n_na));
        std::vector<double> ymiss(n_na, double(0));
        size_t ymiss_k_0_max__ = n_na;
        for (size_t k_0__ = 0; k_0__ < ymiss_k_0_max__; ++k_0__) {
            ymiss[k_0__] = vals_r__[pos__++];
        }
        size_t ymiss_i_0_max__ = n_na;
        for (size_t i_0__ = 0; i_0__ < ymiss_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(ymiss[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ymiss: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 184;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "(est_phi * K)", (est_phi * K));
        context__.validate_dims("parameter initialization", "phi", "double", context__.to_vec((est_phi * K)));
        std::vector<double> phi((est_phi * K), double(0));
        size_t phi_k_0_max__ = (est_phi * K);
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            phi[k_0__] = vals_r__[pos__++];
        }
        size_t phi_i_0_max__ = (est_phi * K);
        for (size_t i_0__ = 0; i_0__ < phi_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(-(1), 1, phi[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 185;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "(est_theta * K)", (est_theta * K));
        context__.validate_dims("parameter initialization", "theta", "double", context__.to_vec((est_theta * K)));
        std::vector<double> theta((est_theta * K), double(0));
        size_t theta_k_0_max__ = (est_theta * K);
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            theta[k_0__] = vals_r__[pos__++];
        }
        size_t theta_i_0_max__ = (est_theta * K);
        for (size_t i_0__ = 0; i_0__ < theta_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(-(1), 1, theta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 186;
        if (!(context__.contains_r("gp_theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gp_theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gp_theta");
        pos__ = 0U;
        validate_non_negative_index("gp_theta", "(est_gp * K)", (est_gp * K));
        context__.validate_dims("parameter initialization", "gp_theta", "double", context__.to_vec((est_gp * K)));
        std::vector<double> gp_theta((est_gp * K), double(0));
        size_t gp_theta_k_0_max__ = (est_gp * K);
        for (size_t k_0__ = 0; k_0__ < gp_theta_k_0_max__; ++k_0__) {
            gp_theta[k_0__] = vals_r__[pos__++];
        }
        size_t gp_theta_i_0_max__ = (est_gp * K);
        for (size_t i_0__ = 0; i_0__ < gp_theta_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, gp_theta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gp_theta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 187;
        if (!(context__.contains_r("Lcorr")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable Lcorr missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("Lcorr");
        pos__ = 0U;
        validate_non_negative_index("Lcorr", "n_pcor", n_pcor);
        validate_non_negative_index("Lcorr", "n_pcor", n_pcor);
        context__.validate_dims("parameter initialization", "Lcorr", "matrix_d", context__.to_vec(n_pcor,n_pcor));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Lcorr(n_pcor, n_pcor);
        size_t Lcorr_j_2_max__ = n_pcor;
        size_t Lcorr_j_1_max__ = n_pcor;
        for (size_t j_2__ = 0; j_2__ < Lcorr_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Lcorr_j_1_max__; ++j_1__) {
                Lcorr(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(Lcorr);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable Lcorr: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 188;
        if (!(context__.contains_r("sigma_process")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_process missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_process");
        pos__ = 0U;
        validate_non_negative_index("sigma_process", "(est_sigma_process * n_sigma_process)", (est_sigma_process * n_sigma_process));
        context__.validate_dims("parameter initialization", "sigma_process", "double", context__.to_vec((est_sigma_process * n_sigma_process)));
        std::vector<double> sigma_process((est_sigma_process * n_sigma_process), double(0));
        size_t sigma_process_k_0_max__ = (est_sigma_process * n_sigma_process);
        for (size_t k_0__ = 0; k_0__ < sigma_process_k_0_max__; ++k_0__) {
            sigma_process[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_process_i_0_max__ = (est_sigma_process * n_sigma_process);
        for (size_t i_0__ = 0; i_0__ < sigma_process_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_process[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_process: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 189;
        if (!(context__.contains_r("effectsKnots")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable effectsKnots missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("effectsKnots");
        pos__ = 0U;
        validate_non_negative_index("effectsKnots", "(n_knots * est_gp)", (n_knots * est_gp));
        validate_non_negative_index("effectsKnots", "(K * est_gp)", (K * est_gp));
        context__.validate_dims("parameter initialization", "effectsKnots", "vector_d", context__.to_vec((K * est_gp),(n_knots * est_gp)));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > effectsKnots((K * est_gp), Eigen::Matrix<double, Eigen::Dynamic, 1>((n_knots * est_gp)));
        size_t effectsKnots_j_1_max__ = (n_knots * est_gp);
        size_t effectsKnots_k_0_max__ = (K * est_gp);
        for (size_t j_1__ = 0; j_1__ < effectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < effectsKnots_k_0_max__; ++k_0__) {
                effectsKnots[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t effectsKnots_i_0_max__ = (K * est_gp);
        for (size_t i_0__ = 0; i_0__ < effectsKnots_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(effectsKnots[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable effectsKnots: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 170;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> devs;
            (void) devs;  // dummy to suppress unused var warning
            if (jacobian__)
                devs = in__.matrix_constrain((K * est_rw), ((N - 1) * est_rw), lp__);
            else
                devs = in__.matrix_constrain((K * est_rw), ((N - 1) * est_rw));
            current_statement_begin__ = 171;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x0;
            (void) x0;  // dummy to suppress unused var warning
            if (jacobian__)
                x0 = in__.vector_constrain(K, lp__);
            else
                x0 = in__.vector_constrain(K);
            current_statement_begin__ = 172;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.vector_lb_constrain(0, (K * (1 - proportional_model)), lp__);
            else
                psi = in__.vector_lb_constrain(0, (K * (1 - proportional_model)));
            current_statement_begin__ = 173;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z;
            (void) z;  // dummy to suppress unused var warning
            if (jacobian__)
                z = in__.vector_lub_constrain(get_base1(z_bound, 1, "z_bound", 1), get_base1(z_bound, 2, "z_bound", 1), (nZ * (1 - proportional_model)), lp__);
            else
                z = in__.vector_lub_constrain(get_base1(z_bound, 1, "z_bound", 1), get_base1(z_bound, 2, "z_bound", 1), (nZ * (1 - proportional_model)));
            current_statement_begin__ = 174;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> zpos;
            (void) zpos;  // dummy to suppress unused var warning
            if (jacobian__)
                zpos = in__.vector_constrain((K * (1 - proportional_model)), lp__);
            else
                zpos = in__.vector_constrain((K * (1 - proportional_model)));
            current_statement_begin__ = 175;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > p_z;
            size_t p_z_d_0_max__ = (P * proportional_model);
            p_z.reserve(p_z_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < p_z_d_0_max__; ++d_0__) {
                if (jacobian__)
                    p_z.push_back(in__.simplex_constrain(K, lp__));
                else
                    p_z.push_back(in__.simplex_constrain(K));
            }
            current_statement_begin__ = 176;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> spline_a;
            (void) spline_a;  // dummy to suppress unused var warning
            if (jacobian__)
                spline_a = in__.matrix_constrain((K * est_spline), (n_knots * est_spline), lp__);
            else
                spline_a = in__.matrix_constrain((K * est_spline), (n_knots * est_spline));
            current_statement_begin__ = 177;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> b_obs;
            (void) b_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                b_obs = in__.matrix_constrain(n_obs_covar, P, lp__);
            else
                b_obs = in__.matrix_constrain(n_obs_covar, P);
            current_statement_begin__ = 178;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> b_pro;
            (void) b_pro;  // dummy to suppress unused var warning
            if (jacobian__)
                b_pro = in__.matrix_constrain(n_pro_covar, K, lp__);
            else
                b_pro = in__.matrix_constrain(n_pro_covar, K);
            current_statement_begin__ = 179;
            std::vector<local_scalar_t__> sigma;
            size_t sigma_d_0_max__ = (nVariances * est_sigma_params);
            sigma.reserve(sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 180;
            std::vector<local_scalar_t__> gamma_a;
            size_t gamma_a_d_0_max__ = (nVariances * est_gamma_params);
            gamma_a.reserve(gamma_a_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < gamma_a_d_0_max__; ++d_0__) {
                if (jacobian__)
                    gamma_a.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    gamma_a.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 181;
            std::vector<local_scalar_t__> nb2_phi;
            size_t nb2_phi_d_0_max__ = (nVariances * est_nb2_params);
            nb2_phi.reserve(nb2_phi_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < nb2_phi_d_0_max__; ++d_0__) {
                if (jacobian__)
                    nb2_phi.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    nb2_phi.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 182;
            std::vector<local_scalar_t__> nu;
            size_t nu_d_0_max__ = estimate_nu;
            nu.reserve(nu_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < nu_d_0_max__; ++d_0__) {
                if (jacobian__)
                    nu.push_back(in__.scalar_lb_constrain(2, lp__));
                else
                    nu.push_back(in__.scalar_lb_constrain(2));
            }
            current_statement_begin__ = 183;
            std::vector<local_scalar_t__> ymiss;
            size_t ymiss_d_0_max__ = n_na;
            ymiss.reserve(ymiss_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < ymiss_d_0_max__; ++d_0__) {
                if (jacobian__)
                    ymiss.push_back(in__.scalar_constrain(lp__));
                else
                    ymiss.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 184;
            std::vector<local_scalar_t__> phi;
            size_t phi_d_0_max__ = (est_phi * K);
            phi.reserve(phi_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < phi_d_0_max__; ++d_0__) {
                if (jacobian__)
                    phi.push_back(in__.scalar_lub_constrain(-(1), 1, lp__));
                else
                    phi.push_back(in__.scalar_lub_constrain(-(1), 1));
            }
            current_statement_begin__ = 185;
            std::vector<local_scalar_t__> theta;
            size_t theta_d_0_max__ = (est_theta * K);
            theta.reserve(theta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta.push_back(in__.scalar_lub_constrain(-(1), 1, lp__));
                else
                    theta.push_back(in__.scalar_lub_constrain(-(1), 1));
            }
            current_statement_begin__ = 186;
            std::vector<local_scalar_t__> gp_theta;
            size_t gp_theta_d_0_max__ = (est_gp * K);
            gp_theta.reserve(gp_theta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < gp_theta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    gp_theta.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    gp_theta.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 187;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Lcorr;
            (void) Lcorr;  // dummy to suppress unused var warning
            if (jacobian__)
                Lcorr = in__.cholesky_factor_corr_constrain(n_pcor, lp__);
            else
                Lcorr = in__.cholesky_factor_corr_constrain(n_pcor);
            current_statement_begin__ = 188;
            std::vector<local_scalar_t__> sigma_process;
            size_t sigma_process_d_0_max__ = (est_sigma_process * n_sigma_process);
            sigma_process.reserve(sigma_process_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_process_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_process.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_process.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 189;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > effectsKnots;
            size_t effectsKnots_d_0_max__ = (K * est_gp);
            effectsKnots.reserve(effectsKnots_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < effectsKnots_d_0_max__; ++d_0__) {
                if (jacobian__)
                    effectsKnots.push_back(in__.vector_constrain((n_knots * est_gp), lp__));
                else
                    effectsKnots.push_back(in__.vector_constrain((n_knots * est_gp)));
            }
            // transformed parameters
            current_statement_begin__ = 192;
            validate_non_negative_index("pred", "P", P);
            validate_non_negative_index("pred", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> pred(P, N);
            stan::math::initialize(pred, DUMMY_VAR__);
            stan::math::fill(pred, DUMMY_VAR__);
            current_statement_begin__ = 193;
            validate_non_negative_index("Z", "P", P);
            validate_non_negative_index("Z", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Z(P, K);
            stan::math::initialize(Z, DUMMY_VAR__);
            stan::math::fill(Z, DUMMY_VAR__);
            current_statement_begin__ = 194;
            validate_non_negative_index("yall", "P", P);
            validate_non_negative_index("yall", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> yall(P, N);
            stan::math::initialize(yall, DUMMY_VAR__);
            stan::math::fill(yall, DUMMY_VAR__);
            current_statement_begin__ = 195;
            validate_non_negative_index("sigma_vec", "(P * est_sigma_params)", (P * est_sigma_params));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_vec((P * est_sigma_params));
            stan::math::initialize(sigma_vec, DUMMY_VAR__);
            stan::math::fill(sigma_vec, DUMMY_VAR__);
            current_statement_begin__ = 196;
            validate_non_negative_index("gamma_a_vec", "(P * est_gamma_params)", (P * est_gamma_params));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma_a_vec((P * est_gamma_params));
            stan::math::initialize(gamma_a_vec, DUMMY_VAR__);
            stan::math::fill(gamma_a_vec, DUMMY_VAR__);
            current_statement_begin__ = 197;
            validate_non_negative_index("nb_phi_vec", "(P * est_nb2_params)", (P * est_nb2_params));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> nb_phi_vec((P * est_nb2_params));
            stan::math::initialize(nb_phi_vec, DUMMY_VAR__);
            stan::math::fill(nb_phi_vec, DUMMY_VAR__);
            current_statement_begin__ = 198;
            validate_non_negative_index("phi_vec", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi_vec(K);
            stan::math::initialize(phi_vec, DUMMY_VAR__);
            stan::math::fill(phi_vec, DUMMY_VAR__);
            current_statement_begin__ = 199;
            validate_non_negative_index("theta_vec", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_vec(K);
            stan::math::initialize(theta_vec, DUMMY_VAR__);
            stan::math::fill(theta_vec, DUMMY_VAR__);
            current_statement_begin__ = 200;
            validate_non_negative_index("x", "K", K);
            validate_non_negative_index("x", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> x(K, N);
            stan::math::initialize(x, DUMMY_VAR__);
            stan::math::fill(x, DUMMY_VAR__);
            current_statement_begin__ = 201;
            validate_non_negative_index("indicator", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> indicator(K);
            stan::math::initialize(indicator, DUMMY_VAR__);
            stan::math::fill(indicator, DUMMY_VAR__);
            current_statement_begin__ = 202;
            validate_non_negative_index("psi_root", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> psi_root(K);
            stan::math::initialize(psi_root, DUMMY_VAR__);
            stan::math::fill(psi_root, DUMMY_VAR__);
            current_statement_begin__ = 203;
            validate_non_negative_index("Sigma_derived", "((n_pcor * long_format) * est_cor)", ((n_pcor * long_format) * est_cor));
            validate_non_negative_index("Sigma_derived", "((n_pcor * long_format) * est_cor)", ((n_pcor * long_format) * est_cor));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Sigma_derived(((n_pcor * long_format) * est_cor), ((n_pcor * long_format) * est_cor));
            stan::math::initialize(Sigma_derived, DUMMY_VAR__);
            stan::math::fill(Sigma_derived, DUMMY_VAR__);
            current_statement_begin__ = 204;
            validate_non_negative_index("Sigma_temp", "(((n_pcor - 1) * long_format) * est_cor)", (((n_pcor - 1) * long_format) * est_cor));
            validate_non_negative_index("Sigma_temp", "(((n_pcor - 1) * long_format) * est_cor)", (((n_pcor - 1) * long_format) * est_cor));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Sigma_temp((((n_pcor - 1) * long_format) * est_cor), (((n_pcor - 1) * long_format) * est_cor));
            stan::math::initialize(Sigma_temp, DUMMY_VAR__);
            stan::math::fill(Sigma_temp, DUMMY_VAR__);
            current_statement_begin__ = 205;
            validate_non_negative_index("sigma12_vec", "(n_pcor - 1)", (n_pcor - 1));
            validate_non_negative_index("sigma12_vec", "1", 1);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> sigma12_vec((n_pcor - 1), 1);
            stan::math::initialize(sigma12_vec, DUMMY_VAR__);
            stan::math::fill(sigma12_vec, DUMMY_VAR__);
            current_statement_begin__ = 206;
            validate_non_negative_index("temp_sums", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            validate_non_negative_index("temp_sums", "((N * long_format) * est_cor)", ((N * long_format) * est_cor));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> temp_sums(((P * long_format) * est_cor), ((N * long_format) * est_cor));
            stan::math::initialize(temp_sums, DUMMY_VAR__);
            stan::math::fill(temp_sums, DUMMY_VAR__);
            current_statement_begin__ = 207;
            validate_non_negative_index("temp_counts", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            validate_non_negative_index("temp_counts", "((N * long_format) * est_cor)", ((N * long_format) * est_cor));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> temp_counts(((P * long_format) * est_cor), ((N * long_format) * est_cor));
            stan::math::initialize(temp_counts, DUMMY_VAR__);
            stan::math::fill(temp_counts, DUMMY_VAR__);
            current_statement_begin__ = 208;
            validate_non_negative_index("cond_sigma_vec", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cond_sigma_vec(((P * long_format) * est_cor));
            stan::math::initialize(cond_sigma_vec, DUMMY_VAR__);
            stan::math::fill(cond_sigma_vec, DUMMY_VAR__);
            current_statement_begin__ = 209;
            validate_non_negative_index("cond_mean_vec", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cond_mean_vec(((P * long_format) * est_cor));
            stan::math::initialize(cond_mean_vec, DUMMY_VAR__);
            stan::math::fill(cond_mean_vec, DUMMY_VAR__);
            current_statement_begin__ = 210;
            local_scalar_t__ sigma11;
            (void) sigma11;  // dummy to suppress unused var warning
            stan::math::initialize(sigma11, DUMMY_VAR__);
            stan::math::fill(sigma11, DUMMY_VAR__);
            current_statement_begin__ = 211;
            validate_non_negative_index("sigma_pro", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_pro(K);
            stan::math::initialize(sigma_pro, DUMMY_VAR__);
            stan::math::fill(sigma_pro, DUMMY_VAR__);
            current_statement_begin__ = 212;
            validate_non_negative_index("spline_a_trans", "(K * est_spline)", (K * est_spline));
            validate_non_negative_index("spline_a_trans", "(n_knots * est_spline)", (n_knots * est_spline));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> spline_a_trans((K * est_spline), (n_knots * est_spline));
            stan::math::initialize(spline_a_trans, DUMMY_VAR__);
            stan::math::fill(spline_a_trans, DUMMY_VAR__);
            current_statement_begin__ = 213;
            validate_non_negative_index("SigmaKnots", "n_knots", n_knots);
            validate_non_negative_index("SigmaKnots", "n_knots", n_knots);
            validate_non_negative_index("SigmaKnots", "K", K);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > SigmaKnots(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(n_knots, n_knots));
            stan::math::initialize(SigmaKnots, DUMMY_VAR__);
            stan::math::fill(SigmaKnots, DUMMY_VAR__);
            current_statement_begin__ = 216;
            validate_non_negative_index("obs_cov_offset", "n_pos", n_pos);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> obs_cov_offset(n_pos);
            stan::math::initialize(obs_cov_offset, DUMMY_VAR__);
            stan::math::fill(obs_cov_offset, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 219;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 220;
                stan::model::assign(sigma_pro, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            1, 
                            "assigning variable sigma_pro");
                current_statement_begin__ = 221;
                if (as_bool(logical_eq(est_sigma_process, 1))) {
                    current_statement_begin__ = 222;
                    if (as_bool(logical_eq(n_sigma_process, 1))) {
                        current_statement_begin__ = 223;
                        stan::model::assign(sigma_pro, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    get_base1(sigma_process, 1, "sigma_process", 1), 
                                    "assigning variable sigma_pro");
                    } else {
                        current_statement_begin__ = 225;
                        stan::model::assign(sigma_pro, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    get_base1(sigma_process, k, "sigma_process", 1), 
                                    "assigning variable sigma_pro");
                    }
                }
            }
            current_statement_begin__ = 231;
            if (as_bool(logical_eq(est_phi, 1))) {
                current_statement_begin__ = 233;
                stan::math::assign(phi_vec, to_vector(phi));
            } else {
                current_statement_begin__ = 236;
                stan::math::assign(phi_vec, rep_vector(1.0, K));
            }
            current_statement_begin__ = 240;
            if (as_bool(logical_eq(est_theta, 1))) {
                current_statement_begin__ = 242;
                stan::math::assign(theta_vec, to_vector(theta));
            } else {
                current_statement_begin__ = 245;
                stan::math::assign(theta_vec, rep_vector(1.0, K));
            }
            current_statement_begin__ = 248;
            if (as_bool(logical_eq(est_sigma_params, 1))) {
                current_statement_begin__ = 249;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 249;
                    stan::model::assign(sigma_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                get_base1(sigma, get_base1(varIndx, p, "varIndx", 1), "sigma", 1), 
                                "assigning variable sigma_vec");
                }
            }
            current_statement_begin__ = 251;
            if (as_bool(logical_eq(est_gamma_params, 1))) {
                current_statement_begin__ = 252;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 252;
                    stan::model::assign(gamma_a_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                get_base1(gamma_a, get_base1(varIndx, p, "varIndx", 1), "gamma_a", 1), 
                                "assigning variable gamma_a_vec");
                }
            }
            current_statement_begin__ = 254;
            if (as_bool(logical_eq(est_nb2_params, 1))) {
                current_statement_begin__ = 255;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 255;
                    stan::model::assign(nb_phi_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                get_base1(nb2_phi, get_base1(varIndx, p, "varIndx", 1), "nb2_phi", 1), 
                                "assigning variable nb_phi_vec");
                }
            }
            current_statement_begin__ = 258;
            if (as_bool(logical_eq(long_format, 0))) {
                current_statement_begin__ = 260;
                for (int i = 1; i <= n_pos; ++i) {
                    current_statement_begin__ = 261;
                    stan::model::assign(yall, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), 
                                get_base1(y, i, "y", 1), 
                                "assigning variable yall");
                }
                current_statement_begin__ = 264;
                if (as_bool(logical_gt(n_na, 0))) {
                    current_statement_begin__ = 265;
                    for (int i = 1; i <= n_na; ++i) {
                        current_statement_begin__ = 266;
                        stan::model::assign(yall, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_na, i, "row_indx_na", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_na, i, "col_indx_na", 1)), stan::model::nil_index_list())), 
                                    get_base1(ymiss, i, "ymiss", 1), 
                                    "assigning variable yall");
                    }
                }
            }
            current_statement_begin__ = 271;
            if (as_bool(logical_eq(proportional_model, 0))) {
                current_statement_begin__ = 272;
                for (int i = 1; i <= nZ; ++i) {
                    current_statement_begin__ = 273;
                    stan::model::assign(Z, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx, i, "row_indx", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx, i, "col_indx", 1)), stan::model::nil_index_list())), 
                                get_base1(z, i, "z", 1), 
                                "assigning variable Z");
                }
                current_statement_begin__ = 276;
                if (as_bool(logical_gt(nZero, 2))) {
                    current_statement_begin__ = 277;
                    for (int i = 1; i <= (nZero - 2); ++i) {
                        current_statement_begin__ = 278;
                        stan::model::assign(Z, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_z, i, "row_indx_z", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_z, i, "col_indx_z", 1)), stan::model::nil_index_list())), 
                                    0, 
                                    "assigning variable Z");
                    }
                }
                current_statement_begin__ = 281;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 282;
                    stan::model::assign(Z, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                get_base1(zpos, k, "zpos", 1), 
                                "assigning variable Z");
                }
                current_statement_begin__ = 285;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 286;
                    if (as_bool(logical_lt(get_base1(zpos, k, "zpos", 1), 0))) {
                        current_statement_begin__ = 287;
                        stan::model::assign(indicator, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    -(1), 
                                    "assigning variable indicator");
                    } else {
                        current_statement_begin__ = 289;
                        stan::model::assign(indicator, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    1, 
                                    "assigning variable indicator");
                    }
                    current_statement_begin__ = 291;
                    stan::model::assign(psi_root, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                stan::math::sqrt(get_base1(psi, k, "psi", 1)), 
                                "assigning variable psi_root");
                    current_statement_begin__ = 292;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 293;
                        stan::model::assign(Z, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    ((get_base1(Z, p, k, "Z", 1) * get_base1(indicator, k, "indicator", 1)) * (1 / get_base1(psi_root, k, "psi_root", 1))), 
                                    "assigning variable Z");
                    }
                }
                current_statement_begin__ = 297;
                if (as_bool(logical_eq(est_rw, 1))) {
                    current_statement_begin__ = 298;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 299;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                    get_base1(x0, k, "x0", 1), 
                                    "assigning variable x");
                        current_statement_begin__ = 303;
                        for (int t = 2; t <= N; ++t) {
                            current_statement_begin__ = 304;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                        ((get_base1(phi_vec, k, "phi_vec", 1) * get_base1(x, k, (t - 1), "x", 1)) + get_base1(devs, k, (t - 1), "devs", 1)), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 308;
                if (as_bool(logical_eq(est_spline, 1))) {
                    current_statement_begin__ = 310;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 310;
                        stan::model::assign(spline_a_trans, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    multiply(get_base1(spline_a, k, "spline_a", 1), get_base1(sigma_pro, k, "sigma_pro", 1)), 
                                    "assigning variable spline_a_trans");
                    }
                    current_statement_begin__ = 311;
                    stan::math::assign(x, multiply(spline_a_trans, B_spline));
                    current_statement_begin__ = 312;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 312;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    add(get_base1(x0, k, "x0", 1), get_base1(x, k, "x", 1)), 
                                    "assigning variable x");
                    }
                }
                current_statement_begin__ = 314;
                if (as_bool(logical_eq(est_gp, 1))) {
                    current_statement_begin__ = 316;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 317;
                        stan::model::assign(SigmaKnots, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    cov_exp_quad(knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), 
                                    "assigning variable SigmaKnots");
                        current_statement_begin__ = 320;
                        for (int i = 1; i <= n_knots; ++i) {
                            current_statement_begin__ = 321;
                            stan::model::assign(SigmaKnots, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(SigmaKnots, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), "SigmaKnots") + gp_delta), 
                                        "assigning variable SigmaKnots");
                        }
                        current_statement_begin__ = 330;
                        if (as_bool(logical_eq(n_knots, N))) {
                            current_statement_begin__ = 332;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1)), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        } else {
                            current_statement_begin__ = 334;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(multiply(multiply(cov_exp_quad(data_locs, knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), inverse_spd(get_base1(SigmaKnots, k, "SigmaKnots", 1))), cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1))), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 340;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 342;
                    stan::model::assign(x, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                multiply(multiply(get_base1(x, k, "x", 1), get_base1(indicator, k, "indicator", 1)), get_base1(psi_root, k, "psi_root", 1)), 
                                "assigning variable x");
                }
            }
            current_statement_begin__ = 346;
            if (as_bool(logical_eq(proportional_model, 1))) {
                current_statement_begin__ = 348;
                if (as_bool(logical_eq(est_rw, 1))) {
                    current_statement_begin__ = 349;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 350;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                    get_base1(x0, k, "x0", 1), 
                                    "assigning variable x");
                        current_statement_begin__ = 354;
                        for (int t = 2; t <= N; ++t) {
                            current_statement_begin__ = 355;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                        ((get_base1(phi_vec, k, "phi_vec", 1) * get_base1(x, k, (t - 1), "x", 1)) + get_base1(devs, k, (t - 1), "devs", 1)), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 359;
                if (as_bool(logical_eq(est_spline, 1))) {
                    current_statement_begin__ = 360;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 360;
                        stan::model::assign(spline_a_trans, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    multiply(get_base1(spline_a, k, "spline_a", 1), get_base1(sigma_pro, k, "sigma_pro", 1)), 
                                    "assigning variable spline_a_trans");
                    }
                    current_statement_begin__ = 361;
                    stan::math::assign(x, multiply(spline_a_trans, B_spline));
                    current_statement_begin__ = 362;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 362;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    add(get_base1(x0, k, "x0", 1), get_base1(x, k, "x", 1)), 
                                    "assigning variable x");
                    }
                }
                current_statement_begin__ = 364;
                if (as_bool(logical_eq(est_gp, 1))) {
                    current_statement_begin__ = 365;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 366;
                        stan::model::assign(SigmaKnots, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    cov_exp_quad(knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), 
                                    "assigning variable SigmaKnots");
                        current_statement_begin__ = 369;
                        for (int i = 1; i <= n_knots; ++i) {
                            current_statement_begin__ = 370;
                            stan::model::assign(SigmaKnots, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(SigmaKnots, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), "SigmaKnots") + gp_delta), 
                                        "assigning variable SigmaKnots");
                        }
                        current_statement_begin__ = 379;
                        if (as_bool(logical_eq(n_knots, N))) {
                            current_statement_begin__ = 381;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1)), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        } else {
                            current_statement_begin__ = 383;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(multiply(multiply(cov_exp_quad(data_locs, knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), inverse_spd(get_base1(SigmaKnots, k, "SigmaKnots", 1))), cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1))), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 389;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 393;
                    stan::model::assign(Z, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                to_row_vector(get_base1(p_z, p, "p_z", 1)), 
                                "assigning variable Z");
                }
            }
            current_statement_begin__ = 398;
            if (as_bool(logical_gt(num_pro_covar, 0))) {
                current_statement_begin__ = 399;
                for (int i = 1; i <= num_pro_covar; ++i) {
                    current_statement_begin__ = 401;
                    stan::model::assign(x, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 2, "pro_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 1, "pro_covar_index", 2)), stan::model::nil_index_list())), 
                                (stan::model::rvalue(x, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 2, "pro_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 1, "pro_covar_index", 2)), stan::model::nil_index_list())), "x") + (get_base1(b_pro, get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 3, "pro_covar_index", 2), get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 2, "pro_covar_index", 2), "b_pro", 1) * get_base1(pro_covar_value, i, "pro_covar_value", 1))), 
                                "assigning variable x");
                }
            }
            current_statement_begin__ = 407;
            stan::math::assign(pred, multiply(Z, x));
            current_statement_begin__ = 409;
            for (int i = 1; i <= n_pos; ++i) {
                current_statement_begin__ = 410;
                stan::model::assign(obs_cov_offset, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable obs_cov_offset");
            }
            current_statement_begin__ = 413;
            if (as_bool(logical_gt(num_obs_covar, 0))) {
                current_statement_begin__ = 414;
                if (as_bool(logical_eq(long_format, 0))) {
                    current_statement_begin__ = 415;
                    for (int i = 1; i <= num_obs_covar; ++i) {
                        current_statement_begin__ = 418;
                        stan::model::assign(pred, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 1, "obs_covar_index", 2)), stan::model::nil_index_list())), 
                                    (stan::model::rvalue(pred, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 1, "obs_covar_index", 2)), stan::model::nil_index_list())), "pred") + (get_base1(b_obs, get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 3, "obs_covar_index", 2), get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2), "b_obs", 1) * get_base1(obs_covar_value, i, "obs_covar_value", 1))), 
                                    "assigning variable pred");
                    }
                } else {
                    current_statement_begin__ = 423;
                    for (int i = 1; i <= num_obs_covar; ++i) {
                        current_statement_begin__ = 424;
                        stan::model::assign(obs_cov_offset, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(match_obs_covar, i, "match_obs_covar", 1)), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(obs_cov_offset, stan::model::cons_list(stan::model::index_uni(get_base1(match_obs_covar, i, "match_obs_covar", 1)), stan::model::nil_index_list()), "obs_cov_offset") + (get_base1(b_obs, get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 3, "obs_covar_index", 2), get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2), "b_obs", 1) * get_base1(obs_covar_value, i, "obs_covar_value", 1))), 
                                    "assigning variable obs_cov_offset");
                    }
                }
            }
            current_statement_begin__ = 429;
            if (as_bool((primitive_value(logical_eq(long_format, 1)) && primitive_value(logical_eq(est_cor, 1))))) {
                current_statement_begin__ = 431;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 432;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 433;
                        stan::model::assign(temp_sums, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                    0.0, 
                                    "assigning variable temp_sums");
                        current_statement_begin__ = 434;
                        stan::model::assign(temp_counts, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                    0.0, 
                                    "assigning variable temp_counts");
                    }
                }
                current_statement_begin__ = 437;
                for (int i = 1; i <= n_pos; ++i) {
                    current_statement_begin__ = 438;
                    stan::model::assign(temp_sums, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), 
                                (stan::model::rvalue(temp_sums, stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), "temp_sums") + (get_base1(y, i, "y", 1) - get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1))), 
                                "assigning variable temp_sums");
                    current_statement_begin__ = 439;
                    stan::model::assign(temp_counts, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), 
                                (stan::model::rvalue(temp_counts, stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), "temp_counts") + 1), 
                                "assigning variable temp_counts");
                }
                current_statement_begin__ = 441;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 442;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 444;
                        stan::model::assign(temp_sums, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                    (get_base1(temp_sums, p, n, "temp_sums", 1) / get_base1(temp_counts, p, n, "temp_counts", 1)), 
                                    "assigning variable temp_sums");
                    }
                }
                current_statement_begin__ = 448;
                stan::math::assign(Sigma_derived, quad_form_diag(multiply_lower_tri_self_transpose(Lcorr), sigma_vec));
                current_statement_begin__ = 450;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 451;
                    stan::math::assign(sigma11, get_base1(Sigma_derived, p, p, "Sigma_derived", 1));
                    current_statement_begin__ = 452;
                    stan::math::assign(Sigma_temp, inverse(subset(Sigma_derived, p, P, pstream__)));
                    current_statement_begin__ = 453;
                    stan::math::assign(sigma12_vec, subsetvec(Sigma_derived, p, P, pstream__));
                    current_statement_begin__ = 455;
                    stan::model::assign(cond_mean_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                multiply(multiply(to_row_vector(sigma12_vec), Sigma_temp), to_vector(subsetvec2(col(temp_sums, p), p, P, pstream__))), 
                                "assigning variable cond_mean_vec");
                    current_statement_begin__ = 457;
                    stan::model::assign(cond_sigma_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                stan::math::sqrt((sigma11 - multiply(multiply(to_row_vector(sigma12_vec), Sigma_temp), to_vector(sigma12_vec)))), 
                                "assigning variable cond_sigma_vec");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 192;
            size_t pred_j_1_max__ = P;
            size_t pred_j_2_max__ = N;
            for (size_t j_1__ = 0; j_1__ < pred_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < pred_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(pred(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: pred" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable pred: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 193;
            size_t Z_j_1_max__ = P;
            size_t Z_j_2_max__ = K;
            for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Z(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Z" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Z: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 194;
            size_t yall_j_1_max__ = P;
            size_t yall_j_2_max__ = N;
            for (size_t j_1__ = 0; j_1__ < yall_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < yall_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(yall(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: yall" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable yall: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 195;
            size_t sigma_vec_j_1_max__ = (P * est_sigma_params);
            for (size_t j_1__ = 0; j_1__ < sigma_vec_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sigma_vec(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_vec" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 196;
            size_t gamma_a_vec_j_1_max__ = (P * est_gamma_params);
            for (size_t j_1__ = 0; j_1__ < gamma_a_vec_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(gamma_a_vec(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma_a_vec" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gamma_a_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 197;
            size_t nb_phi_vec_j_1_max__ = (P * est_nb2_params);
            for (size_t j_1__ = 0; j_1__ < nb_phi_vec_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(nb_phi_vec(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: nb_phi_vec" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable nb_phi_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 198;
            size_t phi_vec_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < phi_vec_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(phi_vec(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi_vec" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable phi_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 199;
            size_t theta_vec_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < theta_vec_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_vec(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_vec" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 200;
            size_t x_j_1_max__ = K;
            size_t x_j_2_max__ = N;
            for (size_t j_1__ = 0; j_1__ < x_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < x_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(x(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: x" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable x: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 201;
            size_t indicator_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < indicator_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(indicator(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: indicator" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable indicator: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 202;
            size_t psi_root_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < psi_root_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(psi_root(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: psi_root" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable psi_root: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 203;
            size_t Sigma_derived_j_1_max__ = ((n_pcor * long_format) * est_cor);
            size_t Sigma_derived_j_2_max__ = ((n_pcor * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < Sigma_derived_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Sigma_derived_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Sigma_derived(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Sigma_derived" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Sigma_derived: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 204;
            size_t Sigma_temp_j_1_max__ = (((n_pcor - 1) * long_format) * est_cor);
            size_t Sigma_temp_j_2_max__ = (((n_pcor - 1) * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < Sigma_temp_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Sigma_temp_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Sigma_temp(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Sigma_temp" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Sigma_temp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 205;
            size_t sigma12_vec_j_1_max__ = (n_pcor - 1);
            size_t sigma12_vec_j_2_max__ = 1;
            for (size_t j_1__ = 0; j_1__ < sigma12_vec_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < sigma12_vec_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(sigma12_vec(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sigma12_vec" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma12_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 206;
            size_t temp_sums_j_1_max__ = ((P * long_format) * est_cor);
            size_t temp_sums_j_2_max__ = ((N * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < temp_sums_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < temp_sums_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(temp_sums(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: temp_sums" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable temp_sums: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 207;
            size_t temp_counts_j_1_max__ = ((P * long_format) * est_cor);
            size_t temp_counts_j_2_max__ = ((N * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < temp_counts_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < temp_counts_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(temp_counts(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: temp_counts" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable temp_counts: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 208;
            size_t cond_sigma_vec_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < cond_sigma_vec_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(cond_sigma_vec(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: cond_sigma_vec" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable cond_sigma_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 209;
            size_t cond_mean_vec_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < cond_mean_vec_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(cond_mean_vec(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: cond_mean_vec" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable cond_mean_vec: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 210;
            if (stan::math::is_uninitialized(sigma11)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sigma11";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma11: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 211;
            size_t sigma_pro_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < sigma_pro_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sigma_pro(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_pro" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma_pro: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 212;
            size_t spline_a_trans_j_1_max__ = (K * est_spline);
            size_t spline_a_trans_j_2_max__ = (n_knots * est_spline);
            for (size_t j_1__ = 0; j_1__ < spline_a_trans_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < spline_a_trans_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(spline_a_trans(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: spline_a_trans" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable spline_a_trans: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 213;
            size_t SigmaKnots_k_0_max__ = K;
            size_t SigmaKnots_j_1_max__ = n_knots;
            size_t SigmaKnots_j_2_max__ = n_knots;
            for (size_t k_0__ = 0; k_0__ < SigmaKnots_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(SigmaKnots[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: SigmaKnots" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SigmaKnots: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 216;
            size_t obs_cov_offset_j_1_max__ = n_pos;
            for (size_t j_1__ = 0; j_1__ < obs_cov_offset_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(obs_cov_offset(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: obs_cov_offset" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable obs_cov_offset: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 465;
            lp_accum__.add(normal_log<propto__>(x0, 0, 1));
            current_statement_begin__ = 466;
            lp_accum__.add(gamma_log<propto__>(psi, 2, 1));
            current_statement_begin__ = 469;
            if (as_bool(logical_eq(estimate_nu, 1))) {
                current_statement_begin__ = 470;
                lp_accum__.add(gamma_log<propto__>(get_base1(nu, 1, "nu", 1), 2, 0.1));
            }
            current_statement_begin__ = 473;
            if (as_bool(logical_eq(est_phi, 1))) {
                current_statement_begin__ = 474;
                lp_accum__.add(normal_log<propto__>(phi, 0, 1));
            }
            current_statement_begin__ = 477;
            if (as_bool(logical_eq(est_theta, 1))) {
                current_statement_begin__ = 478;
                lp_accum__.add(normal_log<propto__>(theta, 0, 1));
            }
            current_statement_begin__ = 481;
            if (as_bool(est_sigma_process)) {
                current_statement_begin__ = 482;
                lp_accum__.add(normal_log<propto__>(sigma_process, 0, 1));
            }
            current_statement_begin__ = 485;
            if (as_bool(logical_eq(est_sigma_params, 1))) {
                current_statement_begin__ = 485;
                lp_accum__.add(student_t_log<propto__>(sigma, 3, 0, 1));
            }
            current_statement_begin__ = 486;
            if (as_bool(logical_eq(est_gamma_params, 1))) {
                current_statement_begin__ = 486;
                lp_accum__.add(student_t_log<propto__>(gamma_a, 3, 0, 1));
            }
            current_statement_begin__ = 487;
            if (as_bool(logical_eq(est_nb2_params, 1))) {
                current_statement_begin__ = 487;
                lp_accum__.add(student_t_log<propto__>(nb2_phi, 3, 0, 1));
            }
            current_statement_begin__ = 490;
            if (as_bool(logical_eq(est_cor, 1))) {
                current_statement_begin__ = 491;
                lp_accum__.add(lkj_corr_cholesky_log<propto__>(Lcorr, 1));
            }
            current_statement_begin__ = 493;
            if (as_bool(logical_eq(est_gp, 1))) {
                current_statement_begin__ = 498;
                lp_accum__.add(inv_gamma_log<propto__>(gp_theta, get_base1(gp_theta_prior, 1, "gp_theta_prior", 1), get_base1(gp_theta_prior, 2, "gp_theta_prior", 1)));
                current_statement_begin__ = 500;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 501;
                    lp_accum__.add(std_normal_log<propto__>(get_base1(effectsKnots, k, "effectsKnots", 1)));
                }
            }
            current_statement_begin__ = 507;
            if (as_bool(logical_eq(est_rw, 1))) {
                current_statement_begin__ = 508;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 509;
                    if (as_bool(logical_eq(use_normal, 0))) {
                        current_statement_begin__ = 510;
                        for (int t = 1; t <= 1; ++t) {
                            current_statement_begin__ = 511;
                            if (as_bool(logical_eq(estimate_nu, 1))) {
                                current_statement_begin__ = 512;
                                lp_accum__.add(student_t_log<propto__>(get_base1(devs, k, t, "devs", 1), get_base1(nu, 1, "nu", 1), 0, get_base1(sigma_pro, k, "sigma_pro", 1)));
                            } else {
                                current_statement_begin__ = 514;
                                lp_accum__.add(student_t_log<propto__>(get_base1(devs, k, t, "devs", 1), nu_fixed, 0, get_base1(sigma_pro, k, "sigma_pro", 1)));
                            }
                        }
                        current_statement_begin__ = 517;
                        for (int t = 2; t <= (N - 1); ++t) {
                            current_statement_begin__ = 519;
                            if (as_bool(logical_eq(estimate_nu, 1))) {
                                current_statement_begin__ = 520;
                                lp_accum__.add(student_t_log<propto__>(get_base1(devs, k, t, "devs", 1), get_base1(nu, 1, "nu", 1), (get_base1(theta_vec, k, "theta_vec", 1) * get_base1(devs, k, (t - 1), "devs", 1)), get_base1(sigma_pro, k, "sigma_pro", 1)));
                            } else {
                                current_statement_begin__ = 522;
                                lp_accum__.add(student_t_log<propto__>(get_base1(devs, k, t, "devs", 1), nu_fixed, (get_base1(theta_vec, k, "theta_vec", 1) * get_base1(devs, k, (t - 1), "devs", 1)), get_base1(sigma_pro, k, "sigma_pro", 1)));
                            }
                        }
                    } else {
                        current_statement_begin__ = 527;
                        lp_accum__.add(normal_log<propto__>(get_base1(devs, k, 1, "devs", 1), 0, 1));
                        current_statement_begin__ = 528;
                        for (int t = 2; t <= (N - 1); ++t) {
                            current_statement_begin__ = 530;
                            lp_accum__.add(normal_log<propto__>(get_base1(devs, k, t, "devs", 1), (get_base1(theta_vec, k, "theta_vec", 1) * get_base1(devs, k, (t - 1), "devs", 1)), get_base1(sigma_pro, k, "sigma_pro", 1)));
                        }
                    }
                }
            }
            current_statement_begin__ = 536;
            if (as_bool(logical_eq(est_spline, 1))) {
                current_statement_begin__ = 537;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 538;
                    lp_accum__.add(std_normal_log<propto__>(get_base1(spline_a, k, "spline_a", 1)));
                }
            }
            current_statement_begin__ = 542;
            if (as_bool(logical_eq(proportional_model, 0))) {
                current_statement_begin__ = 544;
                lp_accum__.add(std_normal_log<propto__>(z));
                current_statement_begin__ = 545;
                lp_accum__.add(std_normal_log<propto__>(zpos));
            } else {
                current_statement_begin__ = 547;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 548;
                    lp_accum__.add(dirichlet_log<propto__>(get_base1(p_z, p, "p_z", 1), alpha_vec));
                }
            }
            current_statement_begin__ = 553;
            if (as_bool(logical_eq(est_cor, 0))) {
                current_statement_begin__ = 554;
                if (as_bool(logical_eq(long_format, 0))) {
                    current_statement_begin__ = 555;
                    if (as_bool(logical_eq(obs_model, 1))) {
                        current_statement_begin__ = 555;
                        for (int i = 1; i <= P; ++i) {
                            current_statement_begin__ = 555;
                            lp_accum__.add(normal_log(get_base1(yall, i, "yall", 1), get_base1(pred, i, "pred", 1), get_base1(sigma_vec, i, "sigma_vec", 1)));
                        }
                    }
                } else {
                    current_statement_begin__ = 557;
                    if (as_bool(logical_eq(obs_model, 1))) {
                        current_statement_begin__ = 557;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 557;
                            lp_accum__.add(normal_log(get_base1(y, i, "y", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1)), get_base1(sigma_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "sigma_vec", 1)));
                        }
                    }
                    current_statement_begin__ = 558;
                    if (as_bool(logical_eq(obs_model, 2))) {
                        current_statement_begin__ = 558;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 558;
                            lp_accum__.add(gamma_log(get_base1(y, i, "y", 1), get_base1(gamma_a_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "gamma_a_vec", 1), (get_base1(gamma_a_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "gamma_a_vec", 1) / stan::math::exp((get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1))))));
                        }
                    }
                    current_statement_begin__ = 559;
                    if (as_bool(logical_eq(obs_model, 3))) {
                        current_statement_begin__ = 559;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 559;
                            lp_accum__.add(poisson_log_log(get_base1(y_int, i, "y_int", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1))));
                        }
                    }
                    current_statement_begin__ = 560;
                    if (as_bool(logical_eq(obs_model, 4))) {
                        current_statement_begin__ = 560;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 560;
                            lp_accum__.add(neg_binomial_2_log_log(get_base1(y_int, i, "y_int", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1)), get_base1(nb_phi_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "nb_phi_vec", 1)));
                        }
                    }
                    current_statement_begin__ = 561;
                    if (as_bool(logical_eq(obs_model, 5))) {
                        current_statement_begin__ = 561;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 561;
                            lp_accum__.add(bernoulli_logit_log(get_base1(y_int, i, "y_int", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1))));
                        }
                    }
                    current_statement_begin__ = 562;
                    if (as_bool(logical_eq(obs_model, 6))) {
                        current_statement_begin__ = 562;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 562;
                            lp_accum__.add(lognormal_log(get_base1(y, i, "y", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1)), get_base1(sigma_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "sigma_vec", 1)));
                        }
                    }
                }
            } else {
                current_statement_begin__ = 566;
                if (as_bool(logical_eq(long_format, 0))) {
                    current_statement_begin__ = 567;
                    if (as_bool(logical_eq(obs_model, 1))) {
                        current_statement_begin__ = 567;
                        for (int i = 1; i <= N; ++i) {
                            current_statement_begin__ = 567;
                            lp_accum__.add(multi_normal_cholesky_log(col(yall, i), col(pred, i), diag_pre_multiply(sigma_vec, Lcorr)));
                        }
                    }
                } else {
                    current_statement_begin__ = 569;
                    if (as_bool(logical_eq(obs_model, 1))) {
                        current_statement_begin__ = 569;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 569;
                            lp_accum__.add(normal_log(get_base1(y, i, "y", 1), ((get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1)) + get_base1(cond_mean_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "cond_mean_vec", 1)), get_base1(cond_sigma_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "cond_sigma_vec", 1)));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("devs");
        names__.push_back("x0");
        names__.push_back("psi");
        names__.push_back("z");
        names__.push_back("zpos");
        names__.push_back("p_z");
        names__.push_back("spline_a");
        names__.push_back("b_obs");
        names__.push_back("b_pro");
        names__.push_back("sigma");
        names__.push_back("gamma_a");
        names__.push_back("nb2_phi");
        names__.push_back("nu");
        names__.push_back("ymiss");
        names__.push_back("phi");
        names__.push_back("theta");
        names__.push_back("gp_theta");
        names__.push_back("Lcorr");
        names__.push_back("sigma_process");
        names__.push_back("effectsKnots");
        names__.push_back("pred");
        names__.push_back("Z");
        names__.push_back("yall");
        names__.push_back("sigma_vec");
        names__.push_back("gamma_a_vec");
        names__.push_back("nb_phi_vec");
        names__.push_back("phi_vec");
        names__.push_back("theta_vec");
        names__.push_back("x");
        names__.push_back("indicator");
        names__.push_back("psi_root");
        names__.push_back("Sigma_derived");
        names__.push_back("Sigma_temp");
        names__.push_back("sigma12_vec");
        names__.push_back("temp_sums");
        names__.push_back("temp_counts");
        names__.push_back("cond_sigma_vec");
        names__.push_back("cond_mean_vec");
        names__.push_back("sigma11");
        names__.push_back("sigma_pro");
        names__.push_back("spline_a_trans");
        names__.push_back("SigmaKnots");
        names__.push_back("obs_cov_offset");
        names__.push_back("log_lik");
        names__.push_back("Omega");
        names__.push_back("Sigma");
        names__.push_back("xstar");
        names__.push_back("future_devs");
        names__.push_back("SigmaKnots_pred");
        names__.push_back("SigmaOffDiag_pred");
        names__.push_back("j");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((K * est_rw));
        dims__.push_back(((N - 1) * est_rw));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * (1 - proportional_model)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nZ * (1 - proportional_model)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * (1 - proportional_model)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P * proportional_model));
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * est_spline));
        dims__.push_back((n_knots * est_spline));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_obs_covar);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pro_covar);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nVariances * est_sigma_params));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nVariances * est_gamma_params));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nVariances * est_nb2_params));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(estimate_nu);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_na);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((est_phi * K));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((est_theta * K));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((est_gp * K));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pcor);
        dims__.push_back(n_pcor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((est_sigma_process * n_sigma_process));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * est_gp));
        dims__.push_back((n_knots * est_gp));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P * est_sigma_params));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P * est_gamma_params));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P * est_nb2_params));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((n_pcor * long_format) * est_cor));
        dims__.push_back(((n_pcor * long_format) * est_cor));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((((n_pcor - 1) * long_format) * est_cor));
        dims__.push_back((((n_pcor - 1) * long_format) * est_cor));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((n_pcor - 1));
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((P * long_format) * est_cor));
        dims__.push_back(((N * long_format) * est_cor));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((P * long_format) * est_cor));
        dims__.push_back(((N * long_format) * est_cor));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((P * long_format) * est_cor));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((P * long_format) * est_cor));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * est_spline));
        dims__.push_back((n_knots * est_spline));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(n_knots);
        dims__.push_back(n_knots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pos);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_loglik);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pcor);
        dims__.push_back(n_pcor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pcor);
        dims__.push_back(n_pcor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_knots);
        dims__.push_back(n_knots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_knots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_dfa_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> devs = in__.matrix_constrain((K * est_rw), ((N - 1) * est_rw));
        size_t devs_j_2_max__ = ((N - 1) * est_rw);
        size_t devs_j_1_max__ = (K * est_rw);
        for (size_t j_2__ = 0; j_2__ < devs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < devs_j_1_max__; ++j_1__) {
                vars__.push_back(devs(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> x0 = in__.vector_constrain(K);
        size_t x0_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < x0_j_1_max__; ++j_1__) {
            vars__.push_back(x0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi = in__.vector_lb_constrain(0, (K * (1 - proportional_model)));
        size_t psi_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            vars__.push_back(psi(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z = in__.vector_lub_constrain(get_base1(z_bound, 1, "z_bound", 1), get_base1(z_bound, 2, "z_bound", 1), (nZ * (1 - proportional_model)));
        size_t z_j_1_max__ = (nZ * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            vars__.push_back(z(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> zpos = in__.vector_constrain((K * (1 - proportional_model)));
        size_t zpos_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < zpos_j_1_max__; ++j_1__) {
            vars__.push_back(zpos(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > p_z;
        size_t p_z_d_0_max__ = (P * proportional_model);
        p_z.reserve(p_z_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < p_z_d_0_max__; ++d_0__) {
            p_z.push_back(in__.simplex_constrain(K));
        }
        size_t p_z_j_1_max__ = K;
        size_t p_z_k_0_max__ = (P * proportional_model);
        for (size_t j_1__ = 0; j_1__ < p_z_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_z_k_0_max__; ++k_0__) {
                vars__.push_back(p_z[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> spline_a = in__.matrix_constrain((K * est_spline), (n_knots * est_spline));
        size_t spline_a_j_2_max__ = (n_knots * est_spline);
        size_t spline_a_j_1_max__ = (K * est_spline);
        for (size_t j_2__ = 0; j_2__ < spline_a_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < spline_a_j_1_max__; ++j_1__) {
                vars__.push_back(spline_a(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> b_obs = in__.matrix_constrain(n_obs_covar, P);
        size_t b_obs_j_2_max__ = P;
        size_t b_obs_j_1_max__ = n_obs_covar;
        for (size_t j_2__ = 0; j_2__ < b_obs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_obs_j_1_max__; ++j_1__) {
                vars__.push_back(b_obs(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> b_pro = in__.matrix_constrain(n_pro_covar, K);
        size_t b_pro_j_2_max__ = K;
        size_t b_pro_j_1_max__ = n_pro_covar;
        for (size_t j_2__ = 0; j_2__ < b_pro_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_pro_j_1_max__; ++j_1__) {
                vars__.push_back(b_pro(j_1__, j_2__));
            }
        }
        std::vector<double> sigma;
        size_t sigma_d_0_max__ = (nVariances * est_sigma_params);
        sigma.reserve(sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
            sigma.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_k_0_max__ = (nVariances * est_sigma_params);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        std::vector<double> gamma_a;
        size_t gamma_a_d_0_max__ = (nVariances * est_gamma_params);
        gamma_a.reserve(gamma_a_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < gamma_a_d_0_max__; ++d_0__) {
            gamma_a.push_back(in__.scalar_lb_constrain(0));
        }
        size_t gamma_a_k_0_max__ = (nVariances * est_gamma_params);
        for (size_t k_0__ = 0; k_0__ < gamma_a_k_0_max__; ++k_0__) {
            vars__.push_back(gamma_a[k_0__]);
        }
        std::vector<double> nb2_phi;
        size_t nb2_phi_d_0_max__ = (nVariances * est_nb2_params);
        nb2_phi.reserve(nb2_phi_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < nb2_phi_d_0_max__; ++d_0__) {
            nb2_phi.push_back(in__.scalar_lb_constrain(0));
        }
        size_t nb2_phi_k_0_max__ = (nVariances * est_nb2_params);
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            vars__.push_back(nb2_phi[k_0__]);
        }
        std::vector<double> nu;
        size_t nu_d_0_max__ = estimate_nu;
        nu.reserve(nu_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < nu_d_0_max__; ++d_0__) {
            nu.push_back(in__.scalar_lb_constrain(2));
        }
        size_t nu_k_0_max__ = estimate_nu;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            vars__.push_back(nu[k_0__]);
        }
        std::vector<double> ymiss;
        size_t ymiss_d_0_max__ = n_na;
        ymiss.reserve(ymiss_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < ymiss_d_0_max__; ++d_0__) {
            ymiss.push_back(in__.scalar_constrain());
        }
        size_t ymiss_k_0_max__ = n_na;
        for (size_t k_0__ = 0; k_0__ < ymiss_k_0_max__; ++k_0__) {
            vars__.push_back(ymiss[k_0__]);
        }
        std::vector<double> phi;
        size_t phi_d_0_max__ = (est_phi * K);
        phi.reserve(phi_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < phi_d_0_max__; ++d_0__) {
            phi.push_back(in__.scalar_lub_constrain(-(1), 1));
        }
        size_t phi_k_0_max__ = (est_phi * K);
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            vars__.push_back(phi[k_0__]);
        }
        std::vector<double> theta;
        size_t theta_d_0_max__ = (est_theta * K);
        theta.reserve(theta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
            theta.push_back(in__.scalar_lub_constrain(-(1), 1));
        }
        size_t theta_k_0_max__ = (est_theta * K);
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            vars__.push_back(theta[k_0__]);
        }
        std::vector<double> gp_theta;
        size_t gp_theta_d_0_max__ = (est_gp * K);
        gp_theta.reserve(gp_theta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < gp_theta_d_0_max__; ++d_0__) {
            gp_theta.push_back(in__.scalar_lb_constrain(0));
        }
        size_t gp_theta_k_0_max__ = (est_gp * K);
        for (size_t k_0__ = 0; k_0__ < gp_theta_k_0_max__; ++k_0__) {
            vars__.push_back(gp_theta[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Lcorr = in__.cholesky_factor_corr_constrain(n_pcor);
        size_t Lcorr_j_2_max__ = n_pcor;
        size_t Lcorr_j_1_max__ = n_pcor;
        for (size_t j_2__ = 0; j_2__ < Lcorr_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Lcorr_j_1_max__; ++j_1__) {
                vars__.push_back(Lcorr(j_1__, j_2__));
            }
        }
        std::vector<double> sigma_process;
        size_t sigma_process_d_0_max__ = (est_sigma_process * n_sigma_process);
        sigma_process.reserve(sigma_process_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_process_d_0_max__; ++d_0__) {
            sigma_process.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_process_k_0_max__ = (est_sigma_process * n_sigma_process);
        for (size_t k_0__ = 0; k_0__ < sigma_process_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_process[k_0__]);
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > effectsKnots;
        size_t effectsKnots_d_0_max__ = (K * est_gp);
        effectsKnots.reserve(effectsKnots_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < effectsKnots_d_0_max__; ++d_0__) {
            effectsKnots.push_back(in__.vector_constrain((n_knots * est_gp)));
        }
        size_t effectsKnots_j_1_max__ = (n_knots * est_gp);
        size_t effectsKnots_k_0_max__ = (K * est_gp);
        for (size_t j_1__ = 0; j_1__ < effectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < effectsKnots_k_0_max__; ++k_0__) {
                vars__.push_back(effectsKnots[k_0__](j_1__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 192;
            validate_non_negative_index("pred", "P", P);
            validate_non_negative_index("pred", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> pred(P, N);
            stan::math::initialize(pred, DUMMY_VAR__);
            stan::math::fill(pred, DUMMY_VAR__);
            current_statement_begin__ = 193;
            validate_non_negative_index("Z", "P", P);
            validate_non_negative_index("Z", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Z(P, K);
            stan::math::initialize(Z, DUMMY_VAR__);
            stan::math::fill(Z, DUMMY_VAR__);
            current_statement_begin__ = 194;
            validate_non_negative_index("yall", "P", P);
            validate_non_negative_index("yall", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> yall(P, N);
            stan::math::initialize(yall, DUMMY_VAR__);
            stan::math::fill(yall, DUMMY_VAR__);
            current_statement_begin__ = 195;
            validate_non_negative_index("sigma_vec", "(P * est_sigma_params)", (P * est_sigma_params));
            Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_vec((P * est_sigma_params));
            stan::math::initialize(sigma_vec, DUMMY_VAR__);
            stan::math::fill(sigma_vec, DUMMY_VAR__);
            current_statement_begin__ = 196;
            validate_non_negative_index("gamma_a_vec", "(P * est_gamma_params)", (P * est_gamma_params));
            Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_a_vec((P * est_gamma_params));
            stan::math::initialize(gamma_a_vec, DUMMY_VAR__);
            stan::math::fill(gamma_a_vec, DUMMY_VAR__);
            current_statement_begin__ = 197;
            validate_non_negative_index("nb_phi_vec", "(P * est_nb2_params)", (P * est_nb2_params));
            Eigen::Matrix<double, Eigen::Dynamic, 1> nb_phi_vec((P * est_nb2_params));
            stan::math::initialize(nb_phi_vec, DUMMY_VAR__);
            stan::math::fill(nb_phi_vec, DUMMY_VAR__);
            current_statement_begin__ = 198;
            validate_non_negative_index("phi_vec", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> phi_vec(K);
            stan::math::initialize(phi_vec, DUMMY_VAR__);
            stan::math::fill(phi_vec, DUMMY_VAR__);
            current_statement_begin__ = 199;
            validate_non_negative_index("theta_vec", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_vec(K);
            stan::math::initialize(theta_vec, DUMMY_VAR__);
            stan::math::fill(theta_vec, DUMMY_VAR__);
            current_statement_begin__ = 200;
            validate_non_negative_index("x", "K", K);
            validate_non_negative_index("x", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> x(K, N);
            stan::math::initialize(x, DUMMY_VAR__);
            stan::math::fill(x, DUMMY_VAR__);
            current_statement_begin__ = 201;
            validate_non_negative_index("indicator", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> indicator(K);
            stan::math::initialize(indicator, DUMMY_VAR__);
            stan::math::fill(indicator, DUMMY_VAR__);
            current_statement_begin__ = 202;
            validate_non_negative_index("psi_root", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> psi_root(K);
            stan::math::initialize(psi_root, DUMMY_VAR__);
            stan::math::fill(psi_root, DUMMY_VAR__);
            current_statement_begin__ = 203;
            validate_non_negative_index("Sigma_derived", "((n_pcor * long_format) * est_cor)", ((n_pcor * long_format) * est_cor));
            validate_non_negative_index("Sigma_derived", "((n_pcor * long_format) * est_cor)", ((n_pcor * long_format) * est_cor));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma_derived(((n_pcor * long_format) * est_cor), ((n_pcor * long_format) * est_cor));
            stan::math::initialize(Sigma_derived, DUMMY_VAR__);
            stan::math::fill(Sigma_derived, DUMMY_VAR__);
            current_statement_begin__ = 204;
            validate_non_negative_index("Sigma_temp", "(((n_pcor - 1) * long_format) * est_cor)", (((n_pcor - 1) * long_format) * est_cor));
            validate_non_negative_index("Sigma_temp", "(((n_pcor - 1) * long_format) * est_cor)", (((n_pcor - 1) * long_format) * est_cor));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma_temp((((n_pcor - 1) * long_format) * est_cor), (((n_pcor - 1) * long_format) * est_cor));
            stan::math::initialize(Sigma_temp, DUMMY_VAR__);
            stan::math::fill(Sigma_temp, DUMMY_VAR__);
            current_statement_begin__ = 205;
            validate_non_negative_index("sigma12_vec", "(n_pcor - 1)", (n_pcor - 1));
            validate_non_negative_index("sigma12_vec", "1", 1);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> sigma12_vec((n_pcor - 1), 1);
            stan::math::initialize(sigma12_vec, DUMMY_VAR__);
            stan::math::fill(sigma12_vec, DUMMY_VAR__);
            current_statement_begin__ = 206;
            validate_non_negative_index("temp_sums", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            validate_non_negative_index("temp_sums", "((N * long_format) * est_cor)", ((N * long_format) * est_cor));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> temp_sums(((P * long_format) * est_cor), ((N * long_format) * est_cor));
            stan::math::initialize(temp_sums, DUMMY_VAR__);
            stan::math::fill(temp_sums, DUMMY_VAR__);
            current_statement_begin__ = 207;
            validate_non_negative_index("temp_counts", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            validate_non_negative_index("temp_counts", "((N * long_format) * est_cor)", ((N * long_format) * est_cor));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> temp_counts(((P * long_format) * est_cor), ((N * long_format) * est_cor));
            stan::math::initialize(temp_counts, DUMMY_VAR__);
            stan::math::fill(temp_counts, DUMMY_VAR__);
            current_statement_begin__ = 208;
            validate_non_negative_index("cond_sigma_vec", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            Eigen::Matrix<double, Eigen::Dynamic, 1> cond_sigma_vec(((P * long_format) * est_cor));
            stan::math::initialize(cond_sigma_vec, DUMMY_VAR__);
            stan::math::fill(cond_sigma_vec, DUMMY_VAR__);
            current_statement_begin__ = 209;
            validate_non_negative_index("cond_mean_vec", "((P * long_format) * est_cor)", ((P * long_format) * est_cor));
            Eigen::Matrix<double, Eigen::Dynamic, 1> cond_mean_vec(((P * long_format) * est_cor));
            stan::math::initialize(cond_mean_vec, DUMMY_VAR__);
            stan::math::fill(cond_mean_vec, DUMMY_VAR__);
            current_statement_begin__ = 210;
            double sigma11;
            (void) sigma11;  // dummy to suppress unused var warning
            stan::math::initialize(sigma11, DUMMY_VAR__);
            stan::math::fill(sigma11, DUMMY_VAR__);
            current_statement_begin__ = 211;
            validate_non_negative_index("sigma_pro", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_pro(K);
            stan::math::initialize(sigma_pro, DUMMY_VAR__);
            stan::math::fill(sigma_pro, DUMMY_VAR__);
            current_statement_begin__ = 212;
            validate_non_negative_index("spline_a_trans", "(K * est_spline)", (K * est_spline));
            validate_non_negative_index("spline_a_trans", "(n_knots * est_spline)", (n_knots * est_spline));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> spline_a_trans((K * est_spline), (n_knots * est_spline));
            stan::math::initialize(spline_a_trans, DUMMY_VAR__);
            stan::math::fill(spline_a_trans, DUMMY_VAR__);
            current_statement_begin__ = 213;
            validate_non_negative_index("SigmaKnots", "n_knots", n_knots);
            validate_non_negative_index("SigmaKnots", "n_knots", n_knots);
            validate_non_negative_index("SigmaKnots", "K", K);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > SigmaKnots(K, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_knots, n_knots));
            stan::math::initialize(SigmaKnots, DUMMY_VAR__);
            stan::math::fill(SigmaKnots, DUMMY_VAR__);
            current_statement_begin__ = 216;
            validate_non_negative_index("obs_cov_offset", "n_pos", n_pos);
            Eigen::Matrix<double, Eigen::Dynamic, 1> obs_cov_offset(n_pos);
            stan::math::initialize(obs_cov_offset, DUMMY_VAR__);
            stan::math::fill(obs_cov_offset, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 219;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 220;
                stan::model::assign(sigma_pro, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            1, 
                            "assigning variable sigma_pro");
                current_statement_begin__ = 221;
                if (as_bool(logical_eq(est_sigma_process, 1))) {
                    current_statement_begin__ = 222;
                    if (as_bool(logical_eq(n_sigma_process, 1))) {
                        current_statement_begin__ = 223;
                        stan::model::assign(sigma_pro, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    get_base1(sigma_process, 1, "sigma_process", 1), 
                                    "assigning variable sigma_pro");
                    } else {
                        current_statement_begin__ = 225;
                        stan::model::assign(sigma_pro, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    get_base1(sigma_process, k, "sigma_process", 1), 
                                    "assigning variable sigma_pro");
                    }
                }
            }
            current_statement_begin__ = 231;
            if (as_bool(logical_eq(est_phi, 1))) {
                current_statement_begin__ = 233;
                stan::math::assign(phi_vec, to_vector(phi));
            } else {
                current_statement_begin__ = 236;
                stan::math::assign(phi_vec, rep_vector(1.0, K));
            }
            current_statement_begin__ = 240;
            if (as_bool(logical_eq(est_theta, 1))) {
                current_statement_begin__ = 242;
                stan::math::assign(theta_vec, to_vector(theta));
            } else {
                current_statement_begin__ = 245;
                stan::math::assign(theta_vec, rep_vector(1.0, K));
            }
            current_statement_begin__ = 248;
            if (as_bool(logical_eq(est_sigma_params, 1))) {
                current_statement_begin__ = 249;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 249;
                    stan::model::assign(sigma_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                get_base1(sigma, get_base1(varIndx, p, "varIndx", 1), "sigma", 1), 
                                "assigning variable sigma_vec");
                }
            }
            current_statement_begin__ = 251;
            if (as_bool(logical_eq(est_gamma_params, 1))) {
                current_statement_begin__ = 252;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 252;
                    stan::model::assign(gamma_a_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                get_base1(gamma_a, get_base1(varIndx, p, "varIndx", 1), "gamma_a", 1), 
                                "assigning variable gamma_a_vec");
                }
            }
            current_statement_begin__ = 254;
            if (as_bool(logical_eq(est_nb2_params, 1))) {
                current_statement_begin__ = 255;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 255;
                    stan::model::assign(nb_phi_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                get_base1(nb2_phi, get_base1(varIndx, p, "varIndx", 1), "nb2_phi", 1), 
                                "assigning variable nb_phi_vec");
                }
            }
            current_statement_begin__ = 258;
            if (as_bool(logical_eq(long_format, 0))) {
                current_statement_begin__ = 260;
                for (int i = 1; i <= n_pos; ++i) {
                    current_statement_begin__ = 261;
                    stan::model::assign(yall, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), 
                                get_base1(y, i, "y", 1), 
                                "assigning variable yall");
                }
                current_statement_begin__ = 264;
                if (as_bool(logical_gt(n_na, 0))) {
                    current_statement_begin__ = 265;
                    for (int i = 1; i <= n_na; ++i) {
                        current_statement_begin__ = 266;
                        stan::model::assign(yall, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_na, i, "row_indx_na", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_na, i, "col_indx_na", 1)), stan::model::nil_index_list())), 
                                    get_base1(ymiss, i, "ymiss", 1), 
                                    "assigning variable yall");
                    }
                }
            }
            current_statement_begin__ = 271;
            if (as_bool(logical_eq(proportional_model, 0))) {
                current_statement_begin__ = 272;
                for (int i = 1; i <= nZ; ++i) {
                    current_statement_begin__ = 273;
                    stan::model::assign(Z, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx, i, "row_indx", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx, i, "col_indx", 1)), stan::model::nil_index_list())), 
                                get_base1(z, i, "z", 1), 
                                "assigning variable Z");
                }
                current_statement_begin__ = 276;
                if (as_bool(logical_gt(nZero, 2))) {
                    current_statement_begin__ = 277;
                    for (int i = 1; i <= (nZero - 2); ++i) {
                        current_statement_begin__ = 278;
                        stan::model::assign(Z, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_z, i, "row_indx_z", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_z, i, "col_indx_z", 1)), stan::model::nil_index_list())), 
                                    0, 
                                    "assigning variable Z");
                    }
                }
                current_statement_begin__ = 281;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 282;
                    stan::model::assign(Z, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                get_base1(zpos, k, "zpos", 1), 
                                "assigning variable Z");
                }
                current_statement_begin__ = 285;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 286;
                    if (as_bool(logical_lt(get_base1(zpos, k, "zpos", 1), 0))) {
                        current_statement_begin__ = 287;
                        stan::model::assign(indicator, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    -(1), 
                                    "assigning variable indicator");
                    } else {
                        current_statement_begin__ = 289;
                        stan::model::assign(indicator, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    1, 
                                    "assigning variable indicator");
                    }
                    current_statement_begin__ = 291;
                    stan::model::assign(psi_root, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                stan::math::sqrt(get_base1(psi, k, "psi", 1)), 
                                "assigning variable psi_root");
                    current_statement_begin__ = 292;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 293;
                        stan::model::assign(Z, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    ((get_base1(Z, p, k, "Z", 1) * get_base1(indicator, k, "indicator", 1)) * (1 / get_base1(psi_root, k, "psi_root", 1))), 
                                    "assigning variable Z");
                    }
                }
                current_statement_begin__ = 297;
                if (as_bool(logical_eq(est_rw, 1))) {
                    current_statement_begin__ = 298;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 299;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                    get_base1(x0, k, "x0", 1), 
                                    "assigning variable x");
                        current_statement_begin__ = 303;
                        for (int t = 2; t <= N; ++t) {
                            current_statement_begin__ = 304;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                        ((get_base1(phi_vec, k, "phi_vec", 1) * get_base1(x, k, (t - 1), "x", 1)) + get_base1(devs, k, (t - 1), "devs", 1)), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 308;
                if (as_bool(logical_eq(est_spline, 1))) {
                    current_statement_begin__ = 310;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 310;
                        stan::model::assign(spline_a_trans, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    multiply(get_base1(spline_a, k, "spline_a", 1), get_base1(sigma_pro, k, "sigma_pro", 1)), 
                                    "assigning variable spline_a_trans");
                    }
                    current_statement_begin__ = 311;
                    stan::math::assign(x, multiply(spline_a_trans, B_spline));
                    current_statement_begin__ = 312;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 312;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    add(get_base1(x0, k, "x0", 1), get_base1(x, k, "x", 1)), 
                                    "assigning variable x");
                    }
                }
                current_statement_begin__ = 314;
                if (as_bool(logical_eq(est_gp, 1))) {
                    current_statement_begin__ = 316;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 317;
                        stan::model::assign(SigmaKnots, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    cov_exp_quad(knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), 
                                    "assigning variable SigmaKnots");
                        current_statement_begin__ = 320;
                        for (int i = 1; i <= n_knots; ++i) {
                            current_statement_begin__ = 321;
                            stan::model::assign(SigmaKnots, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(SigmaKnots, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), "SigmaKnots") + gp_delta), 
                                        "assigning variable SigmaKnots");
                        }
                        current_statement_begin__ = 330;
                        if (as_bool(logical_eq(n_knots, N))) {
                            current_statement_begin__ = 332;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1)), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        } else {
                            current_statement_begin__ = 334;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(multiply(multiply(cov_exp_quad(data_locs, knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), inverse_spd(get_base1(SigmaKnots, k, "SigmaKnots", 1))), cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1))), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 340;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 342;
                    stan::model::assign(x, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                multiply(multiply(get_base1(x, k, "x", 1), get_base1(indicator, k, "indicator", 1)), get_base1(psi_root, k, "psi_root", 1)), 
                                "assigning variable x");
                }
            }
            current_statement_begin__ = 346;
            if (as_bool(logical_eq(proportional_model, 1))) {
                current_statement_begin__ = 348;
                if (as_bool(logical_eq(est_rw, 1))) {
                    current_statement_begin__ = 349;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 350;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                    get_base1(x0, k, "x0", 1), 
                                    "assigning variable x");
                        current_statement_begin__ = 354;
                        for (int t = 2; t <= N; ++t) {
                            current_statement_begin__ = 355;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                        ((get_base1(phi_vec, k, "phi_vec", 1) * get_base1(x, k, (t - 1), "x", 1)) + get_base1(devs, k, (t - 1), "devs", 1)), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 359;
                if (as_bool(logical_eq(est_spline, 1))) {
                    current_statement_begin__ = 360;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 360;
                        stan::model::assign(spline_a_trans, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    multiply(get_base1(spline_a, k, "spline_a", 1), get_base1(sigma_pro, k, "sigma_pro", 1)), 
                                    "assigning variable spline_a_trans");
                    }
                    current_statement_begin__ = 361;
                    stan::math::assign(x, multiply(spline_a_trans, B_spline));
                    current_statement_begin__ = 362;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 362;
                        stan::model::assign(x, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    add(get_base1(x0, k, "x0", 1), get_base1(x, k, "x", 1)), 
                                    "assigning variable x");
                    }
                }
                current_statement_begin__ = 364;
                if (as_bool(logical_eq(est_gp, 1))) {
                    current_statement_begin__ = 365;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 366;
                        stan::model::assign(SigmaKnots, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    cov_exp_quad(knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), 
                                    "assigning variable SigmaKnots");
                        current_statement_begin__ = 369;
                        for (int i = 1; i <= n_knots; ++i) {
                            current_statement_begin__ = 370;
                            stan::model::assign(SigmaKnots, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), 
                                        (stan::model::rvalue(SigmaKnots, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), "SigmaKnots") + gp_delta), 
                                        "assigning variable SigmaKnots");
                        }
                        current_statement_begin__ = 379;
                        if (as_bool(logical_eq(n_knots, N))) {
                            current_statement_begin__ = 381;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1)), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        } else {
                            current_statement_begin__ = 383;
                            stan::model::assign(x, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        to_row_vector(multiply(multiply(multiply(cov_exp_quad(data_locs, knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)), inverse_spd(get_base1(SigmaKnots, k, "SigmaKnots", 1))), cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1))), get_base1(effectsKnots, k, "effectsKnots", 1))), 
                                        "assigning variable x");
                        }
                    }
                }
                current_statement_begin__ = 389;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 393;
                    stan::model::assign(Z, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                to_row_vector(get_base1(p_z, p, "p_z", 1)), 
                                "assigning variable Z");
                }
            }
            current_statement_begin__ = 398;
            if (as_bool(logical_gt(num_pro_covar, 0))) {
                current_statement_begin__ = 399;
                for (int i = 1; i <= num_pro_covar; ++i) {
                    current_statement_begin__ = 401;
                    stan::model::assign(x, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 2, "pro_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 1, "pro_covar_index", 2)), stan::model::nil_index_list())), 
                                (stan::model::rvalue(x, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 2, "pro_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 1, "pro_covar_index", 2)), stan::model::nil_index_list())), "x") + (get_base1(b_pro, get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 3, "pro_covar_index", 2), get_base1(get_base1(pro_covar_index, i, "pro_covar_index", 1), 2, "pro_covar_index", 2), "b_pro", 1) * get_base1(pro_covar_value, i, "pro_covar_value", 1))), 
                                "assigning variable x");
                }
            }
            current_statement_begin__ = 407;
            stan::math::assign(pred, multiply(Z, x));
            current_statement_begin__ = 409;
            for (int i = 1; i <= n_pos; ++i) {
                current_statement_begin__ = 410;
                stan::model::assign(obs_cov_offset, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable obs_cov_offset");
            }
            current_statement_begin__ = 413;
            if (as_bool(logical_gt(num_obs_covar, 0))) {
                current_statement_begin__ = 414;
                if (as_bool(logical_eq(long_format, 0))) {
                    current_statement_begin__ = 415;
                    for (int i = 1; i <= num_obs_covar; ++i) {
                        current_statement_begin__ = 418;
                        stan::model::assign(pred, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 1, "obs_covar_index", 2)), stan::model::nil_index_list())), 
                                    (stan::model::rvalue(pred, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2)), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 1, "obs_covar_index", 2)), stan::model::nil_index_list())), "pred") + (get_base1(b_obs, get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 3, "obs_covar_index", 2), get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2), "b_obs", 1) * get_base1(obs_covar_value, i, "obs_covar_value", 1))), 
                                    "assigning variable pred");
                    }
                } else {
                    current_statement_begin__ = 423;
                    for (int i = 1; i <= num_obs_covar; ++i) {
                        current_statement_begin__ = 424;
                        stan::model::assign(obs_cov_offset, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(match_obs_covar, i, "match_obs_covar", 1)), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(obs_cov_offset, stan::model::cons_list(stan::model::index_uni(get_base1(match_obs_covar, i, "match_obs_covar", 1)), stan::model::nil_index_list()), "obs_cov_offset") + (get_base1(b_obs, get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 3, "obs_covar_index", 2), get_base1(get_base1(obs_covar_index, i, "obs_covar_index", 1), 2, "obs_covar_index", 2), "b_obs", 1) * get_base1(obs_covar_value, i, "obs_covar_value", 1))), 
                                    "assigning variable obs_cov_offset");
                    }
                }
            }
            current_statement_begin__ = 429;
            if (as_bool((primitive_value(logical_eq(long_format, 1)) && primitive_value(logical_eq(est_cor, 1))))) {
                current_statement_begin__ = 431;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 432;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 433;
                        stan::model::assign(temp_sums, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                    0.0, 
                                    "assigning variable temp_sums");
                        current_statement_begin__ = 434;
                        stan::model::assign(temp_counts, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                    0.0, 
                                    "assigning variable temp_counts");
                    }
                }
                current_statement_begin__ = 437;
                for (int i = 1; i <= n_pos; ++i) {
                    current_statement_begin__ = 438;
                    stan::model::assign(temp_sums, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), 
                                (stan::model::rvalue(temp_sums, stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), "temp_sums") + (get_base1(y, i, "y", 1) - get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1))), 
                                "assigning variable temp_sums");
                    current_statement_begin__ = 439;
                    stan::model::assign(temp_counts, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), 
                                (stan::model::rvalue(temp_counts, stan::model::cons_list(stan::model::index_uni(get_base1(row_indx_pos, i, "row_indx_pos", 1)), stan::model::cons_list(stan::model::index_uni(get_base1(col_indx_pos, i, "col_indx_pos", 1)), stan::model::nil_index_list())), "temp_counts") + 1), 
                                "assigning variable temp_counts");
                }
                current_statement_begin__ = 441;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 442;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 444;
                        stan::model::assign(temp_sums, 
                                    stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                    (get_base1(temp_sums, p, n, "temp_sums", 1) / get_base1(temp_counts, p, n, "temp_counts", 1)), 
                                    "assigning variable temp_sums");
                    }
                }
                current_statement_begin__ = 448;
                stan::math::assign(Sigma_derived, quad_form_diag(multiply_lower_tri_self_transpose(Lcorr), sigma_vec));
                current_statement_begin__ = 450;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 451;
                    stan::math::assign(sigma11, get_base1(Sigma_derived, p, p, "Sigma_derived", 1));
                    current_statement_begin__ = 452;
                    stan::math::assign(Sigma_temp, inverse(subset(Sigma_derived, p, P, pstream__)));
                    current_statement_begin__ = 453;
                    stan::math::assign(sigma12_vec, subsetvec(Sigma_derived, p, P, pstream__));
                    current_statement_begin__ = 455;
                    stan::model::assign(cond_mean_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                multiply(multiply(to_row_vector(sigma12_vec), Sigma_temp), to_vector(subsetvec2(col(temp_sums, p), p, P, pstream__))), 
                                "assigning variable cond_mean_vec");
                    current_statement_begin__ = 457;
                    stan::model::assign(cond_sigma_vec, 
                                stan::model::cons_list(stan::model::index_uni(p), stan::model::nil_index_list()), 
                                stan::math::sqrt((sigma11 - multiply(multiply(to_row_vector(sigma12_vec), Sigma_temp), to_vector(sigma12_vec)))), 
                                "assigning variable cond_sigma_vec");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t pred_j_2_max__ = N;
                size_t pred_j_1_max__ = P;
                for (size_t j_2__ = 0; j_2__ < pred_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < pred_j_1_max__; ++j_1__) {
                        vars__.push_back(pred(j_1__, j_2__));
                    }
                }
                size_t Z_j_2_max__ = K;
                size_t Z_j_1_max__ = P;
                for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                        vars__.push_back(Z(j_1__, j_2__));
                    }
                }
                size_t yall_j_2_max__ = N;
                size_t yall_j_1_max__ = P;
                for (size_t j_2__ = 0; j_2__ < yall_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < yall_j_1_max__; ++j_1__) {
                        vars__.push_back(yall(j_1__, j_2__));
                    }
                }
                size_t sigma_vec_j_1_max__ = (P * est_sigma_params);
                for (size_t j_1__ = 0; j_1__ < sigma_vec_j_1_max__; ++j_1__) {
                    vars__.push_back(sigma_vec(j_1__));
                }
                size_t gamma_a_vec_j_1_max__ = (P * est_gamma_params);
                for (size_t j_1__ = 0; j_1__ < gamma_a_vec_j_1_max__; ++j_1__) {
                    vars__.push_back(gamma_a_vec(j_1__));
                }
                size_t nb_phi_vec_j_1_max__ = (P * est_nb2_params);
                for (size_t j_1__ = 0; j_1__ < nb_phi_vec_j_1_max__; ++j_1__) {
                    vars__.push_back(nb_phi_vec(j_1__));
                }
                size_t phi_vec_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < phi_vec_j_1_max__; ++j_1__) {
                    vars__.push_back(phi_vec(j_1__));
                }
                size_t theta_vec_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < theta_vec_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_vec(j_1__));
                }
                size_t x_j_2_max__ = N;
                size_t x_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < x_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < x_j_1_max__; ++j_1__) {
                        vars__.push_back(x(j_1__, j_2__));
                    }
                }
                size_t indicator_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < indicator_j_1_max__; ++j_1__) {
                    vars__.push_back(indicator(j_1__));
                }
                size_t psi_root_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < psi_root_j_1_max__; ++j_1__) {
                    vars__.push_back(psi_root(j_1__));
                }
                size_t Sigma_derived_j_2_max__ = ((n_pcor * long_format) * est_cor);
                size_t Sigma_derived_j_1_max__ = ((n_pcor * long_format) * est_cor);
                for (size_t j_2__ = 0; j_2__ < Sigma_derived_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Sigma_derived_j_1_max__; ++j_1__) {
                        vars__.push_back(Sigma_derived(j_1__, j_2__));
                    }
                }
                size_t Sigma_temp_j_2_max__ = (((n_pcor - 1) * long_format) * est_cor);
                size_t Sigma_temp_j_1_max__ = (((n_pcor - 1) * long_format) * est_cor);
                for (size_t j_2__ = 0; j_2__ < Sigma_temp_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Sigma_temp_j_1_max__; ++j_1__) {
                        vars__.push_back(Sigma_temp(j_1__, j_2__));
                    }
                }
                size_t sigma12_vec_j_2_max__ = 1;
                size_t sigma12_vec_j_1_max__ = (n_pcor - 1);
                for (size_t j_2__ = 0; j_2__ < sigma12_vec_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < sigma12_vec_j_1_max__; ++j_1__) {
                        vars__.push_back(sigma12_vec(j_1__, j_2__));
                    }
                }
                size_t temp_sums_j_2_max__ = ((N * long_format) * est_cor);
                size_t temp_sums_j_1_max__ = ((P * long_format) * est_cor);
                for (size_t j_2__ = 0; j_2__ < temp_sums_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < temp_sums_j_1_max__; ++j_1__) {
                        vars__.push_back(temp_sums(j_1__, j_2__));
                    }
                }
                size_t temp_counts_j_2_max__ = ((N * long_format) * est_cor);
                size_t temp_counts_j_1_max__ = ((P * long_format) * est_cor);
                for (size_t j_2__ = 0; j_2__ < temp_counts_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < temp_counts_j_1_max__; ++j_1__) {
                        vars__.push_back(temp_counts(j_1__, j_2__));
                    }
                }
                size_t cond_sigma_vec_j_1_max__ = ((P * long_format) * est_cor);
                for (size_t j_1__ = 0; j_1__ < cond_sigma_vec_j_1_max__; ++j_1__) {
                    vars__.push_back(cond_sigma_vec(j_1__));
                }
                size_t cond_mean_vec_j_1_max__ = ((P * long_format) * est_cor);
                for (size_t j_1__ = 0; j_1__ < cond_mean_vec_j_1_max__; ++j_1__) {
                    vars__.push_back(cond_mean_vec(j_1__));
                }
                vars__.push_back(sigma11);
                size_t sigma_pro_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < sigma_pro_j_1_max__; ++j_1__) {
                    vars__.push_back(sigma_pro(j_1__));
                }
                size_t spline_a_trans_j_2_max__ = (n_knots * est_spline);
                size_t spline_a_trans_j_1_max__ = (K * est_spline);
                for (size_t j_2__ = 0; j_2__ < spline_a_trans_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < spline_a_trans_j_1_max__; ++j_1__) {
                        vars__.push_back(spline_a_trans(j_1__, j_2__));
                    }
                }
                size_t SigmaKnots_j_2_max__ = n_knots;
                size_t SigmaKnots_j_1_max__ = n_knots;
                size_t SigmaKnots_k_0_max__ = K;
                for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < SigmaKnots_k_0_max__; ++k_0__) {
                            vars__.push_back(SigmaKnots[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t obs_cov_offset_j_1_max__ = n_pos;
                for (size_t j_1__ = 0; j_1__ < obs_cov_offset_j_1_max__; ++j_1__) {
                    vars__.push_back(obs_cov_offset(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 574;
            validate_non_negative_index("log_lik", "n_loglik", n_loglik);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(n_loglik);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 575;
            validate_non_negative_index("Omega", "n_pcor", n_pcor);
            validate_non_negative_index("Omega", "n_pcor", n_pcor);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Omega(n_pcor, n_pcor);
            stan::math::initialize(Omega, DUMMY_VAR__);
            stan::math::fill(Omega, DUMMY_VAR__);
            current_statement_begin__ = 576;
            validate_non_negative_index("Sigma", "n_pcor", n_pcor);
            validate_non_negative_index("Sigma", "n_pcor", n_pcor);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Sigma(n_pcor, n_pcor);
            stan::math::initialize(Sigma, DUMMY_VAR__);
            stan::math::fill(Sigma, DUMMY_VAR__);
            current_statement_begin__ = 577;
            validate_non_negative_index("xstar", "K", K);
            validate_non_negative_index("xstar", "1", 1);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> xstar(K, 1);
            stan::math::initialize(xstar, DUMMY_VAR__);
            stan::math::fill(xstar, DUMMY_VAR__);
            current_statement_begin__ = 578;
            validate_non_negative_index("future_devs", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> future_devs(K);
            stan::math::initialize(future_devs, DUMMY_VAR__);
            stan::math::fill(future_devs, DUMMY_VAR__);
            current_statement_begin__ = 579;
            validate_non_negative_index("SigmaKnots_pred", "n_knots", n_knots);
            validate_non_negative_index("SigmaKnots_pred", "n_knots", n_knots);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SigmaKnots_pred(n_knots, n_knots);
            stan::math::initialize(SigmaKnots_pred, DUMMY_VAR__);
            stan::math::fill(SigmaKnots_pred, DUMMY_VAR__);
            current_statement_begin__ = 580;
            validate_non_negative_index("SigmaOffDiag_pred", "n_knots", n_knots);
            Eigen::Matrix<double, 1, Eigen::Dynamic> SigmaOffDiag_pred(n_knots);
            stan::math::initialize(SigmaOffDiag_pred, DUMMY_VAR__);
            stan::math::fill(SigmaOffDiag_pred, DUMMY_VAR__);
            current_statement_begin__ = 581;
            int j;
            (void) j;  // dummy to suppress unused var warning
            stan::math::fill(j, std::numeric_limits<int>::min());
            // generated quantities statements
            current_statement_begin__ = 582;
            stan::math::assign(j, 0);
            current_statement_begin__ = 584;
            if (as_bool(logical_eq(est_cor, 1))) {
                current_statement_begin__ = 585;
                stan::math::assign(Omega, multiply_lower_tri_self_transpose(Lcorr));
                current_statement_begin__ = 586;
                stan::math::assign(Sigma, quad_form_diag(Omega, sigma_vec));
            }
            current_statement_begin__ = 590;
            if (as_bool(logical_eq(est_cor, 0))) {
                current_statement_begin__ = 591;
                if (as_bool(logical_eq(long_format, 0))) {
                    current_statement_begin__ = 592;
                    stan::math::assign(j, 0);
                    current_statement_begin__ = 593;
                    for (int n = 1; n <= N; ++n) {
                        current_statement_begin__ = 594;
                        for (int p = 1; p <= P; ++p) {
                            current_statement_begin__ = 595;
                            stan::math::assign(j, (j + 1));
                            current_statement_begin__ = 596;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                        normal_log(get_base1(yall, p, n, "yall", 1), get_base1(pred, p, n, "pred", 1), get_base1(sigma_vec, p, "sigma_vec", 1)), 
                                        "assigning variable log_lik");
                        }
                    }
                } else {
                    current_statement_begin__ = 600;
                    if (as_bool(logical_eq(obs_model, 1))) {
                        current_statement_begin__ = 600;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 600;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        normal_log(get_base1(y, i, "y", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1)), get_base1(sigma_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "sigma_vec", 1)), 
                                        "assigning variable log_lik");
                        }
                    }
                    current_statement_begin__ = 601;
                    if (as_bool(logical_eq(obs_model, 2))) {
                        current_statement_begin__ = 601;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 601;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        gamma_log(get_base1(y, i, "y", 1), get_base1(gamma_a_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "gamma_a_vec", 1), (get_base1(gamma_a_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "gamma_a_vec", 1) / stan::math::exp((get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1))))), 
                                        "assigning variable log_lik");
                        }
                    }
                    current_statement_begin__ = 602;
                    if (as_bool(logical_eq(obs_model, 3))) {
                        current_statement_begin__ = 602;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 602;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        poisson_log_log(get_base1(y_int, i, "y_int", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1))), 
                                        "assigning variable log_lik");
                        }
                    }
                    current_statement_begin__ = 603;
                    if (as_bool(logical_eq(obs_model, 4))) {
                        current_statement_begin__ = 603;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 603;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        neg_binomial_2_log_log(get_base1(y_int, i, "y_int", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1)), get_base1(nb_phi_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "nb_phi_vec", 1)), 
                                        "assigning variable log_lik");
                        }
                    }
                    current_statement_begin__ = 604;
                    if (as_bool(logical_eq(obs_model, 5))) {
                        current_statement_begin__ = 604;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 604;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        bernoulli_logit_log(get_base1(y_int, i, "y_int", 1), (get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1))), 
                                        "assigning variable log_lik");
                        }
                    }
                    current_statement_begin__ = 605;
                    if (as_bool(logical_eq(obs_model, 6))) {
                        current_statement_begin__ = 605;
                        for (int i = 1; i <= n_pos; ++i) {
                            current_statement_begin__ = 605;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        lognormal_log(get_base1(y, i, "y", 1), get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1), (get_base1(sigma_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "sigma_vec", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1))), 
                                        "assigning variable log_lik");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 610;
                if (as_bool(logical_eq(long_format, 0))) {
                    current_statement_begin__ = 611;
                    for (int i = 1; i <= N; ++i) {
                        current_statement_begin__ = 612;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    multi_normal_cholesky_log(col(yall, i), col(pred, i), diag_pre_multiply(sigma_vec, Lcorr)), 
                                    "assigning variable log_lik");
                    }
                } else {
                    current_statement_begin__ = 615;
                    for (int i = 1; i <= n_pos; ++i) {
                        current_statement_begin__ = 617;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    normal_log(get_base1(y, i, "y", 1), ((get_base1(pred, get_base1(row_indx_pos, i, "row_indx_pos", 1), get_base1(col_indx_pos, i, "col_indx_pos", 1), "pred", 1) + get_base1(obs_cov_offset, i, "obs_cov_offset", 1)) + get_base1(cond_mean_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "cond_mean_vec", 1)), get_base1(cond_sigma_vec, get_base1(row_indx_pos, i, "row_indx_pos", 1), "cond_sigma_vec", 1)), 
                                    "assigning variable log_lik");
                    }
                }
            }
            current_statement_begin__ = 622;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 623;
                stan::model::assign(future_devs, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable future_devs");
            }
            current_statement_begin__ = 626;
            if (as_bool(logical_eq(est_rw, 1))) {
                current_statement_begin__ = 627;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 628;
                    if (as_bool(logical_eq(use_normal, 0))) {
                        current_statement_begin__ = 630;
                        if (as_bool(logical_eq(estimate_nu, 1))) {
                            current_statement_begin__ = 631;
                            stan::model::assign(future_devs, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        student_t_rng(get_base1(nu, 1, "nu", 1), (get_base1(theta_vec, k, "theta_vec", 1) * get_base1(devs, k, (N - 1), "devs", 1)), get_base1(sigma_pro, k, "sigma_pro", 1), base_rng__), 
                                        "assigning variable future_devs");
                        } else {
                            current_statement_begin__ = 633;
                            stan::model::assign(future_devs, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                        student_t_rng(nu_fixed, (get_base1(theta_vec, k, "theta_vec", 1) * get_base1(devs, k, (N - 1), "devs", 1)), get_base1(sigma_pro, k, "sigma_pro", 1), base_rng__), 
                                        "assigning variable future_devs");
                        }
                    } else {
                        current_statement_begin__ = 637;
                        stan::model::assign(future_devs, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    normal_rng((get_base1(theta_vec, k, "theta_vec", 1) * get_base1(devs, k, (N - 1), "devs", 1)), get_base1(sigma_pro, k, "sigma_pro", 1), base_rng__), 
                                    "assigning variable future_devs");
                    }
                    current_statement_begin__ = 639;
                    stan::model::assign(xstar, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                (get_base1(x, k, N, "x", 1) + get_base1(future_devs, k, "future_devs", 1)), 
                                "assigning variable xstar");
                }
            }
            current_statement_begin__ = 642;
            if (as_bool(logical_eq(est_spline, 1))) {
                current_statement_begin__ = 644;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 645;
                    stan::model::assign(xstar, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                (get_base1(spline_a_trans, k, n_knots, "spline_a_trans", 1) * get_base1(B_spline, n_knots, N, "B_spline", 1)), 
                                "assigning variable xstar");
                }
            }
            current_statement_begin__ = 648;
            if (as_bool(logical_eq(est_gp, 1))) {
                current_statement_begin__ = 649;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 650;
                    stan::math::assign(SigmaKnots_pred, cov_exp_quad(knot_locs, get_base1(sigma_pro, k, "sigma_pro", 1), get_base1(gp_theta, k, "gp_theta", 1)));
                    current_statement_begin__ = 651;
                    for (int i = 1; i <= n_knots; ++i) {
                        current_statement_begin__ = 652;
                        stan::model::assign(SigmaKnots_pred, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                    (stan::model::rvalue(SigmaKnots_pred, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "SigmaKnots_pred") + gp_delta), 
                                    "assigning variable SigmaKnots_pred");
                    }
                    current_statement_begin__ = 655;
                    stan::math::assign(SigmaOffDiag_pred, multiply(to_row_vector(multiply(square(get_base1(sigma_pro, k, "sigma_pro", 1)), stan::math::exp(divide(minus(distKnots21_pred), (2.0 * pow(get_base1(gp_theta, k, "gp_theta", 1), 2.0)))))), inverse_spd(SigmaKnots_pred)));
                    current_statement_begin__ = 656;
                    stan::model::assign(xstar, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                multiply(multiply(SigmaOffDiag_pred, cholesky_decompose(get_base1(SigmaKnots, k, "SigmaKnots", 1))), get_base1(effectsKnots, k, "effectsKnots", 1)), 
                                "assigning variable xstar");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 574;
            size_t log_lik_j_1_max__ = n_loglik;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 575;
            size_t Omega_j_2_max__ = n_pcor;
            size_t Omega_j_1_max__ = n_pcor;
            for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                    vars__.push_back(Omega(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 576;
            size_t Sigma_j_2_max__ = n_pcor;
            size_t Sigma_j_1_max__ = n_pcor;
            for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                    vars__.push_back(Sigma(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 577;
            size_t xstar_j_2_max__ = 1;
            size_t xstar_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < xstar_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xstar_j_1_max__; ++j_1__) {
                    vars__.push_back(xstar(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 578;
            size_t future_devs_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < future_devs_j_1_max__; ++j_1__) {
                vars__.push_back(future_devs(j_1__));
            }
            current_statement_begin__ = 579;
            size_t SigmaKnots_pred_j_2_max__ = n_knots;
            size_t SigmaKnots_pred_j_1_max__ = n_knots;
            for (size_t j_2__ = 0; j_2__ < SigmaKnots_pred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaKnots_pred_j_1_max__; ++j_1__) {
                    vars__.push_back(SigmaKnots_pred(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 580;
            size_t SigmaOffDiag_pred_j_1_max__ = n_knots;
            for (size_t j_1__ = 0; j_1__ < SigmaOffDiag_pred_j_1_max__; ++j_1__) {
                vars__.push_back(SigmaOffDiag_pred(j_1__));
            }
            current_statement_begin__ = 581;
            check_greater_or_equal(function__, "j", j, 0);
            vars__.push_back(j);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_dfa";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t devs_j_2_max__ = ((N - 1) * est_rw);
        size_t devs_j_1_max__ = (K * est_rw);
        for (size_t j_2__ = 0; j_2__ < devs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < devs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "devs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t x0_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < x0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "x0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_1_max__ = (nZ * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zpos_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < zpos_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zpos" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t p_z_j_1_max__ = K;
        size_t p_z_k_0_max__ = (P * proportional_model);
        for (size_t j_1__ = 0; j_1__ < p_z_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_z_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p_z" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t spline_a_j_2_max__ = (n_knots * est_spline);
        size_t spline_a_j_1_max__ = (K * est_spline);
        for (size_t j_2__ = 0; j_2__ < spline_a_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < spline_a_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spline_a" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_obs_j_2_max__ = P;
        size_t b_obs_j_1_max__ = n_obs_covar;
        for (size_t j_2__ = 0; j_2__ < b_obs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_obs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_obs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_pro_j_2_max__ = K;
        size_t b_pro_j_1_max__ = n_pro_covar;
        for (size_t j_2__ = 0; j_2__ < b_pro_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_pro_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_pro" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sigma_k_0_max__ = (nVariances * est_sigma_params);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_a_k_0_max__ = (nVariances * est_gamma_params);
        for (size_t k_0__ = 0; k_0__ < gamma_a_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_a" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nb2_phi_k_0_max__ = (nVariances * est_nb2_params);
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nb2_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_k_0_max__ = estimate_nu;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ymiss_k_0_max__ = n_na;
        for (size_t k_0__ = 0; k_0__ < ymiss_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ymiss" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_k_0_max__ = (est_phi * K);
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_k_0_max__ = (est_theta * K);
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gp_theta_k_0_max__ = (est_gp * K);
        for (size_t k_0__ = 0; k_0__ < gp_theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gp_theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Lcorr_j_2_max__ = n_pcor;
        size_t Lcorr_j_1_max__ = n_pcor;
        for (size_t j_2__ = 0; j_2__ < Lcorr_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Lcorr_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Lcorr" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sigma_process_k_0_max__ = (est_sigma_process * n_sigma_process);
        for (size_t k_0__ = 0; k_0__ < sigma_process_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_process" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t effectsKnots_j_1_max__ = (n_knots * est_gp);
        size_t effectsKnots_k_0_max__ = (K * est_gp);
        for (size_t j_1__ = 0; j_1__ < effectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < effectsKnots_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "effectsKnots" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t pred_j_2_max__ = N;
            size_t pred_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < pred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < pred_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "pred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Z_j_2_max__ = K;
            size_t Z_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t yall_j_2_max__ = N;
            size_t yall_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < yall_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < yall_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "yall" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_vec_j_1_max__ = (P * est_sigma_params);
            for (size_t j_1__ = 0; j_1__ < sigma_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_a_vec_j_1_max__ = (P * est_gamma_params);
            for (size_t j_1__ = 0; j_1__ < gamma_a_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_a_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t nb_phi_vec_j_1_max__ = (P * est_nb2_params);
            for (size_t j_1__ = 0; j_1__ < nb_phi_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "nb_phi_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_vec_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < phi_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_vec_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < theta_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t x_j_2_max__ = N;
            size_t x_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < x_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "x" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t indicator_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < indicator_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "indicator" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t psi_root_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < psi_root_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "psi_root" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Sigma_derived_j_2_max__ = ((n_pcor * long_format) * est_cor);
            size_t Sigma_derived_j_1_max__ = ((n_pcor * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < Sigma_derived_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_derived_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma_derived" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Sigma_temp_j_2_max__ = (((n_pcor - 1) * long_format) * est_cor);
            size_t Sigma_temp_j_1_max__ = (((n_pcor - 1) * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < Sigma_temp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_temp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma_temp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma12_vec_j_2_max__ = 1;
            size_t sigma12_vec_j_1_max__ = (n_pcor - 1);
            for (size_t j_2__ = 0; j_2__ < sigma12_vec_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigma12_vec_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma12_vec" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t temp_sums_j_2_max__ = ((N * long_format) * est_cor);
            size_t temp_sums_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < temp_sums_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < temp_sums_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "temp_sums" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t temp_counts_j_2_max__ = ((N * long_format) * est_cor);
            size_t temp_counts_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < temp_counts_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < temp_counts_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "temp_counts" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t cond_sigma_vec_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < cond_sigma_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cond_sigma_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t cond_mean_vec_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < cond_mean_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cond_mean_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma11";
            param_names__.push_back(param_name_stream__.str());
            size_t sigma_pro_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < sigma_pro_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_pro" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t spline_a_trans_j_2_max__ = (n_knots * est_spline);
            size_t spline_a_trans_j_1_max__ = (K * est_spline);
            for (size_t j_2__ = 0; j_2__ < spline_a_trans_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < spline_a_trans_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "spline_a_trans" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaKnots_j_2_max__ = n_knots;
            size_t SigmaKnots_j_1_max__ = n_knots;
            size_t SigmaKnots_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < SigmaKnots_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "SigmaKnots" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t obs_cov_offset_j_1_max__ = n_pos;
            for (size_t j_1__ = 0; j_1__ < obs_cov_offset_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obs_cov_offset" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = n_loglik;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Omega_j_2_max__ = n_pcor;
        size_t Omega_j_1_max__ = n_pcor;
        for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Sigma_j_2_max__ = n_pcor;
        size_t Sigma_j_1_max__ = n_pcor;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t xstar_j_2_max__ = 1;
        size_t xstar_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < xstar_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < xstar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xstar" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t future_devs_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < future_devs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "future_devs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t SigmaKnots_pred_j_2_max__ = n_knots;
        size_t SigmaKnots_pred_j_1_max__ = n_knots;
        for (size_t j_2__ = 0; j_2__ < SigmaKnots_pred_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < SigmaKnots_pred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SigmaKnots_pred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t SigmaOffDiag_pred_j_1_max__ = n_knots;
        for (size_t j_1__ = 0; j_1__ < SigmaOffDiag_pred_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "SigmaOffDiag_pred" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "j";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t devs_j_2_max__ = ((N - 1) * est_rw);
        size_t devs_j_1_max__ = (K * est_rw);
        for (size_t j_2__ = 0; j_2__ < devs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < devs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "devs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t x0_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < x0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "x0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_1_max__ = (nZ * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zpos_j_1_max__ = (K * (1 - proportional_model));
        for (size_t j_1__ = 0; j_1__ < zpos_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zpos" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t p_z_j_1_max__ = (K - 1);
        size_t p_z_k_0_max__ = (P * proportional_model);
        for (size_t j_1__ = 0; j_1__ < p_z_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < p_z_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p_z" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t spline_a_j_2_max__ = (n_knots * est_spline);
        size_t spline_a_j_1_max__ = (K * est_spline);
        for (size_t j_2__ = 0; j_2__ < spline_a_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < spline_a_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spline_a" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_obs_j_2_max__ = P;
        size_t b_obs_j_1_max__ = n_obs_covar;
        for (size_t j_2__ = 0; j_2__ < b_obs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_obs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_obs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_pro_j_2_max__ = K;
        size_t b_pro_j_1_max__ = n_pro_covar;
        for (size_t j_2__ = 0; j_2__ < b_pro_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < b_pro_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_pro" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sigma_k_0_max__ = (nVariances * est_sigma_params);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_a_k_0_max__ = (nVariances * est_gamma_params);
        for (size_t k_0__ = 0; k_0__ < gamma_a_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_a" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nb2_phi_k_0_max__ = (nVariances * est_nb2_params);
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nb2_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_k_0_max__ = estimate_nu;
        for (size_t k_0__ = 0; k_0__ < nu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ymiss_k_0_max__ = n_na;
        for (size_t k_0__ = 0; k_0__ < ymiss_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ymiss" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_k_0_max__ = (est_phi * K);
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_k_0_max__ = (est_theta * K);
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gp_theta_k_0_max__ = (est_gp * K);
        for (size_t k_0__ = 0; k_0__ < gp_theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gp_theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Lcorr_j_1_max__ = ((n_pcor * (n_pcor - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < Lcorr_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Lcorr" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_process_k_0_max__ = (est_sigma_process * n_sigma_process);
        for (size_t k_0__ = 0; k_0__ < sigma_process_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_process" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t effectsKnots_j_1_max__ = (n_knots * est_gp);
        size_t effectsKnots_k_0_max__ = (K * est_gp);
        for (size_t j_1__ = 0; j_1__ < effectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < effectsKnots_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "effectsKnots" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t pred_j_2_max__ = N;
            size_t pred_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < pred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < pred_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "pred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Z_j_2_max__ = K;
            size_t Z_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t yall_j_2_max__ = N;
            size_t yall_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < yall_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < yall_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "yall" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_vec_j_1_max__ = (P * est_sigma_params);
            for (size_t j_1__ = 0; j_1__ < sigma_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_a_vec_j_1_max__ = (P * est_gamma_params);
            for (size_t j_1__ = 0; j_1__ < gamma_a_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_a_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t nb_phi_vec_j_1_max__ = (P * est_nb2_params);
            for (size_t j_1__ = 0; j_1__ < nb_phi_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "nb_phi_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_vec_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < phi_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_vec_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < theta_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t x_j_2_max__ = N;
            size_t x_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < x_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "x" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t indicator_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < indicator_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "indicator" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t psi_root_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < psi_root_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "psi_root" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Sigma_derived_j_2_max__ = ((n_pcor * long_format) * est_cor);
            size_t Sigma_derived_j_1_max__ = ((n_pcor * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < Sigma_derived_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_derived_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma_derived" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Sigma_temp_j_2_max__ = (((n_pcor - 1) * long_format) * est_cor);
            size_t Sigma_temp_j_1_max__ = (((n_pcor - 1) * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < Sigma_temp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_temp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma_temp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma12_vec_j_2_max__ = 1;
            size_t sigma12_vec_j_1_max__ = (n_pcor - 1);
            for (size_t j_2__ = 0; j_2__ < sigma12_vec_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigma12_vec_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma12_vec" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t temp_sums_j_2_max__ = ((N * long_format) * est_cor);
            size_t temp_sums_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < temp_sums_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < temp_sums_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "temp_sums" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t temp_counts_j_2_max__ = ((N * long_format) * est_cor);
            size_t temp_counts_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_2__ = 0; j_2__ < temp_counts_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < temp_counts_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "temp_counts" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t cond_sigma_vec_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < cond_sigma_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cond_sigma_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t cond_mean_vec_j_1_max__ = ((P * long_format) * est_cor);
            for (size_t j_1__ = 0; j_1__ < cond_mean_vec_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cond_mean_vec" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma11";
            param_names__.push_back(param_name_stream__.str());
            size_t sigma_pro_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < sigma_pro_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_pro" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t spline_a_trans_j_2_max__ = (n_knots * est_spline);
            size_t spline_a_trans_j_1_max__ = (K * est_spline);
            for (size_t j_2__ = 0; j_2__ < spline_a_trans_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < spline_a_trans_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "spline_a_trans" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaKnots_j_2_max__ = n_knots;
            size_t SigmaKnots_j_1_max__ = n_knots;
            size_t SigmaKnots_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < SigmaKnots_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "SigmaKnots" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t obs_cov_offset_j_1_max__ = n_pos;
            for (size_t j_1__ = 0; j_1__ < obs_cov_offset_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "obs_cov_offset" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = n_loglik;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Omega_j_2_max__ = n_pcor;
        size_t Omega_j_1_max__ = n_pcor;
        for (size_t j_2__ = 0; j_2__ < Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Sigma_j_2_max__ = n_pcor;
        size_t Sigma_j_1_max__ = n_pcor;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t xstar_j_2_max__ = 1;
        size_t xstar_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < xstar_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < xstar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xstar" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t future_devs_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < future_devs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "future_devs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t SigmaKnots_pred_j_2_max__ = n_knots;
        size_t SigmaKnots_pred_j_1_max__ = n_knots;
        for (size_t j_2__ = 0; j_2__ < SigmaKnots_pred_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < SigmaKnots_pred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SigmaKnots_pred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t SigmaOffDiag_pred_j_1_max__ = n_knots;
        for (size_t j_1__ = 0; j_1__ < SigmaOffDiag_pred_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "SigmaOffDiag_pred" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "j";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_dfa_namespace::model_dfa stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
