% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicted.R
\name{predicted}
\alias{predicted}
\title{Calculate predicted value from DFA object}
\usage{
predicted(fitted_model)
}
\arguments{
\item{fitted_model}{Samples extracted (with \code{permuted = FALSE}) from a Stan
model. E.g. output from \code{\link[=invert_chains]{invert_chains()}}.}
}
\description{
Pass in \code{rstanfit} model object. Returns array of predictions, dimensioned
number of MCMC draws x number of MCMC chains x time series length x number of time series
}
\examples{
set.seed(42)
s <- sim_dfa(num_trends = 1, num_years = 20, num_ts = 3)
# only 1 chain and 1000 iterations used so example runs quickly:
m <- fit_dfa(y = s$y_sim, iter = 50, chains = 1)
pred <- predicted(m)

}
