% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bmrm.R
\name{plot.bmrm}
\alias{plot.bmrm}
\alias{plot}
\title{Produce plots of the parameter estimates}
\usage{
\method{plot}{bmrm}(x, type = "both", ...)
}
\arguments{
\item{x}{an object of class \code{bmrm}, the output of the function \code{bmrm}}

\item{type}{name of a variable (default="P").
It should be one of "P"(source composition or profile matrix P),
"A"(source contribution matrix A), "both" (both P and A), "Sigma" (error  variance).}

\item{...}{arguments to be passed to methods}
}
\value{
plot
}
\description{
Produce plots of the estimated
posterior mean and 95\% posterior intervals of A,P, Sigma
based on the MCMC samples in \code{bmrm}.
}
\details{
The following types of plots are drawn depending on the selected parameters:
\itemize{
\item P: bar plots of the posterior means with 95\% posterior intervals of elements for each row of P
\item A: time series plots of  posterior means with 95\% posterior intervals elements for each column of A
\item Sigma: posterior means with error bars for 95\% posterior intervals of elements of Sigma
 }
}
