% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim.R
\name{estim}
\alias{estim}
\alias{estim,OneStageBasket-method}
\alias{estim,TwoStageBasket-method}
\title{Posterior Mean and Mean Squared Error}
\usage{
estim(design, ...)

\S4method{estim}{OneStageBasket}(
  design,
  p1,
  n,
  lambda = NULL,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  ...
)

\S4method{estim}{TwoStageBasket}(
  design,
  p1,
  n,
  n1,
  lambda = NULL,
  interim_fun,
  interim_params = list(),
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{p1}{Probabilities under the alternative hypothesis. If
\code{length(p1) ==  1}, then this is a common probability for all
baskets.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}

\item{interim_fun}{Which type of interim analysis should be conducted
in case of a two-stage design.}

\item{interim_params}{A list of tuning parameters specific to
\code{interim_fun}.}
}
\value{
A list containing means of the posterior distributions and
the mean squared errors for all baskets.
}
\description{
Computes the posterior mean and the mean squared error of a basket trial
design.
}
\section{Methods (by class)}{
\itemize{
\item \code{estim(OneStageBasket)}: Posterior mean and mean squared error for a single-stage
basket design.

\item \code{estim(TwoStageBasket)}: Posterior mean and mean squared error for a two-stage
basket design.

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
estim(design = design, p1 = c(0.2, 0.2, 0.5), n = 15,
  weight_fun = weights_fujikawa)
}
