% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_DNA.R
\name{clean_DNA_file}
\alias{clean_DNA_file}
\title{Clean DNA file}
\usage{
clean_DNA_file(input_file, output_dir = "")
}
\arguments{
\item{input_file}{The name of the input multi FASTA file.}

\item{output_dir}{The directory where the output file will be saved. If not given,
the output file will be saved in the same directory as the input file.}
}
\value{
A character string specifying the path to the output FASTA file.
}
\description{
This function reads a multi FASTA file containing DNA sequences, removes any characters other
than A, T, G, and C, and writes the cleaned sequences to a new multi FASTA file. The output
file name is generated from the input file name with the suffix '_clean.fasta'.
}
\examples{
sample_file_path_three <- system.file("extdata", "sample2_fa.fasta", package = "baseq")
tempdir <- tempdir()
temp_file_path <- file.path(tempdir, basename(sample_file_path_three))
file.copy(sample_file_path_three, temp_file_path, overwrite = TRUE)
clean_DNA_file(temp_file_path, output_dir = tempdir)

# Write to working directory
# clean_DNA_file(file_path)

# Write to custom directory
# clean_DNA_file(file_path, output_dir = "/path/to/directory/")

}
