% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncaa_schedule_info.R
\name{ncaa_schedule_info}
\alias{ncaa_schedule_info}
\title{\strong{Get Schedule and Results for NCAA Baseball Teams}}
\usage{
ncaa_schedule_info(team_id = NULL, year = NULL, pbp_links = FALSE, ...)
}
\arguments{
\item{team_id}{The team's unique NCAA id.}

\item{year}{The season (i.e. use 2016 for the 2015-2016 season,
etc.)}

\item{pbp_links}{Logical parameter to run process for scraping play_by_play urls for each game}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
A data frame with the following fields: date, opponent,
result, score, innings (if more than regulation), and the url
for the game itself.\tabular{ll}{
   col_name \tab types \cr
   year \tab integer \cr
   season_id \tab integer \cr
   date \tab character \cr
   home_team \tab character \cr
   home_team_id \tab integer \cr
   home_team_conference \tab character \cr
   home_team_conference_id \tab integer \cr
   home_team_slug \tab character \cr
   home_team_division \tab integer \cr
   away_team \tab character \cr
   away_team_id \tab integer \cr
   away_team_conference \tab character \cr
   away_team_conference_id \tab integer \cr
   away_team_slug \tab character \cr
   away_team_division \tab integer \cr
   neutral_site \tab character \cr
   result \tab character \cr
   score \tab character \cr
   innings \tab character \cr
   slug \tab character \cr
   game_info_url \tab character \cr
   contest_id \tab integer \cr
}
}
\description{
\strong{Get Schedule and Results for NCAA Baseball Teams}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ try(ncaa_schedule_info(team_id = 736, year = 2019))
}\if{html}{\out{</div>}}
}
