% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-bso.R
\encoding{UTF-8}
\name{model.bso.apply}
\alias{model.bso.apply}
\title{Use BSO}
\arguments{
\item{...}{See \code{\link[=phenology]{phenology()}} for a detailled description of the function.}

\item{tmin, tmax}{Daily minimum/maximum air temperatures in °C.}

\item{sunrise, sunset}{Time of sunrise/sunset in minutes from midnight. Can
be created with \code{\link[=create_suntimes_rsts]{create_suntimes_rsts()}} or \code{\link[=create_suntimes_df]{create_suntimes_df()}}.}

\item{n}{number of individuals to simulate.}

\item{max_generations}{maximum number of generations to calculate.}
}
\value{
The function returns a BSO phenology. Look
\link[=analyse.phenology.bso]{here} to find out how it can be analysed.
}
\description{
This page describes the usage of BSO with \code{\link[=phenology]{phenology()}}.
The model-specific inputs are listed and its basic functionality is explained.
BSO was published by \insertCite{Jakoby2019;textual}{barrks} and
parametrized for \emph{Ips typographus} in Switzerland. Note that the onset and
the development submodel do not support the usage of a storage (except for
some precalculations).
}
\details{
In \code{barrks}, \code{\link[=phenology]{phenology()}} is used to apply a model. The following code
illustrates which inputs are required to apply BSO and which additional
parameters are available.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{bso_phenology("bso", ..., tmin, tmax, sunrise, sunset,
              n = 1e+09, max_generations = 4)

# calculate submodels separately
bso_phenology("bso", ..., .submodels = 'onset',
              tmin, tmax, sunrise, sunset, n = 1e+09)
bso_phenology("bso", ..., .submodels = 'diapause', tmin, tmax)
bso_phenology("bso", ..., .submodels = 'development',
              .onset, .diapause = NULL, .mortality = NULL,
              tmin, tmax, sunrise, sunset,
              max_generations = 4)
}\if{html}{\out{</div>}}
}
\section{Functioning of the BSO}{


In the following, the basic functioning of BSO is explained.
\itemize{
\item \strong{Onset}: The onset of swarming will start when the degree days of the mean temperature reach
a specific threshold and regeneration feeding of the individuals has finished (Look at
development for details).
\item \strong{Development}: The development of single individuals is simulated.
The simulation of each individual is realized by passing a multitude of
slots that are grouped in stages. The hourly probability for an individual
to enter the next slot depends on the current stage and the phloem temperature.
The hourly temperature is derived from the minimum and maximum temperatures using
a sine interpolition. The hourly phloem temperature is calculated using
Newton's Law of Cooling (see \insertCite{Tran2007;nobrackets}{barrks}).
\item \strong{Diapause}: Specific photoperiod-related dates define when the diapause is initiated
at the earliest and at the latest. In between these dates, the diapause is
initiated when the mean temperature falls below a specific threshold.
\item \strong{Mortality}: BSO does not have a mortality submodel implemented.
}

Look \link[=model.bso.customize]{here} to find out how the model parameters affect the actual calculations and which values are used by default.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=bso_phenology]{bso_phenology()}}, \code{\link{model.bso.customize}}

Other phenology applications: 
\code{\link{model.chapy.apply}},
\code{\link{model.joensson.apply}},
\code{\link{model.lange.apply}},
\code{\link{model.phenips.apply}},
\code{\link{model.phenips_clim.apply}},
\code{\link{model.rity.apply}}
}
\concept{phenology applications}
