% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdr.bama.R
\name{summary.fdr.bama}
\alias{summary.fdr.bama}
\title{Summarize objects of type "fdr.bama"}
\usage{
\method{summary}{fdr.bama}(
  object,
  rank = F,
  ci = c(0.025, 0.975),
  fdr = object$fdr,
  filter = T,
  ...
)
}
\arguments{
\item{object}{An object of class "bama".}

\item{rank}{Whether or not to rank the output by posterior inclusion
probability. Default is TRUE.}

\item{ci}{The credible interval to calculate. \code{ci} should be a length 2
numeric vector specifying the upper and lower bounds of the CI. By
default, \code{ci = c(0.025, .975)}.}

\item{fdr}{False discovery rate. By default, it is set to whatever the
\code{fdr} of \code{object} is. However, it can be changed to recalculate
the PIP cutoff threshold.}

\item{filter}{Whether or not to filter out mediators with PIP less than the
PIP threshold.}

\item{...}{Additional optional arguments to \code{summary}}
}
\value{
A data.frame with 4 elements. The beta.m estimates, the estimates'
\emph{credible} interval (which by default is 95\\%), and the posterior
inclusion probability (pip) of each 'beta.m'.
}
\description{
\code{summary.fdr.bama} summarizes the \code{beta.m} estimates from
\code{fdr.bama} and for each mediator generates an overall estimate,
credible interval, posterior inclusion probability (PIP), and PIP threshold
for significance controlling for the specified false discovery rate (FDR).
}
