% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.2pnob.R
\name{mcmc.2pnob}
\alias{mcmc.2pnob}
\title{MCMC Estimation of the Two-Parameter Normal Ogive Model}
\usage{
mcmc.2pnob(data, initial.value = NULL, iter = 1000,
           burning = 500, thin = 1, parts = 3, ...)
}
\arguments{
\item{data}{Data frame with dichotomous item responses.}

\item{initial.value}{List with initial values}

\item{iter}{Total number of iterations.}

\item{burning}{Number of burnin iterations.}

\item{thin}{The thinning interval between consecutive observations.}

\item{parts}{Number of splits for MCMC chain.}

\item{...}{Further arguments.}
}
\value{
An object of class \emph{mcmc.2pnob}. This is a list with the following
elements:
  \item{mcmcobj}{A list with the \emph{a}, \emph{b}, y \emph{theta} chains.}
  \item{diagnostic}{A list with the \emph{diag} matrix (it is a summary whit
  Rhat included) and the residual \emph{deviance}.}
  \item{information}{A list with the \emph{final.values} (values of the last
  iteration for each chain), and the arguments \emph{iter}, \emph{burning},
  \emph{data}, \emph{thin}, \emph{parts} and \emph{model}, respectively.}
}
\description{
This function estimates the Two-Parameter normal ogive item response model
by MCMC sampling (Johnson & Albert, 1999, p. 195). It is a modification of
the function \emph{mcmc.2pno} of \emph{sirt} package.
}
\details{
For the two-parameter normal ogive item response model, we assume that the
\emph{i-th} individuals performance on a test depends on an unknown latent
variable \eqn{\theta_i} , and we let  \eqn{\theta_1, ...,\theta_n} denote
the latent traits for all \emph{n} individuals taking the test.

We assume that the probability that an individual answers a test item
correctly depends only on their latent trait value and characteristics of
the item. For the \emph{i-th} individual and \emph{j-th} item, we model this
probability as:

\deqn{Pr( Y_{ ij } = 1 | \theta_i, a_ j, b_ j ) =
\Phi( a_ j\theta_i - b_ j )},

where \eqn{\Phi} is the standard normal cdf, and \eqn{a_ j} and \eqn{b_ j}
are the item discrimination and item difficulty parameters associated with
the \emph{j-th} item (Johnson & Albert, 1999, p. 188).
}
\examples{
# data for model
data("MathTest")

# estimate model only for the first 500 examinees of the data MathTest
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 400, burning = 100)
# study of chains convergence
check.plot(model2)
diagnostic.mcmc(model2)
parameter.plot(model2)
chain.study(model2, parameter = "b", chain = 14)
irc(model2, item = 3)

\donttest{
# continue the  MCMC
# form 1
initialValues <- final.values.mcmc(model2)
model21 <- mcmc.2pnob(MathTest[1:500,], initial.value = initialValues,
iter = 3000, burning = 0)

# form 2
model22 <- continue.mcmc(model2, iter = 3000, burning = 0)
}

## End(Not run)

}
\references{
Johnson, V. E. & Albert, J. H. (1999). Ordinal Data Modeling.
New York: Springer.
}
\seealso{
\code{\link{mcmc.3pnob}}, \code{\link{continue.mcmc.bairt}},
\code{\link[coda]{gelman.diag}} and \code{\link[coda]{as.mcmc}}.
}
\author{
Javier Martínez

The code is adapted from an R script of Alexander Robitzsch.
(\url{https://github.com/alexanderrobitzsch/sirt/blob/master/R/mcmc.2pno.R})
}
