% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggr_compare.R
\name{plot.baggr_compare}
\alias{plot.baggr_compare}
\title{Plot method for baggr_compare models}
\usage{
\method{plot}{baggr_compare}(
  x,
  compare = x$compare,
  style = "areas",
  grid_models = FALSE,
  grid_parameters = TRUE,
  interval = 0.95,
  hyper = TRUE,
  transform = NULL,
  order = F,
  vline = FALSE,
  add_values = FALSE,
  values_digits = 2,
  values_size = 2,
  ...
)
}
\arguments{
\item{x}{baggr_compare model to plot}

\item{compare}{When plotting, choose between comparison of \code{"groups"}
(default), \code{"hyperpars"} (to omit group-specific estimates)
or (predicted) \code{"effects"}.
The \code{"groups"} option is not available when \code{what = "prior"}.}

\item{style}{What kind of plot to display (if \code{grid_models = TRUE}),
passed to the \code{style} argument in \link{baggr_plot}.}

\item{grid_models}{If \code{FALSE} (default), generate a single comparison plot;
if \code{TRUE}, display each model (using individual \link{baggr_plot}'s)
side-by-side.}

\item{grid_parameters}{if \code{TRUE}, uses \code{ggplot}-style facetting when plotting models
with many parameters (especially \code{"quantiles"}, \code{"sslab"});
if \code{FALSE}, returns separate plot for each parameter}

\item{interval}{probability level used for display of posterior interval}

\item{hyper}{Whether to plot pooled treatment effect
in addition to group treatment effects when \code{compare = "groups"}}

\item{transform}{a function (e.g. exp(), log())
to apply to the values of group (and hyper, if hyper=TRUE)
effects before plotting; when working with effects that are on
log scale, exponent transform is used automatically,
you can plot on log scale by setting transform = identity}

\item{order}{Whether to sort by median treatment effect by group.
If yes, medians from the model with largest range of estimates
are used for sorting.
If not, groups are shown alphabetically.}

\item{vline}{logical; show vertical line through 0 in the plot?}

\item{add_values}{logical; if TRUE, values will be printed next to the plot,
in a style that's similar to what is done for forest plots}

\item{values_digits}{number of significant digits to use when printing values,}

\item{values_size}{size of font for the values, if \code{add_values == TRUE}}

\item{...}{ignored for now, may be used in the future}
}
\description{
Allows plots that compare multiple baggr models
that were passed for comparison purposes to baggr compare or
run automatically by baggr_compare
}
