% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{unfit}
\alias{unfit}
\title{Unfit a Model}
\usage{
unfit(mod)
}
\arguments{
\item{mod}{A fitted object of class \code{"bage_mod"},
object, created through a call to \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}
}
\value{
An unfitted version of \code{mod}.
}
\description{
Reset a model, deleting all estimates.
}
\examples{
## create a model, which starts out unfitted
mod <- mod_pois(injuries ~ age + sex + year,
                data = nzl_injuries,
                exposure = popn)
is_fitted(mod)

## calling 'fit' produces a fitted version
mod <- fit(mod)
is_fitted(mod)

## calling 'unfit' resets the model
mod <- unfit(mod)
is_fitted(mod)
}
\seealso{
\itemize{
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} Specify a model
\item \code{\link[=set_seeds]{set_seeds()}} Reset random seeds
\item Functions such as \code{\link[=set_prior]{set_prior()}}, \code{\link[=set_disp]{set_disp()}} and
\code{\link[=set_var_age]{set_var_age()}} unfit models as side effects.
}
}
