% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_submit_container_state_change}
\alias{ecs_submit_container_state_change}
\title{Submit Container State Change}
\usage{
ecs_submit_container_state_change(
  cluster = NULL,
  task = NULL,
  containerName = NULL,
  runtimeId = NULL,
  status = NULL,
  exitCode = NULL,
  reason = NULL,
  networkBindings = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full ARN of the cluster that hosts the container.}

\item{task}{Character. The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.}

\item{containerName}{Character. The name of the container.}

\item{runtimeId}{Character. The ID of the Docker container.}

\item{status}{Character. The status of the state change request.}

\item{exitCode}{Integer. The exit code returned for the state change request.}

\item{reason}{Character. The reason for the state change request.}

\item{networkBindings}{List. The network bindings of the container.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Submit Container State Change
}
\section{cluster}{

The short name or full ARN of the cluster
that hosts the container.
}

\section{task}{

The task ID or full Amazon
Resource Name (ARN) of the task that hosts the
container.
}

\section{containerName}{

The name of the
container.
}

\section{runtimeId}{

The ID of the Docker
container.
}

\section{status}{

The status of the state change
request.
}

\section{exitCode}{

The exit code returned for the state change
request.
}

\section{reason}{

The reason for the state change
request.
}

\section{networkBindings}{

The network bindings of the
container.
}

