% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_placement_group}
\alias{ec2_create_placement_group}
\title{Create Placement Group}
\usage{
ec2_create_placement_group(
  DryRun = NULL,
  GroupName = NULL,
  Strategy = NULL,
  PartitionCount = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{GroupName}{Character.   A name for the placement group.[optional]}

\item{Strategy}{Character. The placement strategy.[optional]}

\item{PartitionCount}{Integer. The number of partitions. Valid only when \strong{Strategy} is set to \code{partition}.[optional]}

\item{TagSpecification}{List. The tags to apply to the new placement group.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Placement Group
}
\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{GroupName}{


A name for the placement group. Must be unique within the scope of your
account for the Region.

Constraints: Up to 255 ASCII characters
}

\section{Strategy}{

The placement strategy.
}

\section{PartitionCount}{

The
number of partitions. Valid only when \strong{Strategy} is set to
\code{partition}.
}

\section{TagSpecification}{

The tags to apply to the new placement
group.
}

