% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_unassign_private_ip_addresses}
\alias{ec2_unassign_private_ip_addresses}
\title{Unassign Private Ip Addresses}
\usage{
ec2_unassign_private_ip_addresses(
  NetworkInterfaceId,
  PrivateIpAddress,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfaceId}{String. The ID of the network interface.}

\item{PrivateIpAddress}{List. The secondary private IP addresses to unassign from the network interface.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Unassigns one or more secondary private
IP addresses from a network interface.
}
\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{PrivateIpAddress}{

The secondary private IP addresses to
unassign from the network interface. You can specify this option
multiple times to unassign more than one IP
address.
}

