% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_image_attribute}
\alias{ec2_modify_image_attribute}
\title{Modify Image Attribute}
\usage{
ec2_modify_image_attribute(
  ImageId,
  Attribute = NULL,
  Description = NULL,
  LaunchPermission = NULL,
  OperationType = NULL,
  ProductCode = NULL,
  UserGroup = NULL,
  UserId = NULL,
  Value = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ImageId}{String. The ID of the AMI.}

\item{Attribute}{String. The name of the attribute to modify.[optional]}

\item{Description}{Object. A new description for the AMI.[optional]}

\item{LaunchPermission}{Object. A new launch permission for the AMI.[optional]}

\item{OperationType}{String. The operation type.[optional]}

\item{ProductCode}{List. The DevPay product codes. After you add a product code to an AMI, it can\'t be removed.[optional]}

\item{UserGroup}{List. The user groups.[optional]}

\item{UserId}{List. The AWS account IDs.[optional]}

\item{Value}{String. The value of the attribute being modified.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Image Attribute
}
\section{ImageId}{

The ID of the
AMI.
}

\section{Attribute}{

The name of the attribute to modify. The valid
values are \code{description}, \code{launchPermission}, and
\code{productCodes}.
}

\section{Description}{

A new description for the
AMI.
}

\section{LaunchPermission}{

A new launch permission for the
AMI.
}

\section{OperationType}{

The operation type. This parameter can be used
only when the \code{Attribute} parameter is
\code{launchPermission}.
}

\section{ProductCode}{

The DevPay product codes. After
you add a product code to an AMI, it can\'t be
removed.
}

\section{UserGroup}{

The user groups. This parameter can be used
only when the \code{Attribute} parameter is
\code{launchPermission}.
}

\section{UserId}{

The AWS account IDs. This
parameter can be used only when the \code{Attribute} parameter is
\code{launchPermission}.
}

\section{Value}{

The value of the attribute being
modified. This parameter can be used only when the \code{Attribute} parameter
is \code{description} or \code{productCodes}.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

