% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_vpc_peering_connection}
\alias{ec2_delete_vpc_peering_connection}
\title{Delete Vpc Peering Connection}
\usage{
ec2_delete_vpc_peering_connection(
  VpcPeeringConnectionId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcPeeringConnectionId}{String. The ID of the VPC peering connection.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes a VPC peering connection. Either the owner
of the requester VPC or the owner of the accepter VPC can delete the VPC
peering connection if it\'s in the \code{active} state. The owner of the
requester VPC can delete a VPC peering connection in the
\code{pending-acceptance} state. You cannot delete a VPC peering connection
that\'s in the \code{failed} state.
}
\section{VpcPeeringConnectionId}{

The ID of the VPC peering
connection.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

