% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_vpc_endpoint_service_configurations}
\alias{ec2_delete_vpc_endpoint_service_configurations}
\title{Delete Vpc Endpoint Service Configurations}
\usage{
ec2_delete_vpc_endpoint_service_configurations(
  ServiceId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ServiceId}{List. The IDs of one or more services.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes one or more VPC endpoint
service configurations in your account. Before you delete the endpoint
service configuration, you must reject any \code{Available} or
\code{PendingAcceptance} interface endpoint connections that are attached to
the service.
}
\section{ServiceId}{

The IDs of one or more
services.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

