% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_advertise_byoip_cidr}
\alias{ec2_advertise_byoip_cidr}
\title{Advertise Byoip Cidr}
\usage{
ec2_advertise_byoip_cidr(Cidr, DryRun = NULL, simplify = TRUE, others = list())
}
\arguments{
\item{Cidr}{String. The address range, in CIDR notation.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Advertise Byoip Cidr
}
\section{Cidr}{

The address range, in CIDR notation. This
must be the exact range that you provisioned. You can\'t advertise only
a portion of the provisioned range.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

