% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AvoPhylo.R
\name{AvoPhylo}
\alias{AvoPhylo}
\title{AvoPhylo: Building phylogenies based on the AvoTrex extinct bird trait
database and BirdTree backbone}
\usage{
AvoPhylo(ctrees, avotrex, tax, PER = 0.2, PER_FIXED = 0.75, mindist =
  0.1, ord = FALSE, Ntree, n.cores = 1, cluster.ips = NULL)
}
\arguments{
\item{ctrees}{Either (i) object (of class multiPhylo) containing multiple
BirdTree phylogenies. Individual trees within the multiPhylo object must be
of class 'phylo', see the \code{ape} package. Or (ii) an individual tree
object of class 'phylo'.}

\item{avotrex}{The AvoTrex extinct species phylogeny database. This database
contains the information and commands required to graft the extinct species
on to the BirdTree trees. If edited, column names must remain unchanged.}

\item{tax}{The Jetz et al. (2012) BirdTree taxonomy .csv. Supplied as data
within the package.}

\item{PER}{Percentage/fraction for branch truncation based on random grafting
(see \code{\link{AvoBind}} for more details). Can be left at the default
value.}

\item{PER_FIXED}{Point along a branch (expressed as a fraction
of the branch length, rootward) to graft the species in the
phylogeny database (\code{avotrex} argument) which are set
to TRUE in the per_fixed column (to reduce very short branch
lengths) (see \code{\link{AvoBind}} for more details). Can
be left at the default value.}

\item{mindist}{When fixing the grafting of a given species at
a specific time point, but the provided grafting time point
is too old (i.e., older than the parent node) or too young
(i.e., younger than the child node) relative to the focal
branch, grafting will occur \code{mindist} below the parent
node or above the child node.}

\item{ord}{Should the trees within \code{ctrees} be kept in
order (TRUE) and all used (i.e., the output list of trees is
in the same order as \code{ctrees}) in the grafting, or
should trees be randomly sampled from \code{ctrees} (FALSE;
the default) prior to grafting. If \code{ord == TRUE},
\code{Ntree} must equal the length of \code{ctrees}. If only
a single tree is provided, this argument does nothing.}

\item{Ntree}{The number of trees to sample from the supplied
number of BirdTree trees (i.e., \code{ctrees}), if \code{ord
  == FALSE}. Value must be greater or equal to the number of
supplied trees (\code{length(ctrees))}. If \code{ord ==
  TRUE}, \code{Ntree} must equal the length of \code{ctrees}.}

\item{n.cores}{Number of cores used to build the phylogeny.
Default is one (will run with parallel processing)}

\item{cluster.ips}{Cluster location. Keep as default.}
}
\value{
The function returns an object of class
'multiAvophylo', which is a list consisting of N trees (each
of class 'avophylo' and 'phylo') that were randomly selected
from the supplied number. These trees have all had the
extinct species from AvoTrex grafted on. For more details on
the grafting, see: Sayol et al. (IN PREP).
}
\description{
Grafting extinct species onto BirdTree phylogenies using the AvoTrex database
}
\details{
Function to build phylogenies incorporating the extinct species from the
AvoTrex extinct birds database (Sayol et al.). AvoTrex provides data on
geographical location, island endemicity, volancy, body size and standard
external and skeleton morphological measurements for 605 extinct bird
species. The AvoPhylo function provides a pipeline to incorporate the extinct
species from AvoTrex into the "BirdTree" phylogenies of extant birds (Jetz et
al. 2012). Utilising codes assigned to each species based on their known
taxonomic affinities, the function binds each species in turn to a provided
BirdTree phylogeny. Input phylogenies (i.e., BirdTree trees) must be of class
'phylo', see \code{\link[ape]{phylo}}.

BirdTree phylogenies can be sourced from: https://birdtree.org/

The species are grafted onto the tree in a set order provided in the column
"Id_sps", as certain species need to be grafted onto the tree before other
species. Some species are assigned to groups within the data. These species
are assigned a code "xS" within the column "phylo_id2". These species groups
consist of close relatives, whose exact taxonomic relationships are unknown.
Therefore, the order in which they are joined is randomised. See Sayol et al.
and Matthews et al. for further details.

For a subset of species (primarily those in older clades), we
have constrained the grafting to take place at a specific time
point (value in the 'time_fixed' column) along a given branch,
rather than at a randomly selected point. If, due to the
topology of the underlying BirdTree tree, it is not possible
to undertake this grafting along a given branch (i.e., the
time point for grafting is either older than the parent node
or younger than the child node, in respect to a given focal
branch), we graft the species just below the parent node or
just above the child node (using a branch length set by
\code{mindist}).

As some of the codes (see table below) randomly place the
given species within a group of species, a genus, or a family,
and some species groups are randomised before grafting (see
above), it is useful to run the grafting procedure over a a
number of trees to average out the randomisation. Therefore,
the function can be run in parallel using the argument
\code{n.cores}. Note that the function will run on one core as
default and if only one tree is supplied. Trees for grafting
can be randomly selected from a number of input trees by
giving the function a group of input trees using the argument
\code{ctrees} and then defining a smaller number using
\code{Ntree}. If the maximum number of input trees is to be
used, \code{Ntree} should equal \code{length(ctrees)}. If you
want the outputted list of trees to match the order of trees
in \code{ctrees}, set \code{ord = TRUE}.

If \code{Ntree} > 1, a progress bar will be displayed.

A variety of different plotting options are available, see
the \code{\link{plot.avophylo}} documentation.\tabular{lll}{
   Codes \tab Full name \tab Definition \cr
   S \tab Sister \tab Grafted as a sister to a known extant or extinct species already in the tree \cr
   SSG \tab Sister species group \tab Grafted as a sister to a group of extant and/or extinct species already in the tree \cr
   SGG \tab Sister genus group \tab Grafted as a sister to an entire extant or extinct genus (i.e., for the first grafted representative of an extinct genus) \cr
   SGG2 \tab Sister genus group 2 \tab Grafted as sister to multiple genera. This was for when a species was sister to a subfamily or some other large specific clade \cr
   SFG \tab Sister family group \tab Grafted as a sister to an entire extant or extinct family already present in the  tree (i.e., for the first grafted representative of an extinct family) \cr
   SOG \tab Sister order group \tab Grafted as a sister to an entire order already present in the tree (i.e., for the first grafted representative of an extinct order) \cr
   RSG \tab Random species group \tab Grafted to a randomly selected species from a pre-defined group of species (i.e., from which is believed to have close affinities \cr
   RGG \tab Random genus group \tab Grafted to a randomly selected species from a given genus. For example, if an  extinct species was believed to be a finch derived from a European finch species, but the exact sister species is unknown. \cr
   RGG2 \tab Random genus group 2 \tab Grafted to a randomly selected species from a group of genera (e.g. when all that is known is that the species is from a specific subfamily). Currently not used in the database, but the relevant functionality has been kept in the R script, as it could be useful for future studies. \cr
   RFG \tab Random family group \tab Grafted to a randomly selected species from a given family \cr
   RSGG \tab Random sister genus group \tab Grafted as sister to a randomly selected genus from a pre-defined group of genera \cr
   RSGG2 \tab Random sister genus group 2 \tab Grafted as sister to a randomly selected genus from a pre-defined family \cr
}
}
\examples{
# data(BirdTree_trees)
# data(BirdTree_tax)
# data(AvotrexPhylo)
# trees <- AvoPhylo(ctrees = BirdTree_trees,
# avotrex = AvotrexPhylo, PER = 0.2, PER_FIXED = 0.75,
# mindist = 0.1, ord = FALSE, 
# tax = BirdTree_tax, Ntree = 1, n.cores = 1, cluster.ips = NULL)
# class(trees)
# trees[[1]]
# class(trees[[1]])

#See the plot.avophylo documentation for the different available
#plotting options.
}
\references{
Matthews et al. (IN REVIEW) The global loss of avian functional and phylogenetic diversity from extinctions in
the Holocene and Late Pleistocene

Sayol et al. (IN PREP) The global loss of avian functional and phylogenetic diversity
from extinctions in the Holocene and Late Pleistocene
}
