# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get the means/medians/variances of pillars of a 3d array
#'
#' For a 3-dimensional array \code{mat3d}, pillar \code{ij} is defined as
#' \code{mat3d[i, j, ]}. These functions compute the mean, median and variance of each
#' pillar.
#'
#' @param mat3d A 3-dimensional array.
#'
#' @return A matrix where element \code{i,j} is equal to \code{mean(mat3d[i, j, ])},
#' \code{median(mat3d[i, j, ])}, or \code{var(mat3d[i, j, ])}.
#'
#' @examples
#' m3 <- array(1:16, dim = c(2, 2, 4))
#' MeanPillars(m3)
#' MedianPillars(m3)
#' VarPillars(m3)
#'
#' @export
MeanPillars <- function(mat3d) {
    .Call('autothresholdr_MeanPillars', PACKAGE = 'autothresholdr', mat3d)
}

#' @rdname MeanPillars
#' @export
VarPillars <- function(mat3d) {
    .Call('autothresholdr_VarPillars', PACKAGE = 'autothresholdr', mat3d)
}

#' @rdname MeanPillars
#' @export
MedianPillars <- function(mat3d) {
    .Call('autothresholdr_MedianPillars', PACKAGE = 'autothresholdr', mat3d)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('autothresholdr_RcppExport_registerCCallable', PACKAGE = 'autothresholdr')
})
