% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/significanceTest.R
\name{significanceTest}
\alias{significanceTest}
\title{Significance tests for autologistic/automultinomial models}
\usage{
significanceTest(model)
}
\arguments{
\item{model}{a centered or uncentered autologistic fit}
}
\value{
a list of p-values and z-values
}
\description{
Performs two-sided hypothesis tests for each coefficient in a centered or uncentered
autologistic model. The tests use the asymptotic normality of pseudolikelihood estimates 
with the Godambe sandwich variance estimator. A test for the spatial correlation eta is also
performed.
}
\details{
For multinomial models, tests are performed for each row of the coefficient matrix, 
as each row corresponds to a single predictor. The matrix of eta coefficients is tested 
against the null hypothesis of no spatial correlation.
}
\examples{
#model=MPLE(...)
#significanceTest(model)
}

