% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parrows.R
\name{parrows}
\alias{parrows}
\title{Projected arrows function}
\usage{
parrows(x0, y0, x1 = x0, y1 = y0, proj, ...)
}
\arguments{
\item{x0, y0}{coordinates of points from which to draw.}

\item{x1, y1}{coordinates of points to which to draw}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{...}{Additional arguments passed to the 
\code{\link[graphics]{arrows}}}
}
\description{
\code{parrows} takes pairs of coordinates and draws arrows between 
them, possibly after projection.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used for 
projection.
}
\examples{
data(narccap)
# plot image using bonne projection (w/o grid lines)
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 40, paxes.args = list(grid = FALSE))
# load some data for larger U.S. cities
data(us.cities, package = "maps")
cityxy <- list(x = us.cities$long[1:5], y = us.cities$lat[1:5])
parrows(cityxy$x[1:4], cityxy$y[1:4], cityxy$x[2:5], cityxy$y[2:5], 
        proj = "bonne", col = "orange")
}
\seealso{
\code{\link[graphics]{arrows}}, 
  \code{\link[mapproj]{mapproject}}, 
  \code{\link[autoimage]{pimage}}
}

