% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impuni.R
\name{impuni}
\alias{impuni}
\title{High dimensional missing data imputation and performing the mediation analysis with Bayesian
       univariate cox proportional modeling.}
\usage{
impuni(m, n, Survdur, event, time, lcr = NULL, t, i, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{Survdur}{"Column/Variable name" consisting duration of survival.}

\item{event}{"Column/Variable name" consisting survival event.}

\item{time}{"Column/Variable name" consisting time of repeated observations.}

\item{lcr}{"Leftcensoring information"}

\item{t}{A numeric threshold value between 0 to 1.}

\item{i}{Number of MCMC iteration to perform in obtaining posterior estimates of HR by CoxPH.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws for the iterations.}

\item{data}{High dimensional data containing survival observations with multiple covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information the function
performs imputations using missForest function and filters significant variables,
allowing the user to do univariate survival analysis with higher number of iterations. Further, it performs mediation
analysis among the significant variables and provides handful variables with their alpha.a values
which are mediator model exposure coefficients and beta.a coefficients.
}
\examples{
\dontrun{
##
impuni(m=8,n=25,Survdur="os",event="death",lcr=,t=0.02,i=6,b=10,d=10,data=hnscc)
##
}
}
