% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{predict_glmmLasso}
\alias{predict_glmmLasso}
\title{Predicts on newdata from glmmLasso objects}
\usage{
predict_glmmLasso(census, m, L1.x, lasso.L2.x, L2.unit, L2.reg)
}
\arguments{
\item{census}{Census data. A \code{data.frame} whose column names include
\code{L1.x}, \code{L2.x}, \code{L2.unit}, if specified, \code{L2.reg} and
\code{pcs}, and either \code{bin.proportion} or \code{bin.size}.}

\item{m}{A \code{glmmLasso()} object.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{lasso.L2.x}{Lasso context-level covariates. A character vector
containing the column names of the context-level variables in
\code{survey} and \code{census} to be used by the lasso classifier. If
\code{NULL} and \code{lasso} is set to \code{TRUE}, then lasso uses the
variables specified in \code{L2.x}. Default is \code{NULL}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column
name of the geographic unit in \code{survey} and \code{census} at which
outcomes should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}
}
\value{
Returns a numeric vector of predictions from a \code{glmmLasso()}
  object.
}
\description{
\code{glmmLasso()} predicts on newdata objects from a glmmLasso object.
}
