% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_TIRT_model.R
\name{fit_TIRT_model}
\alias{fit_TIRT_model}
\title{Fit the Thurstonian IRT Model with Long Format Response Data}
\usage{
fit_TIRT_model(
  data_TIRT,
  method = "lavaan",
  lavaan_estimator = "WLSMV",
  stan_cores = 4,
  chains = 4,
  iter = 2000,
  verbose = TRUE,
  remove_mplus_file = FALSE,
  export_estimates = TRUE,
  file_name
)
}
\arguments{
\item{data_TIRT}{Long format TIRT response data as generated from \code{get_TIRT_long_data()} or \code{thurstonianIRT::make_TIRT_data()}.}

\item{method}{Estimation method for the TIRT model. Can be \code{"lavaan"}, \code{"mplus"} or \code{"stan"}.}

\item{lavaan_estimator}{Which estimator to use when lavaan is chosen as the method of estimating the TIRT model. Defaults to "WLSMV".}

\item{stan_cores, chains, verbose, iter}{Parameters used in \code{thurstonianIRT::fit_TIRT_stan}}

\item{remove_mplus_file}{Whether the input/output files will be removed after model estimation, when Mplus is chosen as the method of estimating the TIRT model.}

\item{export_estimates}{Logical. Should trait estimates be written to external files?}

\item{file_name}{If \code{export_estimates == TRUE}, specify the file name for the output file.}
}
\value{
A list containing:
\itemize{
  \code{final_estimates}   Final trait score and standard error estimates

  \code{fit_object}   TIRT model fit object

  \code{responses_TIRT}   The long format TIRT response

  \code{long_estimates}   Final trait score and standard error estimates, in long format

}
}
\description{
Fits the Thurstonian IRT response model using either lavaan, Mplus, or stan methods. 
A long format response data set needs to be provided.
}
\details{
This function incorporates the fit TIRT models functions in the \code{thurstonianIRT} package (Bürkner, 2019) and
by (a) providing a wrapper interface for users to choose from estimating from lavaan, MPLUS, or stan, (b) placing
the fit object, resulting trait estimates, and the original long format response data into one list as the return object.
Users need to provide a long format TIRT response data set as generated from \code{get_TIRT_long_data()} or from \code{thurstonianIRT::make_TIRT_data()},
and they can choose from three estimation methods: lavaan, MPLUS or stan. For lavaan and stan, additional arguments can be specified.

We note that currently the lavaan method does not provide standard error estimates. The stan method is the most stable
but can take a very long time for estimation. The mplus method can be a good choice but may occassionally produce errors
due to model convergence issues. In these rare cases, users may also consider using the Excel macro
developed by Brown & Maydeu-Olivares (2012) to generate Mplus syntax and directly run the syntax in Mplus.
}
\examples{
set.seed(2024)
test_data <- triplet_example_data[1:20,]
block_info <- triplet_block_info
test_data_long <- get_TIRT_long_data(block_info = triplet_block_info, response_data = test_data,
                                     response_varname = build_TIRT_var_names(N_blocks = 5, 
                                     block_size = 3, item_name = "i"),
                                     block_name = "Block", item_name = "ID", 
                                     trait_name = "Factor", sign_name = "Keying")
\dontrun{
    test_fit <- fit_TIRT_model(test_data_long, method = "lavaan")
    test_fit$fit_object
    test_fit$final_estimates
}

}
\references{
Bürkner, P. C. (2019). thurstonianIRT: Thurstonian IRT models in R. \emph{Journal of Open Source Software, 4}(42), 1662. https://doi.org/10.21105/joss.01662

Brown, A., & Maydeu-Olivares, A. (2012). Fitting a Thurstonian IRT model to forced-choice data using Mplus. \emph{Behavior Research Methods, 44}, 1135-1147. https://doi.org/10.3758/s13428-012-0217-x
}
\seealso{
\code{thurstonianIRT::fit_TIRT_lavaan},
   
   \code{thurstonianIRT::fit_TIRT_mplus}, 
   
   \code{thurstonianIRT::fit_TIRT_stan}
}
\author{
Mengtong Li
}
