% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_authors.R
\name{parse_authors}
\alias{parse_authors}
\title{Parse the \code{Author} field from a DESCRIPTION file}
\usage{
parse_authors(author_string)
}
\arguments{
\item{author_string}{A character containing the \code{Author} or \code{Maintainer}
field from a  \code{DESCRIPTION} file}
}
\value{
A character vector, or a list of character vectors of length equals
to the length of \code{author_string}
}
\description{
Parse the \code{Author} field from a DESCRIPTION file into a \code{person} object
}
\examples{
# Read from a DESCRIPTION file directly
utils_description <- system.file("DESCRIPTION", package = "utils")
utils_authors <- read.dcf(utils_description, "Author")

parse_authors(utils_authors)

# Read from a database of CRAN metadata
cran_epidemiology_packages$Author |>
  parse_authors() |>
  unlist() |>
  unique() |>
  sort()

}
