% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logout.R
\name{logoutButton}
\alias{logoutButton}
\title{Create a button to log out}
\usage{
logoutButton(label = "Log out", ..., id = "._auth0logout_")
}
\arguments{
\item{label}{The label on the button.}

\item{...}{Named attributes to apply to the button.}

\item{id}{An ID for the button. If you only have one logout button in
your app, you do not need to explicitly provide an ID. If you have more than
one logout button, you need to provide a unique ID to each button. When you
create a button with a non-default ID, you must create an observer that
listens to a click on this button and logs out of the app with a call to
\code{\link[auth0]{logout}}.}
}
\description{
A \code{logoutButton} is an \code{\link[shiny]{actionButton}} that is meant
to be used to log out of an auth0 Shiny app.
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    logoutButton(),
    logoutButton(label = "Another logout button", id = "logout2")
  )
  server <- function(input, output, session) {
    observeEvent(input$logout2, {
      logout()
    })
  }
  shinyAuth0App(ui, server)
}

}
\seealso{
\code{\link[auth0]{logout}},
\code{\link[auth0]{logout_url}}
}
