% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pfa.R
\name{read_pfa}
\alias{read_pfa}
\title{read_pfa}
\usage{
read_pfa(x)
}
\arguments{
\item{x}{A string, file or url connection}
}
\value{
a \code{list} of lists structure in which null -> NULL, true -> TRUE, 
false -> FALSE, numbers -> numeric, strings -> character, array -> list, 
object -> named list
}
\description{
Convert a JSON string in memory or a JSON file on disk into a list-of-lists structure.
}
\examples{
# literal JSON string  (useful for small examples)
toy_model <- read_pfa('{"input":"double","output":"double","action":[{"+":["input",10]}]}')

# from a local path, must be wrapped in "file" command to create a connection
local_model <- read_pfa(file(system.file("extdata", "my-model.pfa", package = "aurelius")))

# from a url (split on two lines so not to exceed 100 char wide during install)
url_model <- read_pfa(url(paste0('https://raw.githubusercontent.com/ReportMort/hadrian', 
                     '/feature/add-r-package-structure/aurelius/inst/extdata/my-model.pfa')))
}
