% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-complete.r
\name{auk_complete}
\alias{auk_complete}
\title{Filter out incomplete checklists from the eBird data}
\usage{
auk_complete(x)
}
\arguments{
\item{x}{\code{auk_ebd} object; reference to basic dataset file created by \code{\link[=auk_ebd]{auk_ebd()}}.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) to only keep complete
checklists, i.e. those for which all birds seen or heard were recorded. These
checklists are the most valuable for scientific uses since they provide
presence and absence data.This function only defines the filter and, once all
filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and
perform the filtering.
}
\examples{
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_complete()
}
