% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_rroc.R
\name{score_rroc}
\alias{score_rroc}
\alias{scoreRROC}
\title{Area Over the Curve for RROC Curves}
\usage{
score_rroc(object, data = NULL, y = NULL, ...)

scoreRROC(object)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function
\code{\link[DALEX]{explain}} from the DALEX package.}

\item{data}{New data that will be used to calculate the score.
Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{y}{New y parameter will be used to calculate score.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
The area over the Regression Receiver Operating Characteristic.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_rroc(lm_audit)


}
\references{
Hernández-Orallo, José. 2013. "ROC Curves for Regression". Pattern Recognition 46 (12): 3395–3411.
}
\seealso{
\code{\link{plot_rroc}}
}
