% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_acf.R
\name{plotD3_acf}
\alias{plotD3_acf}
\alias{plotD3ACF}
\title{Plot Autocorrelation Function in D3 with r2d3 package.}
\usage{
plotD3_acf(object, ..., variable = NULL, alpha = 0.95, scale_plot = FALSE)

plotD3ACF(object, ..., variable = NULL, alpha = 0.95, scale_plot = FALSE)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the data on the plot will be ordered by predicted response.
If \code{variable = NULL}, unordered observations are presented.}

\item{alpha}{Confidence level of the interval.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}
}
\value{
a `r2d3` object.
}
\description{
Plot Autocorrelation Function of models' residuals.
}
\examples{

dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plotD3_acf(mr_lm)

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
rf_audit <- audit(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(rf_audit)
plotD3_acf(mr_lm, mr_rf)

}
