% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_residual.R
\name{model_residual}
\alias{model_residual}
\alias{modelResiduals}
\title{Create Model Residuals Explaination}
\usage{
model_residual(object)

modelResiduals(object)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\description{
Creates 'auditor_model_residual' that contains sorted residuals.
 An object can be further used to generate plots.
For the list of possible plots see see also section.
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data = titanic, y = titanic$survived)

# validate a model with auditor
library(auditor)
model_residual(exp_glm)

}
\seealso{
\code{\link{plot_acf}, \link{plot_autocorrelation}, \link{plot_residual}, \link{plot_residual_boxplot},
\link{plot_pca}, \link{plot_correlation}, \link{plot_prediction}, \link{plot_rec}, \link{plot_residual_density},
\link{plot_residual}, \link{plot_rroc}, \link{plot_scalelocation}, \link{plot_tsecdf}}
}
