% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResidualDensity.R
\name{plotResidualDensity}
\alias{plotResidualDensity}
\title{Residual Density Plot}
\usage{
plotResidualDensity(object, ..., variable = NULL)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{variable}{A variable name. Residuals will be plotted separately for different values of variable. or continuous variables, they will be separated by a median.}
}
\value{
ggplot object
}
\description{
Density of model residuals.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotResidualDensity(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotResidualDensity(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
