% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPrediction.R
\name{plotPrediction}
\alias{plotPrediction}
\title{Predicted response vs Observed or Variable Values}
\usage{
plotPrediction(object, ..., variable = "Observed response")
}
\arguments{
\item{object}{An object of class modelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{variable}{Name of model variable to order residuals. If value is NULL data order is taken. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}
}
\description{
Plot of predicted response vs observed or variable Values.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotPrediction(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotPrediction(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
