% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_to_description.R
\name{att_amend_desc}
\alias{att_amend_desc}
\alias{att_to_desc_from_pkg}
\title{Amend DESCRIPTION with dependencies read from package code parsing}
\usage{
att_amend_desc(
  path = ".",
  path.n = "NAMESPACE",
  path.d = "DESCRIPTION",
  dir.r = "R",
  dir.v = "vignettes",
  dir.t = "tests",
  extra.suggests = NULL,
  pkg_ignore = NULL,
  document = TRUE,
  normalize = TRUE,
  inside_rmd = FALSE,
  must.exist = TRUE
)

att_to_desc_from_pkg(
  path = ".",
  path.n = "NAMESPACE",
  path.d = "DESCRIPTION",
  dir.r = "R",
  dir.v = "vignettes",
  dir.t = "tests",
  extra.suggests = NULL,
  pkg_ignore = NULL,
  document = TRUE,
  normalize = TRUE,
  inside_rmd = FALSE,
  must.exist = TRUE
)
}
\arguments{
\item{path}{path to the root of the package directory. Default to current directory.}

\item{path.n}{path to namespace file.}

\item{path.d}{path to description file.}

\item{dir.r}{path to directory with R scripts.}

\item{dir.v}{path to vignettes directory. Set to empty (dir.v = "") to ignore.}

\item{dir.t}{path to tests directory. Set to empty (dir.t = "") to ignore.}

\item{extra.suggests}{vector of other packages that should be added in Suggests (pkgdown, covr for instance)}

\item{pkg_ignore}{vector of packages names to ignore.}

\item{document}{Run function roxygenise of roxygen2 package}

\item{normalize}{Logical. Whether to normalize the DESCRIPTION file. See \code{\link[desc:desc_normalize]{desc::desc_normalize()}}}

\item{inside_rmd}{Logical. Whether function is run inside a Rmd,
in case this must be executed in an external R session}

\item{must.exist}{Logical. If TRUE then an error is given if packages do not exist
within installed packages. If NA, a warning.}
}
\value{
Update DESCRIPTION file.
}
\description{
Amend package DESCRIPTION file with the list of dependencies extracted from
R, tests, vignettes files.
att_to_desc_from_pkg() is an alias of att_amend_desc(),
for the correspondence with \code{\link[=att_to_desc_from_is]{att_to_desc_from_is()}}.
}
\examples{
tmpdir <- tempdir()
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)
att_amend_desc(path = dummypackage)
}
