% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_logical_vector}
\alias{assert_logical_vector}
\title{Assert input is an atomic logical vector}
\usage{
assert_logical_vector(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if x is not an atomic logical vector}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if x is an atomic logical vector, otherwise aborts with the error message specified by msg
}
\description{
Assert input is an atomic logical vector
}
\examples{
try({
assert_logical_vector(c(TRUE, TRUE, TRUE)) # Passes
assert_logical_vector("a") # Throws default error
assert_logical_vector(c(1, 0, 1), "Custom error message") # Throws custom error
})


}
\concept{assert_type}
