% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asm.R
\name{plot.asm}
\alias{plot.asm}
\title{Generate diagnostic plots for an \code{asm} regression model}
\usage{
\method{plot}{asm}(
  x,
  which = c(1, 2, 3),
  caption = list("Residuals vs fitted", "Convex loss function",
    "Antitonic score function"),
  extend.ylim.f = 0.08,
  id.n = 3,
  labels.id = rownames(x$residuals),
  label.pos = c(4, 2),
  ext.xlim.f = 0.08,
  grid.length.f = 10,
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  ...
)
}
\arguments{
\item{x}{asm object}

\item{which}{a subset of the plots to be displayed}

\item{caption}{a list of captions for the plots}

\item{extend.ylim.f}{factor to extend the y-axis limits
for the residuals vs fitted plot}

\item{id.n}{number of residuals to label in the residuals vs fitted plot}

\item{labels.id}{labels for the residuals in the residuals vs fitted plot}

\item{label.pos}{position of the labels in the residuals vs fitted plot}

\item{ext.xlim.f}{factor to extend the x-axis limits for the convex loss
and antitonic score function plots}

\item{grid.length.f}{the number of grid points for the convex loss plot
is defined as grid.length.f * length(x$residuals)}

\item{ask}{logical; if TRUE, the user is asked before each plot}

\item{...}{additional arguments to ensure compatibility with the generic function plot()}
}
\value{
No return value
}
\description{
Generates plots of residuals vs fitted values, and the estimated convex loss
and antitonic score functions based on a fitted \code{asm} regression model
}
\examples{
model = asm(mpg ~ cyl + hp + disp, data=mtcars)
plot(model)

}
