% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.r
\name{completions_api}
\alias{completions_api}
\title{Request answer from openai's completions API}
\usage{
completions_api(
  prompt,
  model = NULL,
  temperature = NULL,
  max_tokens = NULL,
  api_key = NULL,
  ...
)
}
\arguments{
\item{prompt}{character string of the prompt to be completed.}

\item{model}{character string of the model to be used (defaults to
"text-davinci-003").}

\item{temperature}{numeric value between 0 and 1 to control the randomness of
the output (defaults to 0.2; lower values like 0.2 will make answers more
focused and deterministic).}

\item{max_tokens}{The maximum number of tokens to generate in the completion.
2048L is the maximum the models accept.}

\item{api_key}{set the API key. If NULL, looks for the env OPENAI_API_KEY.}

\item{...}{additional parameters to be passed to the API (see [the API
documentation](https://platform.openai.com/docs/api-reference/completions)}
}
\value{
a httr2 response object
}
\description{
Mostly used under the hood for \code{\link{askgpt}}.
}
\details{
Only a few parameters are implemented by name. Most can be sent
  through the \code{...}. For example, you could use the \code{n} parameter
  just like this \code{completions_api("The quick brown fox", n = 2)}.

  A couple of defaults are used by the package:
  \itemize{
     \item{the model used by default is "text-davinci-003"}
     \item{the default temperature is 0.2}
     \item{the default for max_tokens is 2048L}
  }

  You can configure how \code{\link{askgpt}} makes requests by setting
  options that start with \code{askgpt_*}. For example, to use a different
  model use \code{options(askgpt_model = "text-curie-001")}. It does not
  matter if the API parameter ist listed in the function or not. All are
  used.
}
\examples{
\dontrun{
completions_api("The quick brown fox")
}
}
