*-------------------------------------------------------------------------*
 |                                                                        |
 |             SPSS DATA DEFINITION STATEMENTS FOR ICPSR 7900             |
 |            MONITORING THE FUTURE (12TH-GRADE SURVEY), 1980             |
 |                          (PART 6:  CORE DATA)                          |
 |                           2ND ICPSR EDITION                            |
 |                               MAY, 2004                                |
 |                                                                        |
 | SPSS setup sections are provided for the LRECL version of this data    |
 | collection.  These sections are listed below:                          |
 |                                                                        |
 | DATA LIST:  assigns the name, type, decimal specification (if any),    |
 | and specifies the beginning and ending column locations for each       |
 | variable in the data file. Users must replace the "data-filename"      |
 | in the DATA LIST statement with a filename specifying the directory    |
 | on the user's computer system in which the downloaded and unzipped     |
 | data file is physically located (e.g., "c:\temp\da7900.p6").           |
 |                                                                        |
 | VARIABLE LABELS:  assigns descriptive labels to all variables.         |
 | Labels and variable names may be identical for some data files.        |
 |                                                                        |
 | MISSING VALUES: declares user-defined missing values. Not all          |
 | variables in this data set necessarily have user-defined missing       |
 | values. These values can be treated specially in data transformations, |
 | statistical calculations, and case selection.                          |
 |                                                                        |
 | VALUE LABELS: assigns descriptive labels to codes found in the data    |
 | file.  Not all codes necessarily have assigned value labels.           |
 |                                                                        |
 | NOTE:  Users should modify these data definition statements to suit    |
 | their specific needs. The MISSING VALUES section has been commented    |
 | out (i.e., '*').  To include the MISSING VALUES section in the final   |
 | SPSS setup, remove the comment indicators from the desired section.    |
 |                                                                        |
 | These data definition statements have been tested for compatibility    |
 | with SPSS Release 6.14 for UNIX and SPSS Release 11.0 for Windows.     |
 |                                                                        |
 | CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save  |
 | an SPSS data file for further analysis using SPSS for Windows, the     |
 | necessary "SAVE OUTFILE" command is provided in the last line of       |
 | this file.  To activate the command, users must delete the leading     |
 | asterisk (*) and replace "spss-filename" with a filename specifying    |
 | the location on the user's computer system to which the new data file  |
 | will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da7900.p6.sav").    |
*-------------------------------------------------------------------------.
                                                                           
* SPSS DATA LIST COMMAND.                                                  
                                                                           
DATA LIST FILE="data-filename" /                                           
   V1 1-2                   V3 3-3                   V4 4-8                
   V5 9-13 (4)              V13 14-14                V16 15-15             
   V17 16-16                V101 17-17               V102 18-18            
   V103 19-19               V104 20-20               V105 21-21            
   V106 22-22               V107 23-23               V108 24-24            
   V109 25-25               V110 26-26               V111 27-27            
   V112 28-28               V113 29-29               V114 30-30            
   V115 31-31               V116 32-32               V117 33-33            
   V118 34-34               V119 35-35               V120 36-36            
   V121 37-37               V122 38-38               V123 39-39            
   V124 40-40               V125 41-41               V126 42-42            
   V127 43-43               V128 44-44               V129 45-45            
   V130 46-46               V131 47-47               V132 48-48            
   V133 49-49               V134 50-50               V135 51-51            
   V136 52-52               V137 53-53               V138 54-54            
   V139 55-55               V140 56-56               V141 57-57            
   V142 58-58               V143 59-59               V144 60-60            
   V145 61-61               V146 62-62               V147 63-63            
   V148 64-64               V150 65-65               V151 66-66            
   V152 67-67               V153 68-68               V154 69-69            
   V155 70-70               V156 71-71               V157 72-72            
   V158 73-73               V159 74-74               V160 75-75            
   V161 76-76               V162 77-77               V163 78-78            
   V164 79-79               V165 80-80               V166 81-81            
   V167 82-82               V168 83-84               V169 85-85            
   V170 86-86               V171 87-87               V172 88-88            
   V173 89-89               V174 90-90               V175 91-91            
   V176 92-92               V177 93-93               V178 94-94            
   V179 95-95               V180 96-96               V181 97-97            
   V182 98-98               V183 99-99               V184 100-100          
   V185 101-101             V186 102-102             V187 103-103          
   V188 104-104             V189 105-105             V190 106-106          
   V191 107-107             V192 108-108             V193 109-109          
   V194 110-110             V195 111-111             V196 112-112          
   V197 113-113             V198 114-114             V199 115-115          
   V200 116-116             V201 117-117             V202 118-118          
   V203 119-119             V204 120-120             V205 121-121          
   V206 122-122             V207 123-123             V9001 124-127         
   V9002 128-128            V9003 129-129.                                 
                                                                           
                                                                           
* SPSS VARIABLE LABELS COMMAND.                                            
                                                                           
VARIABLE LABELS                                                            
   V1 '805    :YEAR OF ADMINST'                                            
   V3 '805    :FORM ID'                                                    
   V4 "805    :R'S ID-SERIAL #"                                            
   V5 '805    :SAMPLING WEIGHT'                                            
   V13 '805     :SCHL RGN-4 CAT'                                           
   V16 '805     :SELF-REP/NOT=0'                                           
   V17 '805     :SMSA/NON-SMSA=0'                                          
   V101 '805B01 :EVR SMK CIG,REGL'                                         
   V102 '805B02 :#CIGS SMKD/30DAY'                                         
   V103 '805B03 :EVER DRINK'                                               
   V104 '805B04A:#X DRNK/LIFETIME'                                         
   V105 '805B04B:#X DRNK/LAST12MO'                                         
   V106 '805B04C:#X DRNK/LAST30DA'                                         
   V107 '805B05 :#X DRK ENF FL HI'                                         
   V108 '805B06 :5+DRK ROW/LST 2W'                                         
   V109 '805    :DUMMY VARIABLE'                                           
   V110 '805    :DUMMY VARIABLE'                                           
   V111 '805    :DUMMY VARIABLE'                                           
   V112 '805    :DUMMY VARIABLE'                                           
   V113 '805    :DUMMY VARIABLE'                                           
   V114 '805    :DUMMY VARIABLE'                                           
   V115 '805B07A:#XMJ+HS/LIFETIME'                                         
   V116 '805B07B:#XMJ+HS/LAST12MO'                                         
   V117 '805B07C:#XMJ+HS/LAST30DA'                                         
   V118 '805B08A:#X LSD/LIFETIME'                                          
   V119 '805B08B:#X LSD/LAST 12MO'                                         
   V120 '805B08C:#X LSD/LAST 30DA'                                         
   V121 '805B09A:#X PSYD/LIFETIME'                                         
   V122 '805B09B:#X PSYD/LAST12MO'                                         
   V123 '805B09C:#X PSYD/LAST30DA'                                         
   V124 '805B10A:#X COKE/LIFETIME'                                         
   V125 '805B10B:#X COKE/LAST12MO'                                         
   V126 '805B10C:#X COKE/LAST30DA'                                         
   V127 '805B11A:#X AMPH/LIFETIME'                                         
   V128 '805B11B:#X AMPH/LAST12MO'                                         
   V129 '805B11C:#X AMPH/LAST30DA'                                         
   V130 '805B12A:#X QUAD/LIFETIME'                                         
   V131 '805B12B:#X QUAD/LAST12MO'                                         
   V132 '805B12C:#X QUAD/LAST30DA'                                         
   V133 '805B13A:#X BRBT/LIFETIME'                                         
   V134 '805B13B:#X BRBT/LAST12MO'                                         
   V135 '805B13C:#X BRBT/LAST30DA'                                         
   V136 '805B14A:#X TRQL/LIFETIME'                                         
   V137 '805B14B:#X TRQL/LAST12MO'                                         
   V138 '805B14C:#X TRQL/LAST30DA'                                         
   V139 "805B15A:#X 'H'/LIFETIME"                                          
   V140 "805B15B:#X 'H'/LAST 12MO"                                         
   V141 "805B15C:#X 'H'/LAST 30DA"                                         
   V142 '805B16A:#X NARC/LIFETIME'                                         
   V143 '805B16B:#X NARC/LAST12MO'                                         
   V144 '805B16C:#X NARC/LAST30DA'                                         
   V145 '805B17A:#X INHL/LIFETIME'                                         
   V146 '805B17B:#X INHL/LAST12MO'                                         
   V147 '805B17C:#X INHL/LAST30DA'                                         
   V148 "805C01 :R'S BIRTH YEAR"                                           
   V150 "805C03 :R'S SEX"                                                  
   V151 "805C04 :R'S RACE"                                                 
   V152 '805C05 :R SPD >TIM R-URB'                                         
   V153 '805C06 :R NOT MARRIED'                                            
   V154 "805C07A:R'S HSHLD ALONE"                                          
   V155 "805C07B:R'S HSHLD FATHER"                                         
   V156 "805C07C:R'S HSHLD MOTHER"                                         
   V157 "805C07D:R'S HSHLD BR/SR"                                          
   V158 "805C07E:R'S HSHLD GRPRNT"                                         
   V159 "805C07F:R'S HSHLD SPOUSE"                                         
   V160 "805C07G:R'S HSHLD CHLDRN"                                         
   V161 "805C07H:R'S HSHLD RELTVS"                                         
   V162 "805C07I:R'S HSHLD NONRLT"                                         
   V163 '805C08 :FATHR EDUC LEVEL'                                         
   V164 '805C09 :MOTHR EDUC LEVEL'                                         
   V165 '805C10 :MOTH PD JB R YNG'                                         
   V166 "805C11 :R'S POLTL PRFNC"                                          
   V167 "805C12 :R'POL BLF RADCL"                                          
   V168 "805C13A:R'S RELGS PRFNC"                                          
   V169 "805C13B:R'ATTND REL SVC"                                          
   V170 "805C13C:RLGN IMP R'S LF"                                          
   V171 '805C14 :WHEN R XPCT GRAD'                                         
   V172 "805C15 :R'S HS PROGRAM"                                           
   V173 '805C16 :RT SF SCH AB>AVG'                                         
   V174 '805C17 :RT SF INTELL>AVG'                                         
   V175 '805C18A:#DA/4W SC MS ILL'                                         
   V176 '805C18B:#DA/4W SC MS CUT'                                         
   V177 '805C18C:#DA/4W SC MS OTH'                                         
   V178 '805C19 :#DA/4W SKP CLASS'                                         
   V179 '805C20 :R HS GRADE/D=1'                                           
   V180 '805C21A:R WL DO VOC/TEC'                                          
   V181 '805C21B:R WL DO ARMD FC'                                          
   V182 '805C21C:R WL DO 2YR CLG'                                          
   V183 '805C21D:R WL DO 4YR CLG'                                          
   V184 '805C21E:R WL DO GRD/PRF'                                          
   V185 '805C22A:R WNTDO VOC/TEC'                                          
   V186 '805C22B:R WNTDO ARMD FC'                                          
   V187 '805C22C:R WNTDO 2YR CLG'                                          
   V188 '805C22D:R WNTDO 4YR CLG'                                          
   V189 '805C22E:R WNTDO GRD/PRF'                                          
   V190 '805C22F:R WNTDO NONE'                                             
   V191 '805C23 :HRS/W WRK SCHYR'                                          
   V192 '805C24A:R$/AVG WEEK JOB'                                          
   V193 '805C24B:R$/AVG WEEK OTH'                                          
   V194 '805C25 :#X/AV WK GO OUT'                                          
   V195 '805C26 :#X DATE 3+/WK'                                            
   V196 '805C27 :DRIVE>200 MI/WK'                                          
   V197 '805C28 :#X/12MO R TCKTD'                                          
   V198 '805C29A:#TCKTS AFT DRNK'                                          
   V199 '805C29B:#TCKTS AFT MARJ'                                          
   V200 '805C29C:#TCKTS AFT OTDG'                                          
   V201 '805C30 :#ACCIDNTS/12 MO'                                          
   V202 '805C31A:#ACDTS AFT DRNK'                                          
   V203 '805C31B:#ACDTS AFT MARJ'                                          
   V204 '805C31C:#ACDTS AFT OTDG'                                          
   V205 "805C32 :R'S BRANCH SERV"                                          
   V206 '805C33 :R XPCTS B OFFCR'                                          
   V207 '805C34 :R XPCTS MLTR CR'                                          
   V9001 'ICPSR STUDY NUMBER'                                              
   V9002 'ICPSR PART NUMBER'                                               
   V9003 'ICPSR DATA VERSION NO.' .                                        
                                                                           
                                                                           
* SPSS VALUE LABELS COMMAND.                                               
                                                                           
VALUE LABELS                                                               
 V1                                                                        
     80 '1980' /                                                           
 V13                                                                       
     1 'NE'                                                                
     2 'NC'                                                                
     3 'S'                                                                 
     4 'W' /                                                               
 V16                                                                       
     0 'NOT SELF-REPRESENTING'                                             
     1 'SELF-REPRESENTING' /                                               
 V17                                                                       
     0 'NON-SMSA'                                                          
     1 'SMSA' /                                                            
 V101                                                                      
     1 'NEVER'                                                             
     2 'ONCE OR TWICE'                                                     
     3 'OCCASIONALLY BUT NOT REGULARLY'                                    
     4 'REGULARLY IN THE PAST'                                             
     5 'REGULARLY NOW' /                                                   
 V102                                                                      
     1 'NOT AT ALL - INCL. (1) IN B01'                                     
     2 'LESS THAN 1 CIGARETTE PER DAY'                                     
     3 '1-5 CIGARETTES PER DAY'                                            
     4 'ABOUT 1/2 PACK PER DAY'                                            
     5 'ABOUT 1 PACK PER DAY'                                              
     6 'ABOUT 1 AND 1/2 PACKS PER DAY'                                     
     7 '2 PACKS OR MORE PER DAY' /                                         
 V103                                                                      
     1 'NO'                                                                
     2 'YES' /                                                             
 V104                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V105                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V106                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V107                                                                      
     1 'ON NONE OF THE OCCASIONS'                                          
     2 'ON FEW OF THE OCCASIONS'                                           
     3 'ON ABOUT HALF OF THE OCCASIONS'                                    
     4 'ON MOST OF THE OCCASIONS'                                          
     5 'ON NEARLY ALL OF THE OCCASIONS' /                                  
 V108                                                                      
     1 'NONE - INCL. (1) IN B03'                                           
     2 'ONCE'                                                              
     3 'TWICE'                                                             
     4 '3-5 TIMES'                                                         
     5 '6-9 TIMES'                                                         
     6 '10 OR MORE' /                                                      
 V115                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V116                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V117                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V118                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V119                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V120                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V121                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V122                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V123                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V124                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V125                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V126                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V127                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V128                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V129                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V130                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V131                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V132                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V133                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V134                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V135                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V136                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V137                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V138                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V139                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V140                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V141                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V142                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V143                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V144                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V145                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V146                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V147                                                                      
     1 '0 OCCASIONS'                                                       
     2 '1-2'                                                               
     3 '3-5'                                                               
     4 '6-9'                                                               
     5 '10-19'                                                             
     6 '20-39'                                                             
     7 '40 OR MORE' /                                                      
 V148                                                                      
     1 "BEFORE '60"                                                        
     2 '1960'                                                              
     3 '1961'                                                              
     4 '1962'                                                              
     5 '1963'                                                              
     6 '1964'                                                              
     7 '1965'                                                              
     8 'AFTER 1965' /                                                      
 V150                                                                      
     1 'MALE'                                                              
     2 'FEMALE' /                                                          
 V151                                                                      
     0 'WHITE'                                                             
     1 'NON-WHITE' /                                                       
 V152                                                                      
     1 'ON A FARM'                                                         
     2 'IN THE COUNTRY, NOT ON A FARM'                                     
     3 'IN A SMALL CITY OR TOWN (UNDER 50,000 PEOPLE)'                     
     4 'IN A MEDIUM-SIZED CITY (50,000 - 100,000)'                         
     5 'IN A SUBURB OF A MEDIUM-SIZED CITY'                                
     6 'IN A LARGE CITY (100,000 - 500,000)'                               
     7 'IN A SUBURB OF A LARGE CITY'                                       
     8 'IN A VERY LARGE CITY (OVER 500,000)'                               
     9 'IN A SUBURB OF A VERY LARGE CITY' /                                
 V153                                                                      
     1 'MARRIED'                                                           
     2 'ENGAGED'                                                           
     3 'SEPARATED/DIVORCED'                                                
     4 'SINGLE' /                                                          
 V154                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V155                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V156                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V157                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V158                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V159                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V160                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V161                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V162                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V163                                                                      
     1 'COMPLETED GRADE SCHOOL OR LESS'                                    
     2 'SOME HIGH SCHOOL'                                                  
     3 'COMPLETED HIGH SCHOOL'                                             
     4 'SOME COLLEGE'                                                      
     5 'COMPLETED COLLEGE'                                                 
     6 'GRADUATE OR PROFESSIONAL SCHOOL AFTER COLLEGE'                     
     7 'DON T KNOW, OR DOES NOT APPLY' /                                   
 V164                                                                      
     1 'COMPLETED GRADE SCHOOL OR LESS'                                    
     2 'SOME HIGH SCHOOL'                                                  
     3 'COMPLETED HIGH SCHOOL'                                             
     4 'SOME COLLEGE'                                                      
     5 'COMPLETED COLLEGE'                                                 
     6 'GRADUATE OR PROFESSIONAL SCHOOL AFTER COLLEGE'                     
     7 'DON T KNOW, OR DOES NOT APPLY' /                                   
 V165                                                                      
     1 'NO'                                                                
     2 'YES, SOME OF THE TIME WHEN I WAS GROWING UP'                       
     3 'YES, MOST OF THE TIME'                                             
     4 'YES, ALL OR NEARLY ALL OF THE TIME' /                              
 V166                                                                      
     1 'STRONGLY REPUBLICAN'                                               
     2 'MILDLY REPUBLICAN'                                                 
     3 'MILDLY DEMOCRAT'                                                   
     4 'STRONGLY DEMOCRAT'                                                 
     5 'AMERICAN INDEPENDENT PARTY'                                        
     6 'NO PREFERENCE, INDEPENDENT'                                        
     7 'OTHER'                                                             
     8 "DON'T KNOW, HAVEN'T DECIDED" /                                     
 V167                                                                      
     1 'VERY CONSERVATIVE'                                                 
     2 'CONSERVATIVE'                                                      
     3 'MODERATE'                                                          
     4 'LIBERAL'                                                           
     5 'VERY LIBERAL'                                                      
     6 'RADICAL'                                                           
     8 "NONE OF THE ABOVE, OR DON'T KNOW" /                                
 V168                                                                      
     1 'BAPTIST'                                                           
     2 'CHURCHES OF CHRIST'                                                
     3 'DISCIPLES OF CHRIST'                                               
     4 'EPISCOPAL'                                                         
     5 'LUTHERAN'                                                          
     6 'METHODIST'                                                         
     7 'PRESBYTERIAN'                                                      
     8 'UNITED CHURCH OF CHRIST'                                           
     9 'OTHER PROTESTANT'                                                  
     10 'UNITARIAN'                                                        
     11 'ROMAN CATHOLIC'                                                   
     12 'EASTERN ORTHODOX'                                                 
     13 'JEWISH'                                                           
     14 'OTHER RELIGION'                                                   
     15 'NONE' /                                                           
 V169                                                                      
     1 'NEVER'                                                             
     2 'RARELY'                                                            
     3 'ONCE OR TWICE A MONTH'                                             
     4 'ABOUT ONCE A WEEK OR MORE' /                                       
 V170                                                                      
     1 'NOT IMPORTANT'                                                     
     2 'A LITTLE IMPORTANT'                                                
     3 'PRETTY IMPORTANT'                                                  
     4 'VERY IMPORTANT' /                                                  
 V171                                                                      
     1 'BY THIS JUNE'                                                      
     2 'JULY TO JANUARY'                                                   
     3 'AFTER NEXT JANUARY'                                                
     6 "DON'T EXPECT TO GRADUATE" /                                        
 V172                                                                      
     1 'ACADEMIC OR COLLEGE PREP'                                          
     2 'GENERAL'                                                           
     3 'VOCATION, TECHNICAL, OR COMMERCIAL'                                
     4 "OTHER, OR DON'T KNOW" /                                            
 V173                                                                      
     1 'FAR BELOW AVERAGE'                                                 
     2 'BELOW AVERAGE'                                                     
     3 'SLIGHTLY BELOW AVERAGE'                                            
     4 'AVERAGE'                                                           
     5 'SLIGHTLY ABOVE AVERAGE'                                            
     6 'ABOVE AVERAGE'                                                     
     7 'FAR ABOVE AVERAGE' /                                               
 V174                                                                      
     1 'FAR BELOW AVERAGE'                                                 
     2 'BELOW AVERAGE'                                                     
     3 'SLIGHTLY BELOW AVERAGE'                                            
     4 'AVERAGE'                                                           
     5 'SLIGHTLY ABOVE AVERAGE'                                            
     6 'ABOVE AVERAGE'                                                     
     7 'FAR ABOVE AVERAGE' /                                               
 V175                                                                      
     1 'NONE'                                                              
     2 '1 DAY'                                                             
     3 '2 DAYS'                                                            
     4 '3 DAYS'                                                            
     5 '4-5 DAYS'                                                          
     6 '6-10 DAYS'                                                         
     7 '11 OR MORE' /                                                      
 V176                                                                      
     1 'NONE'                                                              
     2 '1 DAY'                                                             
     3 '2 DAYS'                                                            
     4 '3 DAYS'                                                            
     5 '4-5 DAYS'                                                          
     6 '6-10 DAYS'                                                         
     7 '11 OR MORE' /                                                      
 V177                                                                      
     1 'NONE'                                                              
     2 '1 DAY'                                                             
     3 '2 DAYS'                                                            
     4 '3 DAYS'                                                            
     5 '4-5 DAYS'                                                          
     6 '6-10 DAYS'                                                         
     7 '11 OR MORE' /                                                      
 V178                                                                      
     1 'NOT AT ALL'                                                        
     2 '1 OR 2 TIMES'                                                      
     3 '3-5 TIMES'                                                         
     4 '6-10 TIMES'                                                        
     5 '11-20 TIMES'                                                       
     6 'MORE THAN 20 TIMES' /                                              
 V179                                                                      
     1 'D  (69 OR BELOW)'                                                  
     2 'C- (70-72)'                                                        
     3 'C  (73-76)'                                                        
     4 'C+ (77-79)'                                                        
     5 'B- (80-82)'                                                        
     6 'B  (83-86)'                                                        
     7 'B+ (87-89)'                                                        
     8 'A- (90-92)'                                                        
     9 'A  (93-100)' /                                                     
 V180                                                                      
     1 "DEFINITELY WON'T"                                                  
     2 "PROBABLY WON'T"                                                    
     3 'PROBABLY WILL'                                                     
     4 'DEFINITELY WILL' /                                                 
 V181                                                                      
     1 "DEFINITELY WON'T"                                                  
     2 "PROBABLY WON'T"                                                    
     3 'PROBABLY WILL'                                                     
     4 'DEFINITELY WILL' /                                                 
 V182                                                                      
     1 "DEFINITELY WON'T"                                                  
     2 "PROBABLY WON'T"                                                    
     3 'PROBABLY WILL'                                                     
     4 'DEFINITELY WILL' /                                                 
 V183                                                                      
     1 "DEFINITELY WON'T"                                                  
     2 "PROBABLY WON'T"                                                    
     3 'PROBABLY WILL'                                                     
     4 'DEFINITELY WILL' /                                                 
 V184                                                                      
     1 "DEFINITELY WON'T"                                                  
     2 "PROBABLY WON'T"                                                    
     3 'PROBABLY WILL'                                                     
     4 'DEFINITELY WILL' /                                                 
 V185                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V186                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V187                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V188                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V189                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V190                                                                      
     0 'NO'                                                                
     1 'YES' /                                                             
 V191                                                                      
     1 'NONE'                                                              
     2 '5 OR LESS HOURS'                                                   
     3 '6 TO 10 HOURS'                                                     
     4 '11 TO 15 HOURS'                                                    
     5 '16 TO 20 HOURS'                                                    
     6 '21 TO 25 HOURS'                                                    
     7 '26 TO 30 HOURS'                                                    
     8 'MORE THAN 30 HOURS' /                                              
 V192                                                                      
     1 'NONE'                                                              
     2 '$1-5'                                                              
     3 '$6-10'                                                             
     4 '$11-20'                                                            
     5 '$21-35'                                                            
     6 '$36-50'                                                            
     7 '$51 +' /                                                           
 V193                                                                      
     1 'NONE'                                                              
     2 '$1-5'                                                              
     3 '$6-10'                                                             
     4 '$11-20'                                                            
     5 '$21-35'                                                            
     6 '$36-50'                                                            
     7 '$51 +' /                                                           
 V194                                                                      
     1 'LESS THAN ONE'                                                     
     2 'ONE'                                                               
     3 'TWO'                                                               
     4 'THREE'                                                             
     5 'FOUR OR FIVE'                                                      
     6 'SIX OR SEVEN' /                                                    
 V195                                                                      
     1 'NEVER'                                                             
     2 'ONCE A MONTH OR LESS'                                              
     3 '2 OR 3 TIMES A MONTH'                                              
     4 'ONCE A WEEK'                                                       
     5 '2 OR 3 TIMES A WEEK'                                               
     6 'OVER 3 TIMES A WEEK' /                                             
 V196                                                                      
     1 'NOT AT ALL'                                                        
     2 '1 TO 10 MILES'                                                     
     3 '11 TO 50 MILES'                                                    
     4 '51 TO 100 MILES'                                                   
     5 '100 TO 200 MILES'                                                  
     6 'MORE THAN 200 MILES' /                                             
 V197                                                                      
     0 'NONE'                                                              
     1 'ONCE'                                                              
     2 'TWICE'                                                             
     3 'THREE TIMES'                                                       
     4 'FOUR OR MORE TIMES' /                                              
 V198                                                                      
     0 'NONE'                                                              
     1 'ONE'                                                               
     2 'TWO'                                                               
     3 'THREE'                                                             
     4 'FOUR OR MORE' /                                                    
 V199                                                                      
     0 'NONE'                                                              
     1 'ONE'                                                               
     2 'TWO'                                                               
     3 'THREE'                                                             
     4 'FOUR OR MORE' /                                                    
 V200                                                                      
     0 'NONE'                                                              
     1 'ONE'                                                               
     2 'TWO'                                                               
     3 'THREE'                                                             
     4 'FOUR OR MORE' /                                                    
 V201                                                                      
     0 'NONE'                                                              
     1 'ONE'                                                               
     2 'TWO'                                                               
     3 'THREE'                                                             
     4 'FOUR OR MORE' /                                                    
 V202                                                                      
     0 'NONE'                                                              
     1 'ONE'                                                               
     2 'TWO'                                                               
     3 'THREE'                                                             
     4 'FOUR OR MORE' /                                                    
 V203                                                                      
     0 'NONE'                                                              
     1 'ONE'                                                               
     2 'TWO'                                                               
     3 'THREE'                                                             
     4 'FOUR OR MORE' /                                                    
 V204                                                                      
     0 'NONE'                                                              
     1 'ONE'                                                               
     2 'TWO'                                                               
     3 'THREE'                                                             
     4 'FOUR OR MORE' /                                                    
 V205                                                                      
     1 'ARMY'                                                              
     2 'NAVY'                                                              
     3 'MARINE CORPS'                                                      
     4 'AIR FORCE'                                                         
     5 'COAST GUARD'                                                       
     6 'UNCERTAIN' /                                                       
 V206                                                                      
     1 'NO'                                                                
     2 'UNCERTAIN'                                                         
     3 'YES' /                                                             
 V207                                                                      
     1 'NO'                                                                
     2 'UNCERTAIN'                                                         
     3 'YES' /                                                             
 V9001                                                                     
     7900 'ICPSR STUDY NUMBER' /                                           
 V9002                                                                     
     6 'PART 6: CORE QUESTIONNAIRE' / .                                    
                                                                           
* SPSS MISSING VALUES COMMAND.                                             
                                                                           
* MISSING VALUES                                                           
  V1 (99 THRU HI, 99)  V3 (9 THRU HI, 9)   V4 (99999 THRU HI, 99999)       
  V5 (9.999 THRU HI, 9.999)  V13 (9 THRU HI, 9)  V16 (9 THRU HI, 9)        
  V17 (9 THRU HI, 9)  V101 (9 THRU HI, 0)  V102 (9 THRU HI, 0)             
  V103 (9 THRU HI, 0)  V104 (9 THRU HI, 0)  V105 (9 THRU HI, 0)            
  V106 (9 THRU HI, 0)  V107 (8 THRU HI, 0)  V108 (8 THRU HI, 0)            
  V109 (9 THRU HI, 0)  V110 (9 THRU HI, 0)  V111 (9 THRU HI, 0)            
  V112 (9 THRU HI, 0)  V113 (8 THRU HI, 0)  V114 (8 THRU HI, 0)            
  V115 (9 THRU HI, 0)  V116 (9 THRU HI, 0)  V117 (9 THRU HI, 0)            
  V118 (9 THRU HI, 0)  V119 (9 THRU HI, 0)  V120 (9 THRU HI, 0)            
  V121 (9 THRU HI, 0)  V122 (9 THRU HI, 0)  V123 (9 THRU HI, 0)            
  V124 (9 THRU HI, 0)  V125 (9 THRU HI, 0)  V126 (9 THRU HI, 0)            
  V127 (9 THRU HI, 0)  V128 (9 THRU HI, 0)  V129 (9 THRU HI, 0)            
  V130 (9 THRU HI, 0)  V131 (9 THRU HI, 0)  V132 (9 THRU HI, 0)            
  V133 (9 THRU HI, 0)  V134 (9 THRU HI, 0)  V135 (9 THRU HI, 0)            
  V136 (9 THRU HI, 0)  V137 (9 THRU HI, 0)  V138 (9 THRU HI, 0)            
  V139 (9 THRU HI, 0)  V140 (9 THRU HI, 0)  V141 (9 THRU HI, 0)            
  V142 (9 THRU HI, 0)  V143 (9 THRU HI, 0)  V144 (9 THRU HI, 0)            
  V145 (9 THRU HI, 0)  V146 (9 THRU HI, 0)  V147 (9 THRU HI, 0)            
  V148 (9 THRU HI, 0)  V150 (9 THRU HI, 0)  V151 (9 THRU HI, 9)            
  V152 (0)                 V153 (9 THRU HI, 0)  V154 (8 THRU HI, 8)        
  V155 (8 THRU HI, 8)  V156 (8 THRU HI, 8)  V157 (8 THRU HI, 8)            
  V158 (8 THRU HI, 8)  V159 (8 THRU HI, 8)  V160 (8 THRU HI, 8)            
  V161 (8 THRU HI, 8)  V162 (8 THRU HI, 8)  V163 (7 THRU HI, 0)            
  V164 (7 THRU HI, 0)  V165 (9 THRU HI, 0)  V166 (8 THRU HI, 0)            
  V167 (8 THRU HI, 0)  V168 (99 THRU HI, 0)  V169 (9 THRU HI, 0)           
  V170 (9 THRU HI, 0)  V171 (9 THRU HI, 0)  V172 (9 THRU HI, 0)            
  V173 (9 THRU HI, 0)  V174 (9 THRU HI, 0)  V175 (9 THRU HI, 0)            
  V176 (9 THRU HI, 0)  V177 (9 THRU HI, 0)  V178 (9 THRU HI, 0)            
  V179 (0)                 V180 (9 THRU HI, 0)  V181 (9 THRU HI, 0)        
  V182 (9 THRU HI, 0)  V183 (9 THRU HI, 0)  V184 (9 THRU HI, 0)            
  V185 (8 THRU HI, 8)  V186 (8 THRU HI, 8)  V187 (8 THRU HI, 8)            
  V188 (8 THRU HI, 8)  V189 (8 THRU HI, 8)  V190 (8 THRU HI, 8)            
  V191 (9 THRU HI, 0)  V192 (9 THRU HI, 0)  V193 (9 THRU HI, 0)            
  V194 (9 THRU HI, 0)  V195 (9 THRU HI, 0)  V196 (9 THRU HI, 0)            
  V197 (7 THRU HI, 7)  V198 (7 THRU HI, 7)  V199 (7 THRU HI, 7)            
  V200 (7 THRU HI, 7)  V201 (7 THRU HI, 7)  V202 (7 THRU HI, 7)            
  V203 (7 THRU HI, 7)  V204 (7 THRU HI, 7)  V205 (8 THRU HI, 0)            
  V206 (8 THRU HI, 0)  V207 (8 THRU HI, 0)  V9001 (9998 THRU HI, 9999)     
  V9002 (8 THRU HI, 9)  V9003 (8 THRU HI, 9) .                             
                                                                           
EXECUTE.                                                                   
                                                                           
* Create SPSS system file.                                                 
                                                                           
*SAVE OUTFILE="spss-filename.sav".                                         
