/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class AprioriTFP_CARgen
extends AprioriTFPclass {
    protected final int MAX_NUM_CARS = 80000;
    protected int numCarsSoFar = 0;
    protected static double minimumSupAndConfValue = 0.01;
    protected static final double MAXIMUM_SUP_OR_CONF_VALUE = 99.9;
    protected static final double BEST_TO_AVAILABLE_RATIO = 0.6666666666666666;
    protected double minimumDiffSupport = 0.1;
    protected double minimumDiffConfidence = 1.0;
    protected HClocData[] locData = null;

    public AprioriTFP_CARgen(String[] stringArray) {
        super(stringArray);
    }

    public AprioriTFP_CARgen(AssocRuleMining assocRuleMining) {
        super(assocRuleMining);
    }

    public void startCARgeneration() {
        String string = "START CLASSIFICATION (BEST FIRST), TFPC CAR GENERATION WITH X-CHEKING\n---------------------------------------------------------------\nMax number of CARS  = 80000\nMax size antecedent = 6\n";
        this.startCARgeneration(string);
    }

    public void startCARgeneration(JTextArea jTextArea) {
        this.textArea = jTextArea;
        this.startCARgeneration();
    }

    protected void startCARgeneration(String string) {
        if (this.textArea == null) {
            System.out.print(string);
            this.outputLimits();
        } else {
            this.textArea.append(string);
            this.outputLimits(this.textArea);
        }
        this.startCARgeneration2();
        this.numberRulesInBinTree();
        if (this.outputRuleSetToFileFlag) {
            this.outputRulesToFile();
        }
    }

    protected void startCARgeneration2() {
        this.minSupport = (double)this.numRowsInTrainingSet * this.support / 100.0;
        String string = "Support = " + this.twoDecPlaces(this.support) + ", Confidence = " + this.twoDecPlaces(this.confidence) + "\nMinimum support = " + this.twoDecPlaces(this.minSupport) + " (Records)\n";
        if (this.textArea == null) {
            System.out.print(string);
            this.outputLimits();
        } else {
            this.textArea.append(string);
            this.outputLimits(this.textArea);
        }
        this.startRulelist = null;
        this.numCarsSoFar = 0;
        if (this.textArea == null) {
            this.createPtree();
            this.createTotalSupportTree();
        } else {
            this.createPtree(this.textArea);
            this.createTotalSupportTree(this.textArea);
        }
    }

    @Override
    public void commenceTCVwithOutput() {
        double[][] dArray = new double[10][4];
        System.out.println("START TCV APRIORI-TFP CAR GENERATION\n------------------------------------");
        System.out.println("Max number of CARS  = 80000");
        System.out.println("Max size antecedent = 6");
        for (int i = 0; i < 10; ++i) {
            String string = "[--- " + (i + 1) + " ---] ";
            if (this.textArea == null) {
                System.out.println(string);
            } else {
                this.textArea.append(string);
            }
            this.createTrainingAndTestDataSets(i);
            this.startCARgeneration();
            dArray[i][0] = this.numFrequentSets;
            dArray[i][1] = this.numUpdates;
            dArray[i][2] = this.calculateStorage();
            dArray[i][3] = this.getNumRules();
        }
        this.ouputTCVparam(dArray);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i][0];
            d2 += dArray[i][2];
            d3 += dArray[i][2];
            d4 += dArray[i][3];
        }
        this.averageNumFreqSets = d / 10.0;
        this.averageNumUpdates = d2 / 10.0;
        this.averageNumCRs = d4 / 10.0;
        this.outputTCVaverages(this.averageNumFreqSets, this.averageNumUpdates, this.averageNumCRs);
    }

    @Override
    public void commenceTCVwithOutput(JTextArea jTextArea) {
        this.textArea = jTextArea;
        this.commenceTCVwithOutput();
    }

    private void outputTCVaverages(double d, double d2, double d3) {
        String string = "---------------------------------------\n\nAve. # Freq. Sets\t= " + this.twoDecPlaces(d) + "\nAvergae Num Updates\t= " + this.twoDecPlaces(d2) + "\nAverage Num CRs\t= " + this.twoDecPlaces(d3) + "\n---------------------------------------";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string + "\n");
        }
    }

    private void ouputTCVparam(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            String string = "(" + (i + 1) + ") # Freq. Sets = " + this.twoDecPlaces(dArray[i][0]) + ",\t# Updates = " + (int)dArray[i][1] + ",\tStoraga = " + (int)dArray[i][2] + ",\t# CARs = " + (int)dArray[i][3];
            if (this.textArea == null) {
                System.out.println(string);
                continue;
            }
            this.textArea.append(string + "\n");
        }
    }

    @Override
    protected void createTtreeLevelN() {
        int n = 2;
        while (this.nextLevelExists) {
            this.addSupportToTtreeLevelN(n);
            this.pruneLevelN(this.startTtreeRef, n);
            this.generateCARs(n);
            if (this.numFrequentSets > 500000) {
                String string = "Level = " + n + ", Number of frequent sets (" + this.numFrequentSets + ") generted so far exceeds limit of " + 500000 + ", generation process stopped!\n";
                if (this.textArea == null) {
                    System.out.println(string);
                    break;
                }
                this.textArea.append(string);
                break;
            }
            if (n > 6) {
                String string = "Current CR antecedent size (" + n + ") exceeds limit of " + 6 + ", generation process stopped!\n";
                if (this.textArea == null) {
                    System.out.println(string);
                    break;
                }
                this.textArea.append(string);
                break;
            }
            this.nextLevelExists = false;
            this.generateLevelN(this.startTtreeRef, n, null);
            ++n;
        }
    }

    protected void generateCARs(int n) {
        for (int i = this.numOneItemSets - this.numClasses + 1; i <= this.numOneItemSets; ++i) {
            Object object;
            if (this.numCarsSoFar > 80000) {
                object = "Number of CARs (" + this.numCarsSoFar + ") generted so far exceeds limit of " + 80000 + ", generation process stopped!\n";
                if (this.textArea == null) {
                    System.out.println((String)object);
                } else {
                    this.textArea.append((String)object);
                }
                return;
            }
            if (this.startTtreeRef[i] == null || this.startTtreeRef[i].childRef == null || !((double)this.startTtreeRef[i].support >= this.minSupport)) continue;
            object = new short[1];
            object[0] = (short)i;
            this.generateCARs(null, i, n - 1, (short[])object, this.startTtreeRef[i].childRef);
        }
    }

    protected void generateCARs(short[] sArray, int n, int n2, short[] sArray2, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return;
        }
        if (n2 == 1) {
            this.generateCARsRightLevel(sArray, n, sArray2, ttreeNodeArray);
        } else {
            this.generateCARsWrongLevel(sArray, n, sArray2, n2, ttreeNodeArray);
        }
    }

    protected void generateCARsRightLevel(short[] sArray, int n, short[] sArray2, TtreeNode[] ttreeNodeArray) {
        for (int i = 1; i < n; ++i) {
            short[] sArray3;
            double d;
            if (ttreeNodeArray[i] == null || !((d = this.getConfidence(sArray3 = this.realloc2(sArray, (short)i), (double)ttreeNodeArray[i].support)) >= this.confidence)) continue;
            ++this.numCarsSoFar;
            this.insertRuleIntoRulelist(sArray3, sArray2, d, ttreeNodeArray[i].support);
        }
    }

    protected void generateCARsWrongLevel(short[] sArray, int n, short[] sArray2, int n2, TtreeNode[] ttreeNodeArray) {
        for (int i = 1; i < n; ++i) {
            if (ttreeNodeArray[i] == null || ttreeNodeArray[i].childRef == null) continue;
            short[] sArray3 = this.realloc2(sArray, (short)i);
            this.generateCARs(sArray3, i, n2 - 1, sArray2, ttreeNodeArray[i].childRef);
        }
    }

    protected void hillClimbing(double d, double d2, double d3, double d4, double d5, int n) {
    }

    protected void idHCoption(double d, double d2) {
        int n = this.getLocationWithBestAccuracy();
        double d3 = this.locData[n].accuracy;
        String string = "Best Accuracy = " + this.twoDecPlaces(d3) + "\n";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string);
        }
        int n2 = this.getNumBestAccuracyLocations(d3);
        if (n2 == 1) {
            this.moveOrZeroIn(n, this.locData[n].suppCoord, this.locData[n].confCoord, d, d2, this.locData[n].accuracy, this.locData[n].numberOfCRs);
            return;
        }
        int n3 = this.getNumAvailableLocations();
        if ((double)n2 >= (double)n3 * 0.6666666666666666) {
            this.endHillClimbing(this.locData[n].suppCoord, this.locData[n].confCoord, d3, this.locData[n].numberOfCRs);
            return;
        }
        this.identifyNewLocation(d, d2, d3);
    }

    private int getLocationWithBestAccuracy() {
        double d = this.locData[8].accuracy;
        int n = 8;
        for (int i = 7; i >= 0; --i) {
            if (!(this.locData[i].accuracy > d)) continue;
            d = this.locData[i].accuracy;
            n = i;
        }
        return n;
    }

    private int getNumBestAccuracyLocations(double d) {
        int n = 0;
        for (int i = 0; i < this.locData.length; ++i) {
            if (!this.similar2dec(this.locData[i].accuracy, d)) continue;
            ++n;
        }
        return n;
    }

    private int getNumAvailableLocations() {
        int n = 0;
        for (int i = 0; i < this.locData.length; ++i) {
            if (!this.locData[i].inArea) continue;
            ++n;
        }
        return n;
    }

    private void endHillClimbing(double d, double d2, double d3, int n) {
        if (this.textArea == null) {
            System.out.println("END");
        } else {
            this.textArea.append("END\n");
        }
        this.support = d;
        this.confidence = d2;
        this.accuracy = d3;
        this.numCRs = n;
    }

    private void moveOrZeroIn(int n, double d, double d2, double d3, double d4, double d5, int n2) {
        if (n == 8) {
            this.zeroInOnSuppAndConf(d, d2, d3, d4, d5, n2);
        } else {
            this.moveToNewLocation(n, d, d2, d3, d4, d5, n2);
        }
    }

    private void identifyNewLocation(double d, double d2, double d3) {
        int n;
        if (this.similar2dec(this.locData[8].accuracy, d3)) {
            this.zeroInOnSuppAndConf(this.locData[8].suppCoord, this.locData[8].confCoord, d, d2, this.locData[8].accuracy, this.locData[8].numberOfCRs);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block10: for (n = 0; n < this.locData.length - 1; ++n) {
            if (!this.similar2dec(this.locData[n].accuracy, d3)) continue;
            switch (n) {
                case 0: {
                    ++n2;
                    continue block10;
                }
                case 1: {
                    ++n2;
                    ++n3;
                    continue block10;
                }
                case 2: {
                    ++n3;
                    continue block10;
                }
                case 3: {
                    ++n4;
                    ++n3;
                    continue block10;
                }
                case 4: {
                    ++n4;
                    continue block10;
                }
                case 5: {
                    ++n4;
                    ++n5;
                    continue block10;
                }
                case 6: {
                    ++n5;
                    continue block10;
                }
                case 7: {
                    ++n2;
                    ++n5;
                }
            }
        }
        n = this.identifyLocation(n2, n3, n4, n5);
        if (!this.similar2dec(this.locData[n].accuracy, d3)) {
            n = this.findNextBestLocation(n, d3);
        }
        this.moveToNewLocation(n, this.locData[n].suppCoord, this.locData[n].confCoord, d, d2, this.locData[n].accuracy, this.locData[n].numberOfCRs);
    }

    private int identifyLocation(int n, int n2, int n3, int n4) {
        int n5 = n > n3 ? (n4 > n2 ? 7 : (n2 > n4 ? 1 : 0)) : (n3 > n ? (n4 > n2 ? 5 : (n2 > n4 ? 3 : 4)) : (n4 > n2 ? 6 : (n2 > n4 ? 2 : 8)));
        return n5;
    }

    private int findNextBestLocation(int n, double d) {
        if (n == 8) {
            n = 0;
        }
        return this.findNextBestLocation(n, n, d);
    }

    private int findNextBestLocation(int n, int n2, double d) {
        n = n == 0 ? 7 : --n;
        if (this.similar2dec(this.locData[n].accuracy, d)) {
            return n;
        }
        n2 = n2 == 7 ? 0 : ++n2;
        if (this.similar2dec(this.locData[n2].accuracy, d)) {
            return n2;
        }
        return this.findNextBestLocation(n, n2, d);
    }

    private void zeroInOnSuppAndConf(double d, double d2, double d3, double d4, double d5, int n) {
        if (this.textArea == null) {
            System.out.println("ZERO IN");
        } else {
            this.textArea.append("ZERO IN\n");
        }
        this.createLoactaionArray();
        this.locData[8] = new HClocData(d, d2, d5, n, true, false);
        if (d3 < this.minimumDiffSupport) {
            for (int i = 0; i < 6; ++i) {
                this.locData[i].inArea = false;
            }
            this.locData[7].inArea = false;
            double d6 = d4 / 2.0;
            this.hillClimbing(d, d2, d3, d6, d5, n);
            return;
        }
        if (d4 < this.minimumDiffConfidence) {
            int n2;
            for (n2 = 1; n2 < 4; ++n2) {
                this.locData[n2].inArea = false;
            }
            for (n2 = 5; n2 < 8; ++n2) {
                this.locData[n2].inArea = false;
            }
            double d7 = d3 / 2.0;
            this.hillClimbing(d, d2, d7, d4, d5, n);
            return;
        }
        double d8 = d4 / 2.0;
        double d9 = d3 / 2.0;
        this.hillClimbing(d, d2, d9, d8, d5, n);
    }

    protected boolean checkSupport(double d) {
        return !(d <= minimumSupAndConfValue) && !(d >= 99.9);
    }

    protected boolean checkConfidence(double d) {
        return !(d <= minimumSupAndConfValue) && !(d >= 99.9);
    }

    protected void moveToNewLocation(int n, double d, double d2, double d3, double d4, double d5, int n2) {
        switch (n) {
            case 0: {
                this.moveLocDataForIncSupp();
                break;
            }
            case 1: {
                this.moveLocDataForIncSuppIncConf();
                break;
            }
            case 2: {
                this.moveLocDataForIncConf();
                break;
            }
            case 3: {
                this.moveLocDataForIncSuppDecConf();
                break;
            }
            case 4: {
                this.moveLocDataForDecSupp();
                break;
            }
            case 5: {
                this.moveLocDataForDecSuppDecConf();
                break;
            }
            case 6: {
                this.moveLocDataForDecConf();
                break;
            }
            case 7: {
                this.moveLocDataForDecSuppIncConf();
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Unexpected hill climbing error", "HILL CLIMBING ERROR", 0);
                System.exit(1);
            }
        }
        if (this.textArea == null) {
            System.out.println("MOVE");
        } else {
            this.textArea.append("MOVE\n");
        }
        this.hillClimbing(d, d2, d3, d4, d5, n2);
    }

    public void createLoactaionArray() {
        this.locData = new HClocData[9];
        for (int i = 0; i < this.locData.length; ++i) {
            this.locData[i] = new HClocData();
        }
    }

    public void moveLocDataForIncSupp() {
        int[] nArray = new int[]{6, 8, 2, 7, 0, 1};
        int[] nArray2 = new int[]{5, 4, 3, 6, 8, 2};
        int[] nArray3 = new int[]{7, 0, 2};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    public void moveLocDataForIncSuppIncConf() {
        int[] nArray = new int[]{8, 0, 1, 2};
        int[] nArray2 = new int[]{5, 6, 8, 4};
        int[] nArray3 = new int[]{7, 0, 1, 2, 3};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    public void moveLocDataForIncConf() {
        int[] nArray = new int[]{0, 8, 4, 1, 2, 3};
        int[] nArray2 = new int[]{7, 6, 5, 0, 8, 4};
        int[] nArray3 = new int[]{1, 2, 3};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    public void moveLocDataForIncSuppDecConf() {
        int[] nArray = new int[]{8, 2, 3, 4};
        int[] nArray2 = new int[]{7, 8, 8, 6};
        int[] nArray3 = new int[]{1, 2, 3, 4, 5};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    public void moveLocDataForDecSupp() {
        int[] nArray = new int[]{6, 8, 2, 5, 4, 3};
        int[] nArray2 = new int[]{7, 0, 1, 6, 8, 2};
        int[] nArray3 = new int[]{5, 4, 3};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    public void moveLocDataForDecSuppDecConf() {
        int[] nArray = new int[]{8, 4, 5, 6};
        int[] nArray2 = new int[]{1, 2, 8, 0};
        int[] nArray3 = new int[]{3, 4, 5, 6, 7};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    public void moveLocDataForDecConf() {
        int[] nArray = new int[]{0, 8, 4, 7, 6, 5};
        int[] nArray2 = new int[]{1, 2, 3, 0, 8, 4};
        int[] nArray3 = new int[]{7, 6, 5};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    public void moveLocDataForDecSuppIncConf() {
        int[] nArray = new int[]{8, 7, 0, 6};
        int[] nArray2 = new int[]{3, 8, 2, 4};
        int[] nArray3 = new int[]{7, 6, 5, 0, 1};
        this.moveLocData(nArray, nArray2);
        this.resetLocData(nArray3);
    }

    private void moveLocData(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            this.locData[nArray2[i]] = this.locData[nArray[i]];
        }
    }

    private void resetLocData(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.locData[nArray[i]] = new HClocData();
        }
    }

    @Override
    public int getNumCRsVersion2() {
        return this.numCRs;
    }

    protected void outputHClocData() {
        String string = "---------------------------------\n";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string);
        }
        String[] stringArray = new String[]{" N", "NE", " E", "SE", " S", "SW", " W", "NW", " C"};
        for (int i = 0; i < this.locData.length; ++i) {
            string = stringArray[i] + ":\tacc = " + this.twoDecPlaces(this.locData[i].accuracy) + ",\tnumCRs = " + this.locData[i].numberOfCRs + ",\tsupp = " + this.twoDecPlaces(this.locData[i].suppCoord) + ",\tconf = " + this.twoDecPlaces(this.locData[i].confCoord) + ",\tinArea = " + this.locData[i].inArea + ",\tnotCalculated = " + this.locData[i].notCalculated + "\n";
            if (this.textArea == null) {
                System.out.println(string);
                continue;
            }
            this.textArea.append(string);
        }
        string = "---------------------------------\n";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string);
        }
    }

    protected class HClocData {
        double suppCoord = 0.0;
        double confCoord = 0.0;
        double accuracy = 0.0;
        int numberOfCRs = 0;
        boolean inArea = true;
        boolean notCalculated = true;

        protected HClocData() {
        }

        protected HClocData(double d, double d2, double d3, int n, boolean bl, boolean bl2) {
            this.suppCoord = d;
            this.confCoord = d2;
            this.accuracy = d3;
            this.numberOfCRs = n;
            this.inArea = bl;
            this.notCalculated = bl2;
        }
    }
}

