% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{eDNA_model-class}
\alias{eDNA_model-class}
\alias{eDNA_model_lm-class}
\alias{eDNA_model_lmer-class}
\title{eDNA model fit results}
\description{
An S4 object holding the results of a model fit by \code{eDNA_lm*}
}
\section{Slots}{

\describe{
\item{\code{ln_conc}}{matrix, the estimated latent variable, log(eDNA concentration)}

\item{\code{Cq_star}}{matrix, the predicted CQ value for each obs}

\item{\code{betas}}{matrix, the posterior estimate for each beta in the model}

\item{\code{sigma_ln_eDNA}}{the estimated measurement error on ln_eDNA}

\item{\code{formula}}{the formula used to fit the model}

\item{\code{x}}{the model.matrix used to fit the model}

\item{\code{std_curve_alpha}}{the alpha for the std. curve conversion formual used}

\item{\code{std_curve_beta}}{the beta for the std. curve conversion formula used}

\item{\code{upper_Cq}}{the upper limit for CQ}

\item{\code{stanfit}}{the result from rstan::sampling}

\item{\code{random_x}}{data.frame of the grouping variables used}

\item{\code{random_sd}}{the estimated stdev. of each of the random effects}
}}

