% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet.R
\name{read_parquet}
\alias{read_parquet}
\title{Read a Parquet file}
\usage{
read_parquet(
  file,
  col_select = NULL,
  as_data_frame = TRUE,
  props = ParquetReaderProperties$create(),
  ...
)
}
\arguments{
\item{file}{A character file name, \code{raw} vector, or an Arrow input stream}

\item{col_select}{A character vector of column names to keep, as in the
"select" argument to \code{data.table::fread()}, or a
\link[tidyselect:vars_select]{tidy selection specification}
of columns, as used in \code{dplyr::select()}.}

\item{as_data_frame}{Should the function return a \code{data.frame} (default) or
an Arrow \link{Table}?}

\item{props}{\link{ParquetReaderProperties}}

\item{...}{Additional arguments passed to \code{ParquetFileReader$create()}}
}
\value{
A \link[=Table]{arrow::Table}, or a \code{data.frame} if \code{as_data_frame} is
\code{TRUE} (the default).
}
\description{
'\href{https://parquet.apache.org/}{Parquet}' is a columnar storage file format.
This function enables you to read Parquet files into R.
}
\examples{
\donttest{
tf <- tempfile()
on.exit(unlink(tf))
write_parquet(mtcars, tf)
df <- read_parquet(tf)
head(df)
}
}
