% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{FileFormat}
\alias{FileFormat}
\alias{ParquetFileFormat}
\alias{IpcFileFormat}
\title{Dataset file formats}
\description{
A \code{FileFormat} holds information about how to read and parse the files
included in a \code{Dataset}. There are subclasses corresponding to the supported
file formats (\code{ParquetFileFormat} and \code{IpcFileFormat}).
}
\section{Factory}{

\code{FileFormat$create()} takes the following arguments:
\itemize{
\item \code{format}: A string identifier of the format of the files in \code{path}.
Currently "parquet" and "ipc"/"arrow"/"feather" (aliases for each other)
are supported. For Feather, only version 2 files are supported.
\item \code{...}: Additional format-specific options
format="parquet":
\itemize{
\item \code{use_buffered_stream}: Read files through buffered input streams rather than
loading entire row groups at once. This may be enabled
to reduce memory overhead. Disabled by default.
\item \code{buffer_size}: Size of buffered stream, if enabled. Default is 8KB.
\item \code{dict_columns}: Names of columns which should be read as dictionaries.
}
}

It returns the appropriate subclass of \code{FileFormat} (e.g. \code{ParquetFileFormat})
}

